/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.net.URI;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;

public class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    public static List<String> parseHeaderValue(String headerValue) {
        ArrayList<String> values = new ArrayList<String>();
        int state = 0;
        StringBuilder sb = new StringBuilder();
        block6: for (char c : headerValue.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block6;
                    if (c == '\"') {
                        state = 2;
                        sb.append(c);
                        continue block6;
                    }
                    sb.append(c);
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if (c != ',') {
                        sb.append(c);
                        continue block6;
                    }
                    values.add(sb.toString());
                    sb = new StringBuilder();
                    state = 0;
                    continue block6;
                }
                case 2: {
                    if (c != '\"') {
                        sb.append(c);
                        continue block6;
                    }
                    sb.append(c);
                    values.add(sb.toString());
                    sb = new StringBuilder();
                    state = 3;
                    continue block6;
                }
                case 3: {
                    if (Character.isWhitespace(c) || c != ',') continue block6;
                    state = 0;
                    continue block6;
                }
            }
        }
        if (sb.length() > 0) {
            values.add(sb.toString());
        }
        return values;
    }

    public static byte[] getRemainingArray(ByteBuffer buffer) {
        if (buffer == null) {
            return new byte[0];
        }
        byte[] ret = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            System.arraycopy(array, buffer.arrayOffset() + buffer.position(), ret, 0, ret.length);
        } else {
            buffer.get(ret);
        }
        return ret;
    }

    public static <T> String getHeaderFromList(List<T> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static <T> List<String> getStringList(List<T> list, Stringifier<T> stringifier) {
        ArrayList<String> result = new ArrayList<String>();
        for (T item : list) {
            if (stringifier != null) {
                result.add(stringifier.toString(item));
                continue;
            }
            result.add(item.toString());
        }
        return result;
    }

    public static <T> String getHeaderFromList(List<T> list, Stringifier<T> stringifier) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            if (stringifier != null) {
                sb.append(stringifier.toString(it.next()));
            } else {
                sb.append(it.next());
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static <T> void checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static byte[] toArray(long value) {
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value > 0L; value >>= 8, --i) {
            b[i] = (byte)(value & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static List<String> toString(byte[] bytes) {
        return Utils.toString(bytes, 0, bytes.length);
    }

    public static List<String> toString(byte[] bytes, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            list.add(Integer.toHexString(bytes[i] & 0xFF).toUpperCase(Locale.US));
        }
        return list;
    }

    public static ByteBuffer appendBuffers(ByteBuffer buffer, ByteBuffer buffer1, int incomingBufferSize, int BUFFER_STEP_SIZE) {
        int limit = buffer.limit();
        int capacity = buffer.capacity();
        int remaining = buffer.remaining();
        int len = buffer1.remaining();
        if (len < capacity - limit) {
            buffer.mark();
            buffer.position(limit);
            buffer.limit(capacity);
            buffer.put(buffer1);
            buffer.limit(limit + len);
            buffer.reset();
            return buffer;
        }
        if (remaining + len < capacity) {
            buffer.compact();
            buffer.put(buffer1);
            buffer.flip();
            return buffer;
        }
        int newSize = remaining + len;
        if (newSize > incomingBufferSize) {
            throw new IllegalArgumentException(LocalizationMessages.BUFFER_OVERFLOW());
        }
        int roundedSize = newSize % BUFFER_STEP_SIZE > 0 ? (newSize / BUFFER_STEP_SIZE + 1) * BUFFER_STEP_SIZE : newSize;
        ByteBuffer result = ByteBuffer.allocate(roundedSize > incomingBufferSize ? newSize : roundedSize);
        result.put(buffer);
        result.put(buffer1);
        result.flip();
        return result;
    }

    public static <T> T getProperty(Map<String, Object> properties, String key, Class<T> type) {
        return Utils.getProperty(properties, key, type, null);
    }

    public static <T> T getProperty(Map<String, Object> properties, String key, Class<T> type, T defaultValue) {
        Object o;
        if (properties != null && (o = properties.get(key)) != null) {
            try {
                if (type.isAssignableFrom(o.getClass())) {
                    return (T)o;
                }
                if (type.equals(Integer.class)) {
                    return (T)Integer.valueOf(o.toString());
                }
                if (type.equals(Long.class)) {
                    return (T)Long.valueOf(o.toString());
                }
                if (type.equals(Boolean.class)) {
                    return (T)Boolean.valueOf(o.toString().equals("1") || Boolean.valueOf(o.toString()) != false);
                }
                return null;
            }
            catch (Throwable t) {
                LOGGER.log(Level.CONFIG, String.format("Invalid type of configuration property of %s (%s), %s cannot be cast to %s", key, o.toString(), o.getClass().toString(), type.toString()));
                return null;
            }
        }
        return defaultValue;
    }

    public static int getWsPort(URI uri) {
        return Utils.getWsPort(uri, uri.getScheme());
    }

    public static int getWsPort(URI uri, String scheme) {
        if (uri.getPort() == -1) {
            if ("wss".equals(scheme)) {
                return 443;
            }
            if ("ws".equals(scheme)) {
                return 80;
            }
        } else {
            return uri.getPort();
        }
        return -1;
    }

    public static Date parseHttpDate(String stringValue) throws ParseException {
        SimpleDateFormat formatRfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            return formatRfc1123.parse(stringValue);
        }
        catch (ParseException e) {
            SimpleDateFormat formatRfc1036 = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz");
            try {
                return formatRfc1036.parse(stringValue);
            }
            catch (ParseException e1) {
                SimpleDateFormat formatAnsiCAsc = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
                return formatAnsiCAsc.parse(stringValue);
            }
        }
    }

    public static abstract class Stringifier<T> {
        abstract String toString(T var1);
    }
}

