/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Writer;

class TyrusServletWriter
extends Writer
implements WriteListener {
    private final TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler;
    private final ArrayBlockingQueue<QueuedFrame> queue = new ArrayBlockingQueue(32);
    private static final Logger LOGGER = Logger.getLogger(TyrusServletWriter.class.getName());
    private final Object outputStreamLock = new Object();
    private ServletOutputStream servletOutputStream = null;
    private volatile boolean isReady = false;

    public TyrusServletWriter(TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler) {
        this.tyrusHttpUpgradeHandler = tyrusHttpUpgradeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWritePossible() throws IOException {
        LOGGER.log(Level.FINEST, "OnWritePossible called");
        QueuedFrame queuedFrame = this.queue.poll();
        this.isReady = true;
        if (queuedFrame == null) {
            return;
        }
        while (this.isReady && queuedFrame != null) {
            this._write(queuedFrame.dataFrame, queuedFrame.completionHandler);
            Object object = this.outputStreamLock;
            synchronized (object) {
                this.isReady = this.servletOutputStream.isReady();
            }
            if (!this.isReady) continue;
            queuedFrame = this.queue.poll();
        }
    }

    public void onError(Throwable t) {
        LOGGER.log(Level.WARNING, "WriteListener.onError", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
        Object object = this.outputStreamLock;
        synchronized (object) {
            if (this.servletOutputStream == null) {
                try {
                    this.servletOutputStream = this.tyrusHttpUpgradeHandler.getWebConnection().getOutputStream();
                }
                catch (IOException e) {
                    LOGGER.log(Level.CONFIG, "ServletOutputStream cannot be obtained", e);
                    completionHandler.failed(e);
                    return;
                }
                this.isReady = this.servletOutputStream.isReady();
                this.servletOutputStream.setWriteListener((WriteListener)this);
            } else {
                this.isReady = this.servletOutputStream.isReady();
            }
        }
        if (this.isReady) {
            this._write(buffer, completionHandler);
        } else {
            QueuedFrame queuedFrame = new QueuedFrame(completionHandler, buffer);
            try {
                this.queue.put(queuedFrame);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.CONFIG, "Cannot enqueue frame", e);
                completionHandler.failed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
        block6: {
            try {
                int remaining = buffer.remaining();
                byte[] array = new byte[remaining];
                buffer.get(array);
                Object object = this.outputStreamLock;
                synchronized (object) {
                    this.servletOutputStream.write(array);
                    this.servletOutputStream.flush();
                }
                if (completionHandler != null) {
                    completionHandler.completed(buffer);
                }
            }
            catch (Exception e) {
                if (completionHandler == null) break block6;
                completionHandler.failed(e);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.tyrusHttpUpgradeHandler.getWebConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class QueuedFrame {
        public final CompletionHandler<ByteBuffer> completionHandler;
        public final ByteBuffer dataFrame;

        QueuedFrame(CompletionHandler<ByteBuffer> completionHandler, ByteBuffer dataFrame) {
            this.completionHandler = completionHandler;
            this.dataFrame = dataFrame;
        }
    }
}

