/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.websockets.ExecutorServiceProvider;

public abstract class BaseContainer
extends ExecutorServiceProvider
implements WebSocketContainer {
    private final ExecutorService executorService = this.newExecutorService();
    private final ScheduledExecutorService scheduledExecutorService = this.newScheduledExecutorService();
    private ThreadFactory threadFactory = null;

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    private ExecutorService newExecutorService() {
        ExecutorService es = null;
        try {
            InitialContext ic = new InitialContext();
            es = (ExecutorService)ic.lookup("java:comp/DefaultManagedExecutorService");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (es == null) {
            if (this.threadFactory == null) {
                this.threadFactory = new DaemonThreadFactory();
            }
            es = Executors.newCachedThreadPool(this.threadFactory);
        }
        return es;
    }

    private ScheduledExecutorService newScheduledExecutorService() {
        ScheduledExecutorService service = null;
        try {
            InitialContext ic = new InitialContext();
            service = (ScheduledExecutorService)ic.lookup("java:comp/DefaultManagedScheduledExecutorService");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (service == null) {
            if (this.threadFactory == null) {
                this.threadFactory = new DaemonThreadFactory();
            }
            service = Executors.newScheduledThreadPool(10, this.threadFactory);
        }
        return service;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "tyrus-" + poolNumber.getAndIncrement() + "-thread-";

        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

