/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.TyrusContainerProvider;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.SPIHandshakeListener;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ClientManager
extends BaseContainer
implements WebSocketContainer {
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.container.grizzly.GrizzlyEngine";
    private static final Logger LOGGER = Logger.getLogger(ClientManager.class.getName());
    private final TyrusContainer engine;
    private final ComponentProviderService componentProvider;
    private final ErrorCollector collector;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private long defaultAsyncSendTimeout;
    private long defaultMaxSessionIdleTimeout;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;

    public static ClientManager createClient() {
        return ClientManager.createClient(ENGINE_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(String engineProviderClassname) {
        return new ClientManager(engineProviderClassname);
    }

    public ClientManager() {
        this(ENGINE_PROVIDER_CLASSNAME);
    }

    private ClientManager(String engineProviderClassname) {
        this.collector = new ErrorCollector();
        this.componentProvider = ComponentProviderService.create();
        Class engineProviderClazz = null;
        try {
            engineProviderClazz = ReflectionHelper.classForNameWithException(engineProviderClassname);
        }
        catch (ClassNotFoundException e) {
            this.collector.addException(e);
        }
        LOGGER.config(String.format("Provider class loaded: %s", engineProviderClassname));
        this.engine = (TyrusContainer)ReflectionHelper.getInstance(engineProviderClazz, this.collector);
        TyrusContainerProvider.getContainerProvider().setContainer(this);
        if (!this.collector.isEmpty()) {
            throw new RuntimeException(this.collector.composeComprehensiveException());
        }
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        if (annotatedEndpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException(String.format("Class argument in connectToServer(Class, URI) is to be annotated endpoint class.Class %s does not have @ClientEndpoint", annotatedEndpointClass.getName()));
        }
        return this.connectToServer((Object)annotatedEndpointClass, null, path.toString());
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(endpointClass, cec, path.toString());
    }

    @Override
    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        return this.connectToServer((Object)endpointInstance, cec, path.toString());
    }

    @Override
    public Session connectToServer(Object obj, URI path) throws DeploymentException {
        return this.connectToServer(obj, null, path.toString());
    }

    public Session connectToServer(Object obj, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.connectToServer(obj, cec, path.toString());
    }

    Session connectToServer(Object o, ClientEndpointConfig configuration, String url) throws DeploymentException {
        ClientEndpointConfig config = null;
        TyrusClientSocket clientSocket = null;
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("ws") && !scheme.equals("wss")) {
                throw new DeploymentException("Incorrect scheme in WebSocket endpoint URI=" + url);
            }
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Incorrect WebSocket endpoint URI=" + url, e);
        }
        final CountDownLatch responseLatch = new CountDownLatch(1);
        try {
            Endpoint endpoint;
            if (o instanceof Endpoint) {
                endpoint = (Endpoint)o;
                config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
            } else if (o instanceof Class) {
                if (Endpoint.class.isAssignableFrom((Class)o)) {
                    endpoint = (Endpoint)ReflectionHelper.getInstance((Class)o, this.collector);
                    config = configuration == null ? ClientEndpointConfig.Builder.create().build() : configuration;
                } else if (((Class)o).getAnnotation(ClientEndpoint.class) != null) {
                    endpoint = AnnotatedEndpoint.fromClass((Class)o, this.componentProvider, false, this.collector);
                    config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
                } else {
                    this.collector.addException(new DeploymentException(String.format("Class %s in not Endpoint descendant and does not have @ClientEndpoint", ((Class)o).getName())));
                    endpoint = null;
                    config = null;
                }
            } else {
                endpoint = AnnotatedEndpoint.fromInstance(o, this.componentProvider, false, this.collector);
                config = (ClientEndpointConfig)((AnnotatedEndpoint)endpoint).getEndpointConfig();
            }
            final ClientEndpointConfig finalConfig = config;
            if (endpoint != null) {
                EndpointWrapper clientEndpoint = new EndpointWrapper(endpoint, (EndpointConfig)config, this.componentProvider, (BaseContainer)this, url, this.collector, null);
                SPIHandshakeListener listener = new SPIHandshakeListener(){

                    @Override
                    public void onResponseHeaders(Map<String, String> originalHeaders) {
                        final TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                return o1.toLowerCase().compareTo(o2.toLowerCase());
                            }
                        });
                        for (Map.Entry<String, String> entry : originalHeaders.entrySet()) {
                            List values = (List)headers.get(entry.getKey());
                            if (values == null) {
                                headers.put(entry.getKey(), Utils.parseHeaderValue(entry.getValue().trim()));
                                continue;
                            }
                            values.addAll(Utils.parseHeaderValue(entry.getValue().trim()));
                        }
                        finalConfig.getConfigurator().afterResponse(new HandshakeResponse(){

                            @Override
                            public Map<String, List<String>> getHeaders() {
                                return headers;
                            }
                        });
                        responseLatch.countDown();
                    }

                    @Override
                    public void onError(Throwable exception) {
                        finalConfig.getUserProperties().put("org.glassfish.tyrus.client.exception", exception);
                        responseLatch.countDown();
                    }
                };
                clientSocket = this.engine.openClientSocket(url, config, clientEndpoint, listener, this.properties);
            }
        }
        catch (Exception e) {
            this.collector.addException(new DeploymentException("Connection failed.", e));
        }
        if (!this.collector.isEmpty()) {
            throw this.collector.composeComprehensiveException();
        }
        if (clientSocket != null) {
            try {
                responseLatch.await(10L, TimeUnit.SECONDS);
                if (responseLatch.getCount() == 0L) {
                    Object exception = config.getUserProperties().get("org.glassfish.tyrus.client.exception");
                    if (exception != null) {
                        throw new DeploymentException("Handshake error.", (Throwable)exception);
                    }
                    Session session = clientSocket.getSession();
                    if (session.isOpen()) {
                        session.setMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize);
                        session.setMaxTextMessageBufferSize(this.maxTextMessageBufferSize);
                        session.setMaxIdleTimeout(this.defaultMaxSessionIdleTimeout);
                    }
                    return session;
                }
            }
            catch (InterruptedException e) {
                throw new DeploymentException("Handshaker response not received.", e);
            }
            throw new DeploymentException("Handshake response not received.");
        }
        return null;
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int i) {
        this.maxBinaryMessageBufferSize = i;
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int i) {
        this.maxTextMessageBufferSize = i;
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    @Override
    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

