/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusServer;

public class TyrusServerContainer
extends BaseContainer
implements WebSocketContainer {
    private final TyrusServer server;
    private final String contextPath;
    private final ServerApplicationConfig configuration;
    private final Set<SPIRegisteredEndpoint> endpoints = new HashSet<SPIRegisteredEndpoint>();
    private final ErrorCollector collector;
    private final ComponentProviderService componentProvider;
    private long defaultMaxSessionIdleTimeout = 0L;
    private long defaultAsyncSendTimeout = 0L;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;

    public TyrusServerContainer(TyrusServer server, String contextPath, Set<Class<?>> classes, Set<Class<?>> dynamicallyAddedClasses, Set<ServerEndpointConfig> dynamicallyAddedEndpointConfigs) {
        this.collector = new ErrorCollector();
        this.server = server;
        this.contextPath = contextPath;
        this.configuration = new TyrusServerConfiguration(classes == null ? Collections.emptySet() : classes, dynamicallyAddedClasses, dynamicallyAddedEndpointConfigs, this.collector);
        this.componentProvider = ComponentProviderService.create();
    }

    public void start() throws IOException, DeploymentException {
        this.server.start();
        try {
            for (Class<?> endpointClass : this.configuration.getAnnotatedEndpointClasses(null)) {
                EndpointConfig config;
                AnnotatedEndpoint endpoint;
                EndpointWrapper ew = new EndpointWrapper(endpoint, config, this.componentProvider, (BaseContainer)this, this.contextPath, this.collector, (config = (endpoint = AnnotatedEndpoint.fromClass(endpointClass, this.componentProvider, true, this.collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null);
                this.deploy(ew);
            }
            for (ServerEndpointConfig serverEndpointConfiguration : this.configuration.getEndpointConfigs(null)) {
                if (serverEndpointConfiguration == null) continue;
                EndpointWrapper ew = new EndpointWrapper(serverEndpointConfiguration.getEndpointClass(), (EndpointConfig)serverEndpointConfiguration, this.componentProvider, (BaseContainer)this, this.contextPath, this.collector, serverEndpointConfiguration.getConfigurator());
                this.deploy(ew);
            }
        }
        catch (DeploymentException de) {
            this.collector.addException(de);
        }
        if (!this.collector.isEmpty()) {
            this.stop();
            throw this.collector.composeComprehensiveException();
        }
    }

    private void deploy(EndpointWrapper wrapper) throws DeploymentException {
        SPIRegisteredEndpoint ge = this.server.register(wrapper);
        this.endpoints.add(ge);
    }

    public void stop() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.server.unregister(wsa);
            Logger.getLogger(this.getClass().getName()).fine("Closing down : " + wsa);
        }
        this.server.stop();
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    @Override
    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
    }
}

