/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.tyrus.container.grizzly.BufferHelper;
import org.glassfish.tyrus.container.grizzly.ConnectionImpl;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.FramingException;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

class WebSocketFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(WebSocketFilter.class);
    private final long wsTimeoutMS;
    private final boolean proxy;
    static final long DEFAULT_WS_IDLE_TIMEOUT_IN_SECONDS = 900L;
    private WebSocketRequest webSocketRequest;

    public WebSocketFilter() {
        this(900L, false);
    }

    public WebSocketFilter(long wsTimeoutInSeconds, boolean proxy) {
        this.wsTimeoutMS = wsTimeoutInSeconds <= 0L ? IdleTimeoutFilter.FOREVER : wsTimeoutInSeconds * 1000L;
        this.proxy = proxy;
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "handleConnect");
        Connection webSocketConnection = WebSocketFilter.getWebSocketConnection(ctx, HttpContent.builder((HttpHeader)HttpRequestPacket.builder().build()).build());
        if (!WebSocketFilter.webSocketInProgress(webSocketConnection)) {
            return ctx.getInvokeAction();
        }
        WebSocketEngine.WebSocketHolder webSocketHolder = WebSocketEngine.getEngine().getWebSocketHolder(webSocketConnection);
        this.webSocketRequest = webSocketHolder.handshake.initiate();
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        if (this.proxy) {
            URI requestURI = this.webSocketRequest.getRequestURI();
            int requestPort = requestURI.getPort() == -1 ? (requestURI.getScheme().equals("wss") ? 443 : 80) : requestURI.getPort();
            builder = builder.uri(String.format("%s:%d", requestURI.getHost(), requestPort));
            builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
            builder = builder.method(Method.CONNECT);
            builder = (HttpRequestPacket.Builder)builder.header(Header.Host, requestURI.getHost());
            builder = (HttpRequestPacket.Builder)builder.header(Header.ProxyConnection, "keep-alive");
            builder = (HttpRequestPacket.Builder)builder.header(Header.Connection, "keep-alive");
            ctx.write((Object)HttpContent.builder((HttpHeader)builder.build()).build());
            ctx.flush(null);
        } else {
            ctx.write((Object)this.getHttpContent(this.webSocketRequest));
            ctx.flush(null);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        WebSocket ws;
        Connection connection = WebSocketFilter.getWebSocketConnection(ctx, HttpContent.builder((HttpHeader)HttpRequestPacket.builder().build()).build());
        if (WebSocketFilter.webSocketInProgress(connection) && (ws = WebSocketFilter.getWebSocket(connection)) != null) {
            ws.close();
            WebSocketEngine.getEngine().removeConnection(connection);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        block15: {
            HttpContent message = (HttpContent)ctx.getMessage();
            Connection connection = WebSocketFilter.getWebSocketConnection(ctx, message);
            HttpHeader header = message.getHttpHeader();
            WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(connection);
            WebSocket ws = WebSocketFilter.getWebSocket(connection);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{ws, message.getContent().remaining(), header});
            }
            if (ws == null || !ws.isConnected()) {
                if (!message.getHttpHeader().isRequest()) {
                    HttpStatus httpStatus = ((HttpResponsePacket)message.getHttpHeader()).getHttpStatus();
                    if (this.proxy && httpStatus.getStatusCode() != 101) {
                        if (httpStatus != HttpStatus.OK_200) {
                            throw new HandshakeException(String.format("Proxy error. %s: %s", httpStatus.getStatusCode(), new String(httpStatus.getReasonPhraseBytes())));
                        }
                        ctx.write((Object)this.getHttpContent(this.webSocketRequest));
                        ctx.flush(null);
                        return ctx.getInvokeAction();
                    }
                }
                if (!WebSocketFilter.webSocketInProgress(connection) && !"websocket".equalsIgnoreCase(header.getUpgrade())) {
                    return ctx.getInvokeAction();
                }
                String ATTR_NAME = "org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED";
                AttributeHolder attributeHolder = ctx.getAttributes();
                if (attributeHolder != null) {
                    Object attribute = attributeHolder.getAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED");
                    if (attribute != null) {
                        return ctx.getInvokeAction();
                    }
                    attributeHolder.setAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED", (Object)true);
                }
                return this.handleHandshake(ctx, message);
            }
            if (message.getContent().hasRemaining()) {
                Buffer buffer = message.getContent();
                message.recycle();
                ByteBuffer webSocketBuffer = BufferHelper.convertBuffer(buffer);
                try {
                    while (webSocketBuffer != null && webSocketBuffer.hasRemaining()) {
                        DataFrame result;
                        if (holder.buffer != null) {
                            buffer = BufferHelper.appendBuffers(holder.buffer, buffer);
                            holder.buffer = null;
                        }
                        if ((result = holder.handler.unframe(webSocketBuffer)) == null) {
                            holder.buffer = webSocketBuffer;
                            break;
                        }
                        result.respond(holder.webSocket);
                    }
                }
                catch (FramingException e) {
                    holder.webSocket.onClose(new ClosingFrame(e.getClosingCode(), e.getMessage()));
                }
                catch (Exception wse) {
                    if (!holder.application.onError(holder.webSocket, wse)) break block15;
                    holder.webSocket.onClose(new ClosingFrame(1011, wse.getMessage()));
                }
            }
        }
        return ctx.getStopAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = WebSocketFilter.getWebSocketConnection(ctx, null);
        WebSocket websocket = WebSocketFilter.getWebSocket(connection);
        if (websocket != null) {
            DataFrame frame = (DataFrame)ctx.getMessage();
            WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(connection);
            Buffer wrap = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])holder.handler.frame(frame));
            ctx.setMessage((Object)wrap);
            ctx.flush(null);
        }
        return ctx.getInvokeAction();
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        return content.getHttpHeader().isRequest() ? this.handleServerHandshake(ctx, content) : this.handleClientHandShake(ctx, content);
    }

    private NextAction handleClientHandShake(FilterChainContext ctx, HttpContent content) {
        WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(WebSocketFilter.getWebSocketConnection(ctx, content));
        if (holder == null) {
            content.recycle();
            return ctx.getStopAction();
        }
        try {
            WebSocketResponse webSocketResponse = WebSocketFilter.getWebSocketResponse((HttpResponsePacket)content.getHttpHeader());
            holder.handshake.validateServerResponse(webSocketResponse);
            holder.handshake.getResponseListener().onResponseHeaders(webSocketResponse.getHeaders());
            holder.webSocket.onConnect();
        }
        catch (HandshakeException e) {
            holder.handshake.getResponseListener().onError(e);
        }
        if (content.getContent().hasRemaining()) {
            return ctx.getRerunFilterAction();
        }
        content.recycle();
        return ctx.getStopAction();
    }

    private static WebSocketResponse getWebSocketResponse(HttpResponsePacket httpResponsePacket) {
        WebSocketResponse webSocketResponse = new WebSocketResponse();
        for (String name : httpResponsePacket.getHeaders().names()) {
            webSocketResponse.getHeaders().put(name, httpResponsePacket.getHeader(name));
        }
        webSocketResponse.setStatus(httpResponsePacket.getStatus());
        return webSocketResponse;
    }

    private NextAction handleServerHandshake(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        Connection webSocketConnection = WebSocketFilter.getWebSocketConnection(ctx, requestContent);
        try {
            if (!WebSocketEngine.getEngine().upgrade(webSocketConnection, WebSocketFilter.createWebSocketRequest(ctx, requestContent))) {
                return ctx.getInvokeAction();
            }
            this.setIdleTimeout(ctx);
        }
        catch (HandshakeException e) {
            ctx.write((Object)WebSocketFilter.composeHandshakeError(request, e));
        }
        ctx.flush(null);
        requestContent.recycle();
        return ctx.getStopAction();
    }

    private static WebSocket getWebSocket(Connection connection) {
        return WebSocketEngine.getEngine().getWebSocket(connection);
    }

    private static boolean webSocketInProgress(Connection connection) {
        return WebSocketEngine.getEngine().webSocketInProgress(connection);
    }

    private static HttpResponsePacket composeHandshakeError(HttpRequestPacket request, HandshakeException e) {
        HttpResponsePacket response = request.getResponse();
        response.setStatus(e.getCode());
        response.setReasonPhrase(e.getMessage());
        return response;
    }

    private void setIdleTimeout(FilterChainContext ctx) {
        FilterChain filterChain = ctx.getFilterChain();
        if (filterChain.indexOfType(IdleTimeoutFilter.class) >= 0) {
            IdleTimeoutFilter.setCustomTimeout((org.glassfish.grizzly.Connection)ctx.getConnection(), (long)this.wsTimeoutMS, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private HttpContent getHttpContent(WebSocketRequest request) {
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
        builder = builder.method(Method.GET);
        builder = builder.uri(request.getRequestPath());
        for (String key : request.getHeaders().keySet()) {
            builder.header(key, request.getFirstHeaderValue(key));
        }
        return HttpContent.builder((HttpHeader)builder.build()).build();
    }

    private static Connection getWebSocketConnection(FilterChainContext ctx, HttpContent httpContent) {
        return new ConnectionImpl(ctx, httpContent);
    }

    private static WebSocketRequest createWebSocketRequest(FilterChainContext ctx, HttpContent requestContent) {
        HttpRequestPacket requestPacket = (HttpRequestPacket)requestContent.getHttpHeader();
        RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(requestPacket.getRequestURI())).queryString(requestPacket.getQueryString()).connection(WebSocketFilter.getWebSocketConnection(ctx, requestContent)).secure(requestPacket.isSecure()).build();
        for (String name : requestPacket.getHeaders().names()) {
            requestContext.putSingleHeader(name, requestPacket.getHeader(name));
        }
        return requestContext;
    }
}

