/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;

public abstract class HandShake {
    private static final String HEADER_SEPARATOR = ", ";
    private static final Logger LOGGER = Logger.getLogger(HandShake.class.getName());
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private String location;
    private List<String> subProtocols = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private WebSocketRequest request;
    private HandShakeResponseListener responseListener;
    private WebSocketRequest incomingRequest;

    protected HandShake(WebSocketRequest webSocketRequest, boolean client) {
        this.request = webSocketRequest;
        URI uri = webSocketRequest.getRequestURI();
        this.resourcePath = uri.getPath();
        if ("".equals(this.resourcePath)) {
            this.resourcePath = "/";
        }
        if (uri.getQuery() != null) {
            this.resourcePath = this.resourcePath + "?" + uri.getQuery();
        }
        this.serverHostName = uri.getHost();
        this.secure = this.request.isSecure();
        this.port = uri.getPort();
        this.origin = this.appendPort(new StringBuilder(uri.getHost())).toString();
        this.buildLocation();
        this.prepareRequest();
    }

    protected HandShake(WebSocketRequest request) {
        this.incomingRequest = request;
        this.checkForHeader(request.getFirstHeaderValue("Upgrade"), "Upgrade", "WebSocket");
        this.checkForHeader(request.getFirstHeaderValue("Connection"), "Connection", "Upgrade");
        this.origin = request.getFirstHeaderValue("Sec-WebSocket-Origin");
        if (this.origin == null) {
            this.origin = request.getFirstHeaderValue("Origin");
        }
        this.determineHostAndPort(request);
        String protocolHeader = request.getFirstHeaderValue("Sec-WebSocket-Protocol");
        List<Object> list = this.subProtocols = protocolHeader == null ? Collections.emptyList() : Arrays.asList(protocolHeader.split(","));
        if (this.serverHostName == null) {
            throw new HandshakeException("Missing required headers for WebSocket negotiation");
        }
        this.resourcePath = request.getRequestURI().toString();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            this.resourcePath = this.resourcePath + "?" + queryString;
        }
        this.buildLocation();
    }

    final void buildLocation() {
        StringBuilder builder = new StringBuilder((this.isSecure() ? "wss" : "ws") + "://" + this.serverHostName);
        this.appendPort(builder);
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            builder.append("/");
        }
        builder.append(this.resourcePath);
        this.location = builder.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    protected String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    String getResourcePath() {
        return this.resourcePath;
    }

    boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    String getServerHostName() {
        return this.serverHostName;
    }

    void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }

    protected List<String> getSubProtocols() {
        return this.subProtocols;
    }

    protected <T> String getHeaderFromList(List<T> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(HEADER_SEPARATOR);
        }
        return sb.toString();
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols = subProtocols;
    }

    private void sanitize(List<String> strings) {
        if (strings != null) {
            for (int i = 0; i < strings.size(); ++i) {
                strings.set(i, strings.get(i) == null ? null : strings.get(i).trim());
            }
        }
    }

    protected List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    protected final String joinExtensions(List<Extension> extensions) {
        StringBuilder sb = new StringBuilder();
        for (Extension e : extensions) {
            if (sb.length() != 0) {
                sb.append(HEADER_SEPARATOR);
            }
            sb.append(e.toString());
        }
        return sb.toString();
    }

    protected String join(List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            if (builder.length() != 0) {
                builder.append(HEADER_SEPARATOR);
            }
            builder.append(s);
        }
        return builder.toString();
    }

    private void checkForHeader(String currentValue, String header, String validValue) {
        this.validate(header, validValue, currentValue);
    }

    private void validate(String header, String validValue, String value) {
        if (header.equalsIgnoreCase("Connection") ? !value.toLowerCase().contains(validValue.toLowerCase()) : !value.equalsIgnoreCase(validValue)) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    private void determineHostAndPort(WebSocketRequest request) {
        int i;
        String header = request.getFirstHeaderValue("Host");
        int n = i = header == null ? -1 : header.indexOf(":");
        if (i == -1) {
            this.setServerHostName(header);
            this.setPort(80);
        } else {
            this.setServerHostName(header.substring(0, i));
            this.setPort(Integer.valueOf(header.substring(i + 1)));
        }
    }

    public WebSocketRequest getRequest() {
        return this.request;
    }

    public WebSocketRequest prepareRequest() {
        String host = this.getServerHostName();
        if (this.port != -1 && this.port != 80 && this.port != 443) {
            host = host + ":" + this.getPort();
        }
        this.request.setRequestPath(this.getResourcePath());
        this.request.putSingleHeader("Host", host);
        this.request.putSingleHeader("Connection", "Upgrade");
        this.request.putSingleHeader("Upgrade", "websocket");
        if (!this.getSubProtocols().isEmpty()) {
            this.request.putSingleHeader("Sec-WebSocket-Protocol", this.getHeaderFromList(this.subProtocols));
        }
        if (!this.getExtensions().isEmpty()) {
            this.request.putSingleHeader("Sec-WebSocket-Extensions", this.getHeaderFromList(this.extensions));
        }
        return this.request;
    }

    public void validateServerResponse(WebSocketResponse response) {
        if (101 != response.getStatus()) {
            throw new HandshakeException(String.format("Response code was not %s: %s", 101, response.getStatus()));
        }
        this.checkForHeader(response.getHeaders().get("Upgrade"), "Upgrade", "websocket");
        this.checkForHeader(response.getHeaders().get("Connection"), "Connection", "Upgrade");
    }

    void respond(Connection connection, WebSocketApplication application) {
        List<Extension> intersection;
        List<String> appProtocols;
        WebSocketResponse response = new WebSocketResponse();
        response.setStatus(101);
        response.getHeaders().put("Upgrade", "websocket");
        response.getHeaders().put("Connection", "Upgrade");
        this.setHeaders(response);
        if (this.subProtocols != null && !this.subProtocols.isEmpty() && !(appProtocols = application.getSupportedProtocols(this.subProtocols)).isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Protocol", this.getHeaderFromList(appProtocols));
        }
        if (!(application.getSupportedExtensions().isEmpty() || this.getExtensions().isEmpty() || (intersection = this.intersection(this.getExtensions(), application.getSupportedExtensions())).isEmpty())) {
            application.onExtensionNegotiation(intersection);
            response.getHeaders().put("Sec-WebSocket-Extensions", this.getHeaderFromList(intersection));
        }
        application.onHandShakeResponse(this.incomingRequest, response);
        connection.write(response);
    }

    protected abstract void setHeaders(WebSocketResponse var1);

    protected final List<String> split(String header) {
        if (header == null) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(header.split(","));
        this.sanitize(list);
        return list;
    }

    List<Extension> intersection(List<Extension> requested, List<Extension> supported) {
        ArrayList<Extension> intersection = new ArrayList<Extension>(supported.size());
        block0: for (Extension e : requested) {
            for (Extension s : supported) {
                if (!e.getName().equals(s.getName())) continue;
                intersection.add(e);
                continue block0;
            }
        }
        return intersection;
    }

    public static List<Extension> fromString(String s) {
        return HandShake.fromHeaders(Arrays.asList(s));
    }

    protected static List<Extension> fromHeaders(List<String> extensionHeaders) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String singleHeader : extensionHeaders) {
            Extension extension;
            if (singleHeader == null) break;
            char[] chars = singleHeader.toCharArray();
            int i = 0;
            ParserState next = ParserState.NAME_START;
            StringBuilder name = new StringBuilder();
            StringBuilder paramName = new StringBuilder();
            StringBuilder paramValue = new StringBuilder();
            ArrayList<Extension.Parameter> params = new ArrayList<Extension.Parameter>();
            do {
                block0 : switch (next) {
                    case NAME_START: {
                        if (name.length() > 0) {
                            extension = new Extension(name.toString().trim());
                            extension.getParameters().addAll(params);
                            extensions.add(extension);
                            name = new StringBuilder();
                            paramName = new StringBuilder();
                            paramValue = new StringBuilder();
                            params.clear();
                        }
                        next = ParserState.NAME;
                    }
                    case NAME: {
                        switch (chars[i]) {
                            case ';': {
                                next = ParserState.PARAM_NAME;
                                break block0;
                            }
                            case ',': {
                                next = ParserState.NAME_START;
                                break block0;
                            }
                            case '=': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                        }
                        name.append(chars[i]);
                        break;
                    }
                    case PARAM_NAME: {
                        switch (chars[i]) {
                            case ';': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                            case '=': {
                                next = ParserState.PARAM_VALUE;
                                break block0;
                            }
                        }
                        paramName.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE: {
                        switch (chars[i]) {
                            case '\"': {
                                if (paramValue.length() > 0) {
                                    next = ParserState.ERROR;
                                    break block0;
                                }
                                next = ParserState.PARAM_VALUE_QUOTED;
                                break block0;
                            }
                            case ';': {
                                next = ParserState.PARAM_NAME;
                                params.add(new Extension.Parameter(paramName.toString().trim(), paramValue.toString().trim()));
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                break block0;
                            }
                            case ',': {
                                next = ParserState.NAME_START;
                                params.add(new Extension.Parameter(paramName.toString().trim(), paramValue.toString().trim()));
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                break block0;
                            }
                            case '=': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                        }
                        paramValue.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE_QUOTED: {
                        switch (chars[i]) {
                            case '\"': {
                                next = ParserState.PARAM_VALUE_QUOTED_POST;
                                params.add(new Extension.Parameter(paramName.toString().trim(), paramValue.toString()));
                                paramName = new StringBuilder();
                                paramValue = new StringBuilder();
                                break block0;
                            }
                            case '\\': {
                                next = ParserState.PARAM_VALUE_QUOTED_QP;
                                break block0;
                            }
                            case '=': {
                                next = ParserState.ERROR;
                                break block0;
                            }
                        }
                        paramValue.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE_QUOTED_QP: {
                        next = ParserState.PARAM_VALUE_QUOTED;
                        paramValue.append(chars[i]);
                        break;
                    }
                    case PARAM_VALUE_QUOTED_POST: {
                        switch (chars[i]) {
                            case ',': {
                                next = ParserState.NAME_START;
                                break block0;
                            }
                            case ';': {
                                next = ParserState.PARAM_NAME;
                                break block0;
                            }
                        }
                        next = ParserState.ERROR;
                        break;
                    }
                    case ERROR: {
                        LOGGER.fine(String.format("Error during parsing Extension: %s", name));
                        if (name.length() > 0) {
                            name = new StringBuilder();
                            paramName = new StringBuilder();
                            paramValue = new StringBuilder();
                            params.clear();
                        }
                        switch (chars[i]) {
                            case ',': {
                                next = ParserState.NAME_START;
                                break block0;
                            }
                            case ';': {
                                next = ParserState.PARAM_NAME;
                            }
                        }
                    }
                }
            } while (++i < chars.length);
            if (name.length() > 0 && next != ParserState.ERROR) {
                if (paramName.length() > 0) {
                    params.add(new Extension.Parameter(paramName.toString().trim(), paramValue.toString()));
                }
                extension = new Extension(name.toString().trim());
                extension.getParameters().addAll(params);
                extensions.add(extension);
                params.clear();
                continue;
            }
            LOGGER.fine(String.format("Unable to parse Extension: %s", name));
        }
        return extensions;
    }

    public WebSocketRequest initiate() {
        return this.getRequest();
    }

    private StringBuilder appendPort(StringBuilder builder) {
        if (this.isSecure()) {
            if (this.port != 443 && this.port != -1) {
                builder.append(':').append(this.port);
            }
        } else if (this.port != 80 && this.port != -1) {
            builder.append(':').append(this.port);
        }
        return builder;
    }

    public void setResponseListener(HandShakeResponseListener responseListener) {
        this.responseListener = responseListener;
    }

    public HandShakeResponseListener getResponseListener() {
        return this.responseListener;
    }

    public static interface HandShakeResponseListener {
        public void onResponseHeaders(Map<String, String> var1);

        public void onError(HandshakeException var1);
    }

    private static enum ParserState {
        NAME_START,
        NAME,
        PARAM_NAME,
        PARAM_VALUE,
        PARAM_VALUE_QUOTED,
        PARAM_VALUE_QUOTED_POST,
        PARAM_VALUE_QUOTED_QP,
        ERROR;

    }
}

