/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.WebConnection;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.server.ServerContainerFactory;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.ConnectionImpl;
import org.glassfish.tyrus.servlet.ServletContainer;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.servlet.TyrusServletContainerInitializer;
import org.glassfish.tyrus.servlet.TyrusServletServerContainer;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.WebSocketEngine;

public class TyrusServletFilter
implements Filter {
    private static final int INFORMATIONAL_FIXED_PORT = 8080;
    private static final Logger LOGGER = Logger.getLogger(TyrusServletFilter.class.getName());
    private final WebSocketEngine engine = WebSocketEngine.getEngine();
    private TyrusServerContainer serverContainer = null;
    private boolean registered = false;
    private Set<Class<?>> classes = null;
    private ServletContext servletContext = null;
    private final Set<Class<?>> dynamicallyDeployedClasses = new HashSet();
    private final Set<ServerEndpointConfig> dynamicallyDeployedServerEndpointConfigs = new HashSet<ServerEndpointConfig>();

    void addClass(Class<?> clazz) {
        if (this.serverContainer != null) {
            throw new IllegalStateException("Filter already initiated.");
        }
        this.dynamicallyDeployedClasses.add(clazz);
        this.checkFilterRegistration();
    }

    void addServerEndpointConfig(ServerEndpointConfig serverEndpointConfig) {
        if (this.serverContainer != null) {
            throw new IllegalStateException("Filter already initiated.");
        }
        this.dynamicallyDeployedServerEndpointConfigs.add(serverEndpointConfig);
        this.checkFilterRegistration();
    }

    private void checkFilterRegistration() {
        if (this.servletContext != null && !this.registered) {
            this.registered = true;
            FilterRegistration.Dynamic reg = this.servletContext.addFilter("WebSocket filter", (Filter)this);
            reg.setAsyncSupported(true);
            reg.addMappingForUrlPatterns(null, true, new String[]{"/*"});
            TyrusServletContainerInitializer.LOGGER.info("Registering WebSocket filter for url pattern /*");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String contextRoot = filterConfig.getServletContext().getContextPath();
        this.serverContainer = ServerContainerFactory.create(ServletContainer.class, contextRoot, 8080, this.classes, this.dynamicallyDeployedClasses, this.dynamicallyDeployedServerEndpointConfigs);
        try {
            this.serverContainer.start();
        }
        catch (Exception e) {
            throw new ServletException("Web socket server initialization failed.", (Throwable)e);
        }
        finally {
            ServerContainer container = (ServerContainer)filterConfig.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
            if (container instanceof TyrusServletServerContainer) {
                ((TyrusServletServerContainer)container).doneDeployment();
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String header = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (header != null) {
            LOGGER.fine("Setting up WebSocket protocol handler");
            final TyrusHttpUpgradeHandlerProxy handler = new TyrusHttpUpgradeHandlerProxy();
            final ConnectionImpl webSocketConnection = new ConnectionImpl(handler, httpServletResponse);
            RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(httpServletRequest.getRequestURI())).queryString(httpServletRequest.getQueryString()).connection(webSocketConnection).requestPath(httpServletRequest.getServletPath()).httpSession(httpServletRequest.getSession()).secure(httpServletRequest.isSecure()).userPrincipal(httpServletRequest.getUserPrincipal()).isUserInRoleDelegate(new RequestContext.Builder.IsUserInRoleDelegate(){

                @Override
                public boolean isUserInRole(String role) {
                    return httpServletRequest.isUserInRole(role);
                }
            }).build();
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                requestContext.getHeaders().put(key, Arrays.asList(httpServletRequest.getHeader(key)));
            }
            try {
                if (!this.engine.upgrade(webSocketConnection, requestContext, new WebSocketEngine.WebSocketHolderListener(){

                    @Override
                    public void onWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) throws HandshakeException {
                        LOGGER.fine("Upgrading Servlet request");
                        try {
                            handler.setHandler((TyrusHttpUpgradeHandler)httpServletRequest.upgrade(TyrusHttpUpgradeHandler.class));
                        }
                        catch (Exception e) {
                            throw new HandshakeException(500, "Handshake error.", e);
                        }
                        handler.setWebSocketHolder(TyrusServletFilter.this.engine.getWebSocketHolder(webSocketConnection));
                    }
                })) {
                    filterChain.doFilter(request, response);
                    return;
                }
            }
            catch (HandshakeException e) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
            response.flushBuffer();
            LOGGER.fine("Handshake Complete");
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.serverContainer.stop();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setClasses(Set<Class<?>> classes) {
        this.classes = classes;
    }

    private class TyrusHttpUpgradeHandlerProxy
    extends TyrusHttpUpgradeHandler {
        private TyrusHttpUpgradeHandler handler;

        private TyrusHttpUpgradeHandlerProxy() {
        }

        @Override
        public void init(WebConnection wc) {
            this.handler.init(wc);
        }

        @Override
        public void onDataAvailable() {
            this.handler.onDataAvailable();
        }

        @Override
        public void onAllDataRead() {
            this.handler.onAllDataRead();
        }

        @Override
        public void onError(Throwable t) {
            this.handler.onError(t);
        }

        @Override
        public void destroy() {
            this.handler.destroy();
        }

        @Override
        public void setWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) {
            this.handler.setWebSocketHolder(webSocketHolder);
        }

        @Override
        WebConnection getWebConnection() {
            return this.handler.getWebConnection();
        }

        void setHandler(TyrusHttpUpgradeHandler handler) {
            this.handler = handler;
        }
    }
}

