/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.util.Map;
import java.util.concurrent.Future;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.WriteFuture;
import org.glassfish.tyrus.websockets.frametypes.ClosingFrameType;

class ConnectionImpl
extends Connection {
    private final TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler;
    private final HttpServletResponse httpServletResponse;

    public ConnectionImpl(TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler, HttpServletResponse httpServletResponse) {
        this.tyrusHttpUpgradeHandler = tyrusHttpUpgradeHandler;
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public Future<DataFrame> write(DataFrame frame, Connection.CompletionHandler<DataFrame> completionHandler) {
        WriteFuture<DataFrame> future = new WriteFuture<DataFrame>();
        try {
            ServletOutputStream outputStream = this.tyrusHttpUpgradeHandler.getWebConnection().getOutputStream();
            byte[] bytes = WebSocketEngine.getEngine().getWebSocketHolder((Connection)this).handler.frame(frame);
            outputStream.write(bytes);
            outputStream.flush();
            if (completionHandler != null) {
                completionHandler.completed(frame);
            }
            future.setResult(frame);
            if (frame.getType() instanceof ClosingFrameType) {
                this.tyrusHttpUpgradeHandler.getWebConnection().close();
            }
        }
        catch (Exception e) {
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            future.setFailure(e);
        }
        return future;
    }

    @Override
    public void write(WebSocketResponse response) {
        this.httpServletResponse.setStatus(response.getStatus());
        for (Map.Entry<String, String> entry : response.getHeaders().entrySet()) {
            this.httpServletResponse.addHeader(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addCloseListener(Connection.CloseListener closeListener) {
    }

    @Override
    public void closeSilently() {
        try {
            this.tyrusHttpUpgradeHandler.getWebConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getUnderlyingConnection() {
        return null;
    }
}

