/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.server.TyrusRemoteEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.DefaultWebSocket;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public class TyrusEndpoint
extends WebSocketApplication
implements SPIRegisteredEndpoint {
    private final SPIEndpoint endpoint;
    private List<Extension> temporaryNegotiatedExtensions;
    private String temporaryNegotiatedProtocol;

    public TyrusEndpoint(SPIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public boolean isApplicationRequest(WebSocketRequest webSocketRequest) {
        List<String> protocolsList;
        String protocols = webSocketRequest.getFirstHeaderValue("Sec-WebSocket-Protocol");
        if (protocols == null) {
            protocolsList = Collections.emptyList();
        } else {
            protocolsList = new ArrayList();
            for (String s : Arrays.asList(protocols.split(","))) {
                protocolsList.add(s.trim());
            }
        }
        this.temporaryNegotiatedProtocol = this.endpoint.getNegotiatedProtocol(protocolsList);
        List<Extension> extensions = TyrusExtension.fromString(webSocketRequest.getFirstHeaderValue("Sec-WebSocket-Extensions"));
        this.temporaryNegotiatedExtensions = this.endpoint.getNegotiatedExtensions(extensions);
        return this.endpoint.checkHandshake(webSocketRequest instanceof RequestContext ? (RequestContext)webSocketRequest : null);
    }

    @Override
    public String getPath() {
        return this.endpoint.getEndpointPath();
    }

    @Override
    public WebSocket createSocket(ProtocolHandler handler, WebSocketRequest requestPacket, WebSocketListener ... listeners) {
        handler.setContainer(this.endpoint.getWebSocketContainer());
        return new DefaultWebSocket(handler, requestPacket, listeners);
    }

    @Override
    public void onConnect(WebSocket socket) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onConnect(gs, this.temporaryNegotiatedProtocol, this.temporaryNegotiatedExtensions);
    }

    @Override
    public void onFragment(WebSocket socket, String fragment, boolean last) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((SPIRemoteEndpoint)gs, fragment, last);
        }
        catch (Throwable t) {
            Logger.getLogger(TyrusEndpoint.class.getName()).severe("Error !!!" + t);
            t.printStackTrace();
        }
    }

    @Override
    public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((SPIRemoteEndpoint)gs, ByteBuffer.wrap(fragment), last);
        }
        catch (Throwable t) {
            Logger.getLogger(TyrusEndpoint.class.getName()).severe("Error !!!" + t);
            t.printStackTrace();
        }
    }

    @Override
    public void onMessage(WebSocket socket, String messageString) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, messageString);
    }

    @Override
    public void onMessage(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    @Override
    public void onClose(WebSocket socket, ClosingFrame frame) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        CloseReason closeReason = null;
        if (frame != null) {
            closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode(frame.getCode()), frame.getReason() == null ? "" : frame.getReason());
        }
        this.endpoint.onClose(gs, closeReason);
        TyrusRemoteEndpoint.remove(socket);
    }

    @Override
    public void onPong(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onPong(gs, ByteBuffer.wrap(bytes));
    }

    @Override
    public void remove() {
        this.endpoint.remove();
    }

    @Override
    public Set<Session> getOpenSessions() {
        return this.endpoint.getOpenSessions();
    }

    @Override
    public void onExtensionNegotiation(List<org.glassfish.tyrus.websockets.Extension> extensions) {
    }

    @Override
    public List<org.glassfish.tyrus.websockets.Extension> getSupportedExtensions() {
        ArrayList<org.glassfish.tyrus.websockets.Extension> grizzlyExtensions = new ArrayList<org.glassfish.tyrus.websockets.Extension>();
        for (Extension ext : this.temporaryNegotiatedExtensions) {
            org.glassfish.tyrus.websockets.Extension extension = new org.glassfish.tyrus.websockets.Extension(ext.getName());
            for (Extension.Parameter p : ext.getParameters()) {
                extension.getParameters().add(new Extension.Parameter(p.getName(), p.getValue()));
            }
            grizzlyExtensions.add(extension);
        }
        return grizzlyExtensions;
    }

    @Override
    public boolean onError(WebSocket webSocket, Throwable t) {
        Logger.getLogger(TyrusEndpoint.class.getName()).log(Level.WARNING, "onError!", t);
        return true;
    }

    @Override
    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> result;
        if (this.temporaryNegotiatedProtocol == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            result.add(this.temporaryNegotiatedProtocol);
        }
        return result;
    }

    @Override
    public void onPing(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onPing(gs, ByteBuffer.wrap(bytes));
    }

    @Override
    public void onHandShakeResponse(WebSocketRequest request, WebSocketResponse response) {
        EndpointConfig configuration = this.endpoint.getEndpointConfig();
        if (configuration instanceof ServerEndpointConfig) {
            HandshakeResponse handshakeResponse = this.createHandshakeResponse(response);
            ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)configuration;
            serverEndpointConfig.getConfigurator().modifyHandshake(serverEndpointConfig, this.createHandshakeRequest(request), handshakeResponse);
            for (Map.Entry<String, List<String>> entry : handshakeResponse.getHeaders().entrySet()) {
                if (entry.getValue() == null) continue;
                response.getHeaders().put(entry.getKey(), entry.getValue().get(0));
            }
        }
    }

    private HandshakeRequest createHandshakeRequest(WebSocketRequest webSocketRequest) {
        if (webSocketRequest instanceof RequestContext) {
            return (HandshakeRequest)((Object)webSocketRequest);
        }
        return null;
    }

    private HandshakeResponse createHandshakeResponse(WebSocketResponse webSocketResponse) {
        final TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        for (Map.Entry<String, String> entry : webSocketResponse.getHeaders().entrySet()) {
            headers.put(entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return new HandshakeResponse(){

            @Override
            public Map<String, List<String>> getHeaders() {
                return headers;
            }
        };
    }
}

