/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.Reader;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.BufferedStringReader;
import org.glassfish.tyrus.core.InputStreamBuffer;
import org.glassfish.tyrus.core.MessageTooBigException;

class ReaderBuffer {
    private LinkedBlockingQueue<Character> queue = new LinkedBlockingQueue();
    private boolean receivedLast = false;
    private BufferedStringReader reader = null;
    private MessageHandler.Whole<Reader> messageHandler;
    private final Object lock = new Object();
    private int bufferSize;
    private int currentlyBuffered = 0;
    private boolean buffering = true;
    private static final Logger LOGGER = Logger.getLogger(InputStreamBuffer.class.getName());

    public void setMessageHandler(MessageHandler.Whole<Reader> messageHandler) {
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockOnReaderThread() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public char[] getNextChars(int number) {
        if (this.queue.isEmpty()) {
            if (this.receivedLast) {
                this.reader = null;
                this.currentlyBuffered = 0;
                this.buffering = true;
                return null;
            }
            this.blockOnReaderThread();
        }
        char[] chrs = new char[number > this.queue.size() ? this.queue.size() : number];
        for (int i = 0; i < chrs.length; ++i) {
            chrs[i] = this.queue.poll().charValue();
        }
        return chrs;
    }

    public void finishReading() {
        this.queue = new LinkedBlockingQueue();
        this.reader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(String message, boolean last) {
        Object object = this.lock;
        synchronized (object) {
            this.receivedLast = last;
            this.currentlyBuffered += message.length();
            if (this.currentlyBuffered <= this.bufferSize) {
                char[] chars;
                for (char c : chars = message.toCharArray()) {
                    this.queue.add(Character.valueOf(c));
                }
            } else if (this.buffering) {
                this.buffering = false;
                MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
                LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.lock.notifyAll();
        }
        if (this.reader == null) {
            this.reader = new BufferedStringReader(this);
            Thread t = new Thread(){

                @Override
                public void run() {
                    ReaderBuffer.this.messageHandler.onMessage(ReaderBuffer.this.reader);
                }
            };
            t.start();
        }
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentlyBuffered = 0;
        this.buffering = true;
        this.queue.clear();
    }
}

