/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.BufferedInputStream;
import org.glassfish.tyrus.core.MessageTooBigException;

class InputStreamBuffer {
    private List<ByteBuffer> bufferedFragments = new ArrayList<ByteBuffer>();
    private boolean receivedLast = false;
    private BufferedInputStream inputStream = null;
    private MessageHandler.Whole<InputStream> messageHandler;
    private final Object lock = new Object();
    private int bufferSize;
    private int currentlyBuffered = 0;
    private static final Logger LOGGER = Logger.getLogger(InputStreamBuffer.class.getName());

    private void blockOnReaderThread() {
        try {
            this.lock.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getNextByte() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferedFragments.isEmpty()) {
                if (this.receivedLast) {
                    this.inputStream = null;
                    this.currentlyBuffered = 0;
                    return -1;
                }
                this.blockOnReaderThread();
            }
            ByteBuffer firstBuffer = this.bufferedFragments.get(0);
            byte result = firstBuffer.get();
            if (!firstBuffer.hasRemaining()) {
                this.bufferedFragments.remove(0);
            }
            return result;
        }
    }

    public void finishReading() {
        this.bufferedFragments = new ArrayList<ByteBuffer>();
        this.inputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(ByteBuffer message, boolean last) {
        Object object = this.lock;
        synchronized (object) {
            this.currentlyBuffered += message.remaining();
            if (this.currentlyBuffered > this.bufferSize) {
                MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
                LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.bufferedFragments.add(message);
            this.receivedLast = last;
            this.lock.notifyAll();
        }
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(this);
            Thread t = new Thread(){

                @Override
                public void run() {
                    InputStreamBuffer.this.messageHandler.onMessage(InputStreamBuffer.this.inputStream);
                }
            };
            t.start();
        }
    }

    public void setMessageHandler(MessageHandler.Whole<InputStream> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentlyBuffered = 0;
        this.bufferedFragments.clear();
    }
}

