/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.coord.common.CoordinationContextBuilder;
import com.sun.xml.ws.tx.coord.common.types.CoordinationContextIF;
import com.sun.xml.ws.tx.coord.v11.WSATCoordinationContextBuilderImpl;

public abstract class WSATCoordinationContextBuilder {
    protected String coordinationType;
    protected String identifier;
    protected long expires;
    protected String registrationCoordinatorAddress;
    protected String txId;
    protected boolean mustUnderstand = false;
    protected SOAPVersion soapVersion = SOAPVersion.SOAP_11;

    protected WSATCoordinationContextBuilder() {
    }

    public static WSATCoordinationContextBuilder newInstance(Transactional.Version version) {
        if (Transactional.Version.WSAT10 == version) {
            return new com.sun.xml.ws.tx.coord.v10.WSATCoordinationContextBuilderImpl();
        }
        if (Transactional.Version.WSAT11 == version || Transactional.Version.WSAT12 == version) {
            return new WSATCoordinationContextBuilderImpl();
        }
        throw new IllegalArgumentException(version + "is not a supported ws-at version");
    }

    public WSATCoordinationContextBuilder txId(String txId) {
        this.txId = txId;
        return this;
    }

    public WSATCoordinationContextBuilder registrationCoordinatorAddress(String registrationCoordinatorAddress) {
        this.registrationCoordinatorAddress = registrationCoordinatorAddress;
        return this;
    }

    public WSATCoordinationContextBuilder soapVersion(SOAPVersion soapVersion) {
        if (soapVersion == null) {
            throw new IllegalArgumentException("SOAP version can't null!");
        }
        this.soapVersion = soapVersion;
        return this;
    }

    public WSATCoordinationContextBuilder mustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
        return this;
    }

    public WSATCoordinationContextBuilder expires(long expires) {
        this.expires = expires;
        return this;
    }

    public CoordinationContextIF build() {
        CoordinationContextBuilder builder = this.configBuilder();
        return builder.build();
    }

    private CoordinationContextBuilder configBuilder() {
        if (this.registrationCoordinatorAddress == null) {
            this.registrationCoordinatorAddress = this.getDefaultRegistrationCoordinatorAddress();
        }
        CoordinationContextBuilder builder = this.newCoordinationContextBuilder();
        builder.coordinationType(this.getCoordinationType()).address(this.registrationCoordinatorAddress).identifier("urn:uuid:" + this.txId).txId(this.txId).expires(this.expires).soapVersion(this.soapVersion).mustUnderstand(this.mustUnderstand);
        return builder;
    }

    protected abstract CoordinationContextBuilder newCoordinationContextBuilder();

    protected abstract String getCoordinationType();

    protected abstract String getDefaultRegistrationCoordinatorAddress();
}

