/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common;

import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATImplInjection;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterResponseType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.xml.ws.WebServiceException;

public class PendingRequestManager {
    private static final Class LOGGERCLASS = PendingRequestManager.class;
    static ConcurrentHashMap<String, ResponseBox> pendingRequests = new ConcurrentHashMap();

    public static ResponseBox reqisterRequest(String msgId) {
        ResponseBox box = new ResponseBox();
        pendingRequests.put(msgId, box);
        return box;
    }

    public static void removeRequest(String msgId) {
        pendingRequests.remove(msgId);
    }

    public static void registryReponse(String msgId, BaseRegisterResponseType repsonse) {
        ResponseBox box;
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.FINE, "WSAT4620_GET_RESPONSE_REQUEST", (Object)msgId, null);
        }
        if ((box = pendingRequests.remove(msgId)) != null) {
            box.put(repsonse);
        } else if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.FINE, "WSAT4621_IGNORE_RESPONSE", (Object)msgId, null);
        }
    }

    public static class ResponseBox {
        private boolean isSet = false;
        private BaseRegisterResponseType type;

        ResponseBox() {
        }

        public synchronized void put(BaseRegisterResponseType type) {
            this.type = type;
            this.isSet = true;
            this.notify();
        }

        public synchronized BaseRegisterResponseType getResponse(long timeout) {
            long start = System.currentTimeMillis();
            while (!this.isSet) {
                try {
                    this.wait(timeout);
                    long end = System.currentTimeMillis();
                    if ((timeout -= end - start) <= 0L) break;
                    start = end;
                }
                catch (InterruptedException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            return this.type;
        }
    }
}

