/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATImplInjection;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import java.util.logging.Level;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;

public class WSATSynchronization
implements Synchronization {
    private static final Class LOGGERCLASS = WSATSynchronization.class;
    Xid m_xid;
    String m_status = "UNKNOWN";
    private static final String UNKNOWN = "UNKNOWN";
    boolean m_isRemovedFromMap = false;
    Transactional.Version m_version;
    EndpointReference m_epr;

    public WSATSynchronization(EndpointReference epr, Xid xid) {
        this(Transactional.Version.WSAT10, epr, xid);
    }

    public WSATSynchronization(Transactional.Version version, EndpointReference epr, Xid xid) {
        this.m_version = version;
        this.m_xid = xid;
        this.m_epr = epr;
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT_4526_WSAT_SYNCHRONIZATION", new Object[]{this.m_epr.toString(), this.m_xid, ""}, null);
        }
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT_4527_BEFORE_COMPLETION_ENTERED", new Object[]{this.m_epr.toString(), this.m_xid}, null);
        }
        try {
            WSATHelper.getInstance().beforeCompletion(this.m_epr, this.m_xid, this);
            WSATSynchronization wSATSynchronization = this;
            synchronized (wSATSynchronization) {
                block17: {
                    if (!this.m_status.equals("Committed")) break block17;
                    if (WSATHelper.isDebugEnabled()) {
                        WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT_4528_BEFORE_COMPLETION_COMMITTED_BEFORE_WAIT", new Object[]{this.m_epr.toString(), this.m_xid}, null);
                    }
                    return;
                }
                if (WSATHelper.isDebugEnabled()) {
                    WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT_4529_BEFORE_COMPLETION_WAITING_FOR_REPLY", new Object[]{this.m_epr.toString(), this.m_xid}, null);
                }
                this.wait(WSATHelper.getInstance().getWaitForReplyTimeout());
                if (WSATHelper.isDebugEnabled()) {
                    WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT_4530_BEFORE_COMPLETION_FINISHED_WAITING_FOR_REPLY", new Object[]{this.m_epr.toString(), this.m_xid}, null);
                }
            }
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4531_BEFORE_COMPLETION_RECEIVED_REPLY_WITH_STATUS", new Object[]{this.m_status, this.m_epr.toString(), this.m_xid}, null);
            if (!this.m_status.equals("Committed")) {
                WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.SEVERE, "WSAT4532_BEFORE_COMPLETION_UNEXCEPTED_STATUS", new Object[]{this.m_status, this.m_epr.toString(), this.m_xid}, null);
                this.setRollbackOnly();
            }
        }
        catch (InterruptedException e) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.SEVERE, "WSAT4533_BEFORE_COMPLETION_INTERRUPTED_EXCEPTION", new Object[]{this.m_epr.toString(), this.m_xid}, null);
            this.setRollbackOnly();
        }
        catch (Exception e) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.SEVERE, "WSAT4534_BEFORE_COMPLETION_EXCEPTION", new Object[]{this.m_epr.toString(), this.m_xid}, null);
            this.setRollbackOnly();
        }
        finally {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
            this.m_isRemovedFromMap = true;
        }
    }

    private void setRollbackOnly() {
        try {
            Transaction transaction = TransactionManagerImpl.getInstance().getTransaction();
            if (transaction != null) {
                transaction.setRollbackOnly();
            } else {
                WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4536_BEFORE_COMPLETION_TRANSACTION_NULL_DURING_SET_ROLLBACK_ONLY", new Object[]{this.m_epr.toString(), this.m_xid}, null);
            }
        }
        catch (SystemException e) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.WARNING, "WSAT4535_BEFORE_COMPLETION_SYSTEM_EXCEPTION_DURING_SET_ROLLBACK_ONLY", new Object[]{e, this.m_epr.toString(), this.m_xid}, null);
        }
    }

    public void afterCompletion(int status) {
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4537_AFTER_COMPLETION_STATUS", new Object[]{this.m_epr.toString(), this.m_xid, "" + status}, null);
        }
    }

    Xid getXid() {
        return this.m_xid;
    }

    public boolean equals(Object obj) {
        return obj instanceof WSATSynchronization && ((WSATSynchronization)obj).getXid().equals(this.m_xid);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            WSATHelper.getInstance().removeVolatileParticipant(this.m_xid);
        }
    }
}

