/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.impl.kerberos.KerberosLogin;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.PasswordCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.SAMLValidator;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.impl.misc.LogStringsMessages;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.util.XWSSUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSecurityEnvironmentImpl
implements SecurityEnvironment {
    private static final long offset;
    protected static final Logger log;
    private final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    private CallbackHandler callbackHandler = null;
    private boolean isDefaultHandler = false;
    private X509Certificate selfCertificate = null;
    private Properties configAssertions = null;
    private long maxNonceAge = 900000L;
    private String mnaProperty = null;
    private String JAASLoginModuleForKeystore;
    private Subject loginContextSubjectForKeystore;
    private String keyStoreCBH;
    private CallbackHandler keystoreCbHandlerClass;

    public DefaultSecurityEnvironmentImpl(CallbackHandler cHandler) {
        this.callbackHandler = cHandler;
        if (this.callbackHandler instanceof DefaultCallbackHandler) {
            this.isDefaultHandler = true;
        }
    }

    public DefaultSecurityEnvironmentImpl(CallbackHandler cHandler, Properties confAssertions) {
        this.configAssertions = confAssertions;
        this.callbackHandler = cHandler;
        if (this.callbackHandler instanceof DefaultCallbackHandler) {
            this.isDefaultHandler = true;
        }
        this.mnaProperty = this.configAssertions.getProperty("max.nonce.age");
        if (this.mnaProperty != null) {
            try {
                this.maxNonceAge = SecurityUtil.toLong(this.mnaProperty);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.FINE, " Exception while converting maxNonceAge config property, Setting MaxNonceAge to Default value {0}", 900000L);
                this.maxNonceAge = 900000L;
            }
        }
        this.JAASLoginModuleForKeystore = this.configAssertions.getProperty("jaas.loginmodule.for.keystore");
        this.keyStoreCBH = this.configAssertions.getProperty("keystore.callback.handler");
        this.loginContextSubjectForKeystore = this.initJAASKeyStoreLoginModule();
    }

    @Override
    public X509Certificate getDefaultCertificate(Map context) throws XWSSecurityException {
        X509Certificate cert = this.getPublicCredentialsFromLCSubject();
        if (cert != null) {
            return cert;
        }
        X509Certificate defaultCert = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (context != null) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.DefaultPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        defaultCert = privKeyRequest.getX509Certificate();
        if (defaultCert == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0218_CANNOT_LOCATE_DEFAULT_CERT());
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultCert;
    }

    public SignatureKeyCallback.PrivKeyCertRequest getDefaultPrivKeyCertRequest(Map context) throws XWSSecurityException {
        X500PrivateCredential cred;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (context != null) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        if ((cred = this.getPKCredentialsFromLCSubject()) != null) {
            privKeyRequest.setX509Certificate(cred.getCertificate());
            privKeyRequest.setPrivateKey(cred.getPrivateKey());
            return privKeyRequest;
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.DefaultPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return privKeyRequest;
    }

    public SignatureKeyCallback.AliasPrivKeyCertRequest getAliasPrivKeyCertRequest(String certIdentifier) throws XWSSecurityException {
        SignatureKeyCallback.AliasPrivKeyCertRequest request = new SignatureKeyCallback.AliasPrivKeyCertRequest(certIdentifier);
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null && certIdentifier.equals(cred.getAlias())) {
            request.setX509Certificate(cred.getCertificate());
            request.setPrivateKey(cred.getPrivateKey());
            return request;
        }
        SignatureKeyCallback sigCallback = new SignatureKeyCallback(request);
        Callback[] callback = new Callback[]{sigCallback};
        try {
            this.callbackHandler.handle(callback);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.AliasPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return request;
    }

    public PrivateKey getDefaultPrivateKey(Map context) throws XWSSecurityException {
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null) {
            return cred.getPrivateKey();
        }
        PrivateKey defaultPrivKey = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (context != null) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.DefaultPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        defaultPrivKey = privKeyRequest.getPrivateKey();
        if (defaultPrivKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0219_CANNOT_LOCATE_DEFAULT_PRIVKEY());
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultPrivKey;
    }

    @Override
    public SecretKey getSecretKey(Map context, String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKey symmetricKey = null;
        if (encryptMode) {
            EncryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new EncryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback(symmKeyRequest);
            ProcessingContext.copy(encKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("EncryptionKeyCallback.AliasSymmetricKeyRequest"), new Object[]{"EncryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
                throw new XWSSecurityException((Throwable)e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        } else {
            DecryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new DecryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(symmKeyRequest);
            ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{decryptKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("DecryptionKeyCallback.AliasSymmetricKeyRequest"), new Object[]{"DecryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
                throw new XWSSecurityException((Throwable)e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        }
        if (symmetricKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0220_CANNOT_LOCATE_SYMMETRICKEY_FOR_DECRYPT());
            throw new XWSSecurityException("Could not locate the symmetric key for alias '" + alias + "'");
        }
        return symmetricKey;
    }

    @Override
    public X509Certificate getCertificate(Map context, String alias, boolean forSigning) throws XWSSecurityException {
        Object certRequest;
        X509Certificate cert = null;
        if (alias == null || "".equals(alias) && forSigning) {
            return this.getDefaultCertificate(context);
        }
        cert = this.getPublicCredentialsFromLCSubject();
        if (cert != null) {
            return cert;
        }
        if (forSigning) {
            certRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
            SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback((SignatureKeyCallback.Request)certRequest);
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{sigKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.AliasPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
                throw new XWSSecurityException((Throwable)e);
            }
            cert = ((SignatureKeyCallback.PrivKeyCertRequest)certRequest).getX509Certificate();
        } else {
            certRequest = new EncryptionKeyCallback.AliasX509CertificateRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback((EncryptionKeyCallback.Request)certRequest);
            ProcessingContext.copy(encKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("EncryptionKeyCallback.AliasX509CertificateRequest"), new Object[]{"EncryptionKeyCallback.AliasX509CertificateRequest"});
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
                throw new XWSSecurityException((Throwable)e);
            }
            cert = ((EncryptionKeyCallback.X509CertificateRequest)certRequest).getX509Certificate();
        }
        if (cert == null) {
            String val = forSigning ? "Signature" : "Key Encryption";
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(val), new Object[]{val});
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + alias + "'");
        }
        return cert;
    }

    @Override
    public X509Certificate getCertificate(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        X509Certificate cert = this.getPublicCredentialsFromLCSubject();
        if (cert != null && cert.getPublicKey().equals(publicKey)) {
            return cert;
        }
        if (!forSign) {
            SignatureVerificationKeyCallback.PublicKeyBasedRequest pubKeyReq = new SignatureVerificationKeyCallback.PublicKeyBasedRequest(publicKey);
            SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(pubKeyReq);
            ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{verifyKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureVerificationKeyCallback.PublicKeyBasedRequest"), new Object[]{"SignatureVerificationKeyCallback.PublicKeyBasedRequest"});
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
                throw new XWSSecurityException((Throwable)e);
            }
            return pubKeyReq.getX509Certificate();
        }
        EncryptionKeyCallback.PublicKeyBasedRequest pubKeyReq = new EncryptionKeyCallback.PublicKeyBasedRequest(publicKey);
        EncryptionKeyCallback encCallback = new EncryptionKeyCallback(pubKeyReq);
        ProcessingContext.copy(encCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{encCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("EncryptionKeyCallback.PublicKeyBasedRequest"), new Object[]{"EncryptionKeyCallback.PublicKeyBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return pubKeyReq.getX509Certificate();
    }

    @Override
    public PrivateKey getPrivateKey(Map context, String alias) throws XWSSecurityException {
        PrivateKey privKey = null;
        if (alias == null) {
            return this.getDefaultPrivateKey(context);
        }
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null && cred.getAlias().equals(alias)) {
            return cred.getPrivateKey();
        }
        SignatureKeyCallback.AliasPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.AliasPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        privKey = privKeyRequest.getPrivateKey();
        if (privKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0222_CANNOT_LOCATE_PRIVKEY(alias), new Object[]{alias});
            throw new XWSSecurityException("Unable to locate private key for the alias " + alias);
        }
        return privKey;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getPrivateKey(context, identifier);
        }
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        try {
            if (cred != null && this.matchesThumbPrint(Base64.decode(identifier), cred.getCertificate())) {
                return cred.getPrivateKey();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityException((Throwable)ex);
        }
        PrivateKey privateKey = null;
        DecryptionKeyCallback.ThumbprintBasedRequest privKeyRequest = new DecryptionKeyCallback.ThumbprintBasedRequest(identifier);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("DecryptionKeyCallback.ThumbprintBasedRequest"), new Object[]{"DecryptionKeyCallback.ThumbprintBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0222_CANNOT_LOCATE_PRIVKEY(identifier), new Object[]{identifier});
            throw new XWSSecurityException("No Matching private key for " + Base64.encode(identifier) + " thumb print identifier found");
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        PrivateKey privateKey = null;
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        try {
            if (cred != null && this.matchesKeyIdentifier(Base64.decode(keyIdentifier), cred.getCertificate())) {
                return cred.getPrivateKey();
            }
        }
        catch (Base64DecodingException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new XWSSecurityException((Throwable)ex);
        }
        DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest privKeyRequest = new DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest"), new Object[]{"DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0222_CANNOT_LOCATE_PRIVKEY(keyIdentifier), new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching private key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null) {
            X509Certificate x509Cert = cred.getCertificate();
            BigInteger serialNo = x509Cert.getSerialNumber();
            X500Principal currentIssuerPrincipal = x509Cert.getIssuerX500Principal();
            X500Principal issuerPrincipal = new X500Principal(issuerName);
            if (serialNo.equals(serialNumber) && currentIssuerPrincipal.equals(issuerPrincipal)) {
                return cred.getPrivateKey();
            }
        }
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509IssuerSerialBasedRequest privKeyRequest = new DecryptionKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("DecryptionKeyCallback.X509IssuerSerialBasedRequest"), new Object[]{"DecryptionKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0222_CANNOT_LOCATE_PRIVKEY(serialNumber + ":" + issuerName), new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching private key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return privateKey;
    }

    @Override
    public PublicKey getPublicKey(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        return this.getCertificate(context, identifier, valueType).getPublicKey();
    }

    @Override
    public PublicKey getPublicKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        return this.getCertificate(context, keyIdentifier).getPublicKey();
    }

    @Override
    public X509Certificate getCertificate(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getCertificate(context, identifier);
        }
        X509Certificate cert = null;
        cert = this.getPublicCredentialsFromLCSubject();
        try {
            if (cert != null && this.matchesThumbPrint(Base64.decode(identifier), cert)) {
                return cert;
            }
        }
        catch (Base64DecodingException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0816_BASE_64_DECODING_ERROR(), ex);
            throw new XWSSecurityException((Throwable)ex);
        }
        SignatureVerificationKeyCallback.ThumbprintBasedRequest certRequest = new SignatureVerificationKeyCallback.ThumbprintBasedRequest(identifier);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureVerificationKeyCallback.ThumbprintBasedRequest"), new Object[]{"SignatureVerificationKeyCallback.ThumbprintBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(identifier), new Object[]{identifier});
            throw new XWSSecurityException("No Matching public key for " + Base64.encode(identifier) + " thumb print identifier found");
        }
        return cert;
    }

    @Override
    public X509Certificate getCertificate(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        X509Certificate cert = null;
        cert = this.getPublicCredentialsFromLCSubject();
        try {
            if (cert != null && this.matchesKeyIdentifier(Base64.decode(keyIdentifier), cert)) {
                return cert;
            }
        }
        catch (Base64DecodingException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0816_BASE_64_DECODING_ERROR(), ex);
            throw new XWSSecurityException((Throwable)ex);
        }
        SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest certRequest = new SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest"), new Object[]{"SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(keyIdentifier), new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching public key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return cert;
    }

    @Override
    public PublicKey getPublicKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getCertificate(context, serialNumber, issuerName).getPublicKey();
    }

    @Override
    public X509Certificate getCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X509Certificate cert = null;
        cert = this.getPublicCredentialsFromLCSubject();
        if (cert != null) {
            BigInteger serialNo = cert.getSerialNumber();
            X500Principal currentIssuerPrincipal = cert.getIssuerX500Principal();
            X500Principal issuerPrincipal = new X500Principal(issuerName);
            if (serialNo.equals(serialNumber) && currentIssuerPrincipal.equals(issuerPrincipal)) {
                return cert;
            }
        }
        SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest certRequest = new SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest"), new Object[]{"SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0221_CANNOT_LOCATE_CERT(serialNumber + ":" + issuerName), new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching public key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return cert;
    }

    @Override
    public boolean validateCertificate(X509Certificate cert, Map context) {
        CertificateValidationCallback certValCallback = new CertificateValidationCallback(cert, context);
        Callback[] callbacks = new Callback[]{certValCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0223_FAILED_CERTIFICATE_VALIDATION());
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Certificate Validation called on certificate {0}", cert.getSubjectX500Principal());
        }
        return certValCallback.getResult();
    }

    @Override
    public void updateOtherPartySubject(Subject subject, String username, String password) {
    }

    private X500PrivateCredential getPKCredentialsFromLCSubject() {
        Iterator<X500PrivateCredential> it;
        Set<X500PrivateCredential> set;
        if (this.loginContextSubjectForKeystore != null && (set = this.loginContextSubjectForKeystore.getPrivateCredentials(X500PrivateCredential.class)) != null && (it = set.iterator()).hasNext()) {
            return it.next();
        }
        return null;
    }

    private X509Certificate getPublicCredentialsFromLCSubject() {
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null) {
            return cred.getCertificate();
        }
        return null;
    }

    private Subject initJAASKeyStoreLoginModule() {
        if (this.JAASLoginModuleForKeystore == null) {
            return null;
        }
        LoginContext lc = null;
        try {
            if (this.keyStoreCBH != null) {
                this.keystoreCbHandlerClass = (CallbackHandler)this.loadClass(this.keyStoreCBH).getConstructor(new Class[0]).newInstance(new Object[0]);
                lc = new LoginContext(this.JAASLoginModuleForKeystore, this.keystoreCbHandlerClass);
            } else {
                lc = new LoginContext(this.JAASLoginModuleForKeystore);
            }
            lc.login();
            return lc.getSubject();
        }
        catch (XWSSecurityException | ReflectiveOperationException | LoginException ex) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0817_KEYSTORE_LOGIN_MODULE_LOGIN_ERROR(), ex);
            throw new XWSSecurityRuntimeException(ex);
        }
    }

    private boolean matchesKeyIdentifier(byte[] keyIdMatch, X509Certificate x509Cert) throws XWSSecurityException {
        byte[] keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    private boolean matchesThumbPrint(byte[] keyIdMatch, X509Certificate x509Cert) throws XWSSecurityException {
        byte[] keyId = XWSSUtil.getThumbprintIdentifier(x509Cert);
        if (keyId == null) {
            return false;
        }
        return Arrays.equals(keyIdMatch, keyId);
    }

    private void updateUsernameInSubject(final Subject subject, final String username, String password) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String x500Name = "CN=" + username;
                X500Principal principal = null;
                try {
                    principal = new X500Principal(x500Name);
                    subject.getPrincipals().add(principal);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                subject.getPublicCredentials().add(username);
                return null;
            }
        });
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final X509Certificate cert) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                X500Principal principal = cert.getSubjectX500Principal();
                subject.getPrincipals().add(principal);
                subject.getPublicCredentials().add(cert);
                return null;
            }
        });
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final Assertion assertion) {
        if (this.callbackHandler instanceof DefaultCallbackHandler && ((DefaultCallbackHandler)this.callbackHandler).getSAMLValidator() instanceof SAMLValidator) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(Subject subject, Key secretKey) {
    }

    public void updateOtherPartySubject(Subject subject, String ek) {
    }

    public static Subject getSubject(final Map context) {
        Subject otherPartySubject = (Subject)context.get("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                Subject otherPartySubj = new Subject();
                context.put("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    public static Subject getSubject(final FilterProcessingContext context) {
        Subject otherPartySubject = (Subject)context.getExtraneousProperty("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                Subject otherPartySubj = new Subject();
                context.setExtraneousProperty("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, X509Certificate cert) throws XWSSecurityException {
        X509Certificate x509Cert;
        PrivateKey privateKey = null;
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null && (x509Cert = cred.getCertificate()).equals(cert)) {
            return cred.getPrivateKey();
        }
        DecryptionKeyCallback.X509CertificateBasedRequest privateKeyRequest = new DecryptionKeyCallback.X509CertificateBasedRequest(cert);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privateKeyRequest);
        ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("DecryptionKeyCallback.X509CertificateBasedRequest"), new Object[]{"DecryptionKeyCallback.X509CertificateBasedRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        privateKey = privateKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0222_CANNOT_LOCATE_PRIVKEY("given certificate"), new Object[]{"given certificate"});
            throw new XWSSecurityException("Could not retrieve private Key matching the given certificate");
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        Object req;
        X509Certificate x509Cert;
        X500PrivateCredential cred = this.getPKCredentialsFromLCSubject();
        if (cred != null && (x509Cert = cred.getCertificate()).getPublicKey().equals(publicKey)) {
            return cred.getPrivateKey();
        }
        if (forSign) {
            req = new SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest(publicKey);
            SignatureKeyCallback skc = new SignatureKeyCallback((SignatureKeyCallback.Request)req);
            ProcessingContext.copy(skc.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{skc};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest"), new Object[]{"SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest"});
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
                throw new XWSSecurityException((Throwable)e);
            }
            return ((SignatureKeyCallback.PrivKeyCertRequest)req).getPrivateKey();
        }
        req = new DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest(publicKey);
        DecryptionKeyCallback dkc = new DecryptionKeyCallback((DecryptionKeyCallback.Request)req);
        ProcessingContext.copy(dkc.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{dkc};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest"), new Object[]{"DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return ((DecryptionKeyCallback.PrivateKeyRequest)req).getPrivateKey();
    }

    @Override
    public Subject getSubject() {
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0224_UNSUPPORTED_ASSOCIATED_SUBJECT());
        throw new UnsupportedOperationException("This environment does not have an associated Subject");
    }

    @Override
    public boolean authenticateUser(Map context, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        boolean result;
        block6: {
            PasswordValidationCallback.DigestPasswordRequest request = new PasswordValidationCallback.DigestPasswordRequest(username, passwordDigest, nonce, created);
            PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
            ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{passwordValidationCallback};
            result = false;
            try {
                this.callbackHandler.handle(callbacks);
                RealmAuthenticationAdapter adapter = passwordValidationCallback.getRealmAuthenticationAdapter();
                if (passwordValidationCallback.getValidator() != null) {
                    result = passwordValidationCallback.getResult();
                    if (result) {
                        this.updateUsernameInSubject(DefaultSecurityEnvironmentImpl.getSubject(context), username, null);
                    }
                    break block6;
                }
                if (adapter != null) {
                    result = adapter.authenticate(DefaultSecurityEnvironmentImpl.getSubject(context), username, passwordDigest, nonce, created, context);
                    break block6;
                }
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0295_PASSWORD_VAL_NOT_CONFIG_USERNAME_VAL());
                throw new XWSSecurityException("Error: No PasswordValidator Configured for UsernameToken Validation");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
                throw new XWSSecurityException((Throwable)e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Username Authentication done for {0}", username);
        }
        return result;
    }

    @Override
    public boolean authenticateUser(Map context, String username, String password) throws XWSSecurityException {
        boolean result;
        block5: {
            PasswordValidationCallback.PlainTextPasswordRequest request = new PasswordValidationCallback.PlainTextPasswordRequest(username, password);
            PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
            ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{passwordValidationCallback};
            result = false;
            try {
                this.callbackHandler.handle(callbacks);
                RealmAuthenticationAdapter adapter = passwordValidationCallback.getRealmAuthenticationAdapter();
                if (passwordValidationCallback.getValidator() != null) {
                    result = passwordValidationCallback.getResult();
                    if (result) {
                        this.updateUsernameInSubject(DefaultSecurityEnvironmentImpl.getSubject(context), username, password);
                    }
                    break block5;
                }
                if (adapter != null) {
                    result = adapter.authenticate(DefaultSecurityEnvironmentImpl.getSubject(context), username, password, context);
                    break block5;
                }
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0295_PASSWORD_VAL_NOT_CONFIG_USERNAME_VAL());
                throw new XWSSecurityException("Error: No PasswordValidator Configured for UsernameToken Validation");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
                throw new XWSSecurityException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String authenticateUser(Map context, String username) throws XWSSecurityException {
        PasswordValidationCallback.DerivedKeyPasswordRequest request = new PasswordValidationCallback.DerivedKeyPasswordRequest(username);
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
        ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{passwordValidationCallback};
        boolean result = false;
        try {
            this.callbackHandler.handle(callbacks);
            RealmAuthenticationAdapter adapter = passwordValidationCallback.getRealmAuthenticationAdapter();
            if (passwordValidationCallback.getValidator() != null && (result = passwordValidationCallback.getResult())) {
                this.updateUsernameInSubject(DefaultSecurityEnvironmentImpl.getSubject(context), username, null);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return request.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultValidateCreationTime(String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        Date created = null;
        try {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = this.calendarFormatter1.parse(creationTime);
            }
        }
        catch (ParseException e) {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
            synchronized (simpleDateFormat) {
                try {
                    created = this.calendarFormatter2.parse(creationTime);
                }
                catch (ParseException ex) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0226_FAILED_VALIDATING_DEFAULT_CREATION_TIME(), ex);
                    throw new XWSSecurityException((Throwable)ex);
                }
            }
        }
        Date current = DefaultSecurityEnvironmentImpl.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0227_INVALID_OLDER_CREATION_TIME());
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "The creation time is older than  currenttime - timestamp-freshness-limit - max-clock-skew", null, true);
        }
        Date currentTime = DefaultSecurityEnvironmentImpl.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0228_INVALID_AHEAD_CREATION_TIME());
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "The creation time is ahead of the current time.", null, true);
        }
    }

    @Override
    public void validateCreationTime(Map context, String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(creationTime, null, maxClockSkew, timestampFreshnessLimit);
        request.isUsernameToken(true);
        TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{timestampValidationCallback};
        boolean unSupported = false;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            unSupported = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0226_FAILED_VALIDATING_DEFAULT_CREATION_TIME());
            throw new XWSSecurityException((Throwable)e);
        }
        if (unSupported) {
            this.defaultValidateCreationTime(creationTime, maxClockSkew, timestampFreshnessLimit);
            return;
        }
        try {
            timestampValidationCallback.getResult();
        }
        catch (TimestampValidationCallback.TimestampValidationException e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e, true);
        }
    }

    public boolean validateSamlIssuer(String issuer) {
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0230_UNSUPPORTED_VALIDATING_SAML_ISSUER());
        throw new UnsupportedOperationException("SAML Issuer Validation not yet supported");
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0231_UNSUPPORTED_VALIDATING_SAML_USER());
        throw new UnsupportedOperationException("SAML User Validation not yet supported");
    }

    @Override
    public String getUsername(Map context) throws XWSSecurityException {
        UsernameCallback usernameCallback = new UsernameCallback();
        ProcessingContext.copy(usernameCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{usernameCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0216_CALLBACKHANDLER_HANDLE_EXCEPTION("UsernameCallback"), new Object[]{"UsernameCallback"});
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0217_CALLBACKHANDLER_HANDLE_EXCEPTION_LOG(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return usernameCallback.getUsername();
    }

    @Override
    public String getPassword(Map context) throws XWSSecurityException {
        PasswordCallback passwordCallback = new PasswordCallback();
        ProcessingContext.copy(passwordCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0225_FAILED_PASSWORD_VALIDATION_CALLBACK(), e);
            throw new XWSSecurityException(e.getMessage(), (Throwable)e);
        }
        return passwordCallback.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultValidateExpirationTime(String expirationTime, long maxClockSkew, long timestampFreshnessLimit) {
        if (expirationTime != null) {
            Date expires = null;
            try {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
                synchronized (simpleDateFormat) {
                    expires = this.calendarFormatter1.parse(expirationTime);
                }
            }
            catch (ParseException pe) {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
                synchronized (simpleDateFormat) {
                    try {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                    catch (ParseException e) {
                        log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0394_ERROR_PARSING_EXPIRATIONTIME());
                        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e, true);
                    }
                }
            }
            Date currentTime = DefaultSecurityEnvironmentImpl.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
            if (expires.before(currentTime)) {
                log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0393_CURRENT_AHEAD_OF_EXPIRES());
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "The current time is ahead of the expiration time in Timestamp", null, true);
            }
        }
    }

    @Override
    public void validateTimestamp(Map context, Timestamp timestamp, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        this.validateTimestamp(context, timestamp.getCreated(), timestamp.getExpires(), maxClockSkew, freshnessLimit);
    }

    @Override
    public void validateTimestamp(Map context, String created, String expires, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        if (this.expiresBeforeCreated(created, expires)) {
            XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0232_EXPIRED_MESSAGE());
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
        }
        TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(created, expires, maxClockSkew, freshnessLimit);
        TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{timestampValidationCallback};
        boolean unSupported = false;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            unSupported = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        if (unSupported) {
            this.defaultValidateCreationTime(created, maxClockSkew, freshnessLimit);
            this.defaultValidateExpirationTime(expires, maxClockSkew, freshnessLimit);
            return;
        }
        try {
            timestampValidationCallback.getResult();
        }
        catch (TimestampValidationCallback.TimestampValidationException e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0229_FAILED_VALIDATING_TIME_STAMP(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e, true);
        }
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityException {
        Date created = null;
        Date expires = null;
        try {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = this.calendarFormatter1.parse(creationTime);
                if (expirationTime != null) {
                    expires = this.calendarFormatter1.parse(expirationTime);
                }
            }
        }
        catch (ParseException pe) {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
            synchronized (simpleDateFormat) {
                try {
                    created = this.calendarFormatter2.parse(creationTime);
                    if (expirationTime != null) {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                }
                catch (ParseException xpe) {
                    log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0233_INVALID_EXPIRE_BEFORE_CREATION(), xpe);
                    throw new XWSSecurityException(xpe.getMessage());
                }
            }
        }
        if (expires != null && expires.equals(created)) {
            return true;
        }
        return expires != null && expires.before(created);
    }

    @Override
    public void validateSAMLAssertion(Map context, Element assertion) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAssertion(assertion);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0234_FAILED_VALIDATE_SAML_ASSERTION(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Validation failed for SAML Assertion ", e, true);
        }
    }

    @Override
    public Element locateSAMLAssertion(Map context, Element binding, String assertionId, Document ownerDoc) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAuthorityBinding(binding);
        samlPolicy.setAssertionId(assertionId);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0235_FAILED_LOCATE_SAML_ASSERTION(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        Element assertion = samlPolicy.getAssertion();
        if (assertion == null) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0236_NULL_SAML_ASSERTION());
            throw new XWSSecurityException("SAML Assertion not set into Policy by CallbackHandler");
        }
        return assertion;
    }

    @Override
    public AuthenticationTokenPolicy.SAMLAssertionBinding populateSAMLPolicy(Map fpcontext, AuthenticationTokenPolicy.SAMLAssertionBinding policy, DynamicApplicationContext context) throws XWSSecurityException {
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, context);
        if (context != null) {
            ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), fpcontext);
        }
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0237_FAILED_DYNAMIC_POLICY_CALLBACK(), e);
            throw new XWSSecurityException((Throwable)e);
        }
        return (AuthenticationTokenPolicy.SAMLAssertionBinding)dynamicCallback.getSecurityPolicy();
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    private void validateSamlVersion(Assertion assertion) {
        BigInteger major = assertion.getMajorVersion();
        BigInteger minor = assertion.getMinorVersion();
        if (major.intValue() != 1) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0404_SAML_INVALID_VERSION());
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Major version is not 1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Major version is not 1 for SAML Assertion"));
        }
        if (minor.intValue() != 0 && minor.intValue() != 1) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0404_SAML_INVALID_VERSION());
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Minor version is not 0/1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Minor version is not 0/1 for SAML Assertion"));
        }
    }

    private void validateIssuer(SecurableSoapMessage secMessage, Assertion assertion) {
    }

    private void validateSamlUser(SecurableSoapMessage secMessage, Assertion assertion) {
        Object user = null;
    }

    @Override
    public void validateSAMLAssertion(Map context, XMLStreamReader assertion) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAssertion(assertion);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        if (context.get("javax.security.auth.Subject") == null) {
            dynamicCallback.getRuntimeProperties().put("javax.security.auth.Subject", DefaultSecurityEnvironmentImpl.getSubject(context));
        }
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, com.sun.xml.wss.logging.LogStringsMessages.WSS_0234_FAILED_VALIDATE_SAML_ASSERTION(), e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Validation failed for SAML Assertion ", e, true);
        }
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final XMLStreamReader assertion) {
        if (this.callbackHandler instanceof DefaultCallbackHandler && ((DefaultCallbackHandler)this.callbackHandler).getSAMLValidator() instanceof SAMLValidator) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    @Override
    public boolean isSelfCertificate(X509Certificate cert) {
        return false;
    }

    @Override
    public void updateOtherPartySubject(Subject subject, Subject bootStrapSubject) {
        SecurityUtil.copySubject(subject, bootStrapSubject);
    }

    @Override
    public KerberosContext doKerberosLogin() throws XWSSecurityException {
        String loginModule = this.configAssertions.getProperty("krb5.login.module");
        String servicePrincipal = this.configAssertions.getProperty("krb5.service.principal");
        boolean credentialDelegation = Boolean.parseBoolean(this.configAssertions.getProperty("krb5.credential.delegation"));
        if (loginModule == null || loginModule.equals("")) {
            throw new XWSSecurityException("Login Module for Kerberos login is not set or could not be obtained");
        }
        if (servicePrincipal == null || servicePrincipal.equals("")) {
            throw new XWSSecurityException("Kerberos Service Principal is not set or could not be obtained");
        }
        return new KerberosLogin().login(loginModule, servicePrincipal, credentialDelegation);
    }

    @Override
    public KerberosContext doKerberosLogin(byte[] tokenValue) throws XWSSecurityException {
        String loginModule = this.configAssertions.getProperty("krb5.login.module");
        return new KerberosLogin().login(loginModule, tokenValue);
    }

    @Override
    public void updateOtherPartySubject(final Subject subject, final GSSName clientCred, final GSSCredential gssCred) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                KerberosPrincipal kerbPrincipal = new KerberosPrincipal(clientCred.toString());
                subject.getPrincipals().add(kerbPrincipal);
                subject.getPublicCredentials().add(clientCred);
                if (gssCred != null) {
                    subject.getPrivateCredentials().add(gssCred);
                }
                return null;
            }
        });
    }

    @Override
    public boolean validateAndCacheNonce(Map context, String nonce, String created, long nonceAge) throws XWSSecurityException {
        NonceManager nonceMgr = null;
        nonceMgr = this.mnaProperty != null ? NonceManager.getInstance(this.maxNonceAge, (WSEndpoint)context.get("WSEndpoint")) : NonceManager.getInstance(nonceAge, (WSEndpoint)context.get("WSEndpoint"));
        return nonceMgr.validateNonce(nonce, created);
    }

    private Class loadClass(String classname) throws XWSSecurityException {
        ClassLoader loader;
        Class<?> ret;
        block7: {
            if (classname == null) {
                return null;
            }
            ret = null;
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    ret = loader.loadClass(classname);
                    return ret;
                }
                catch (ClassNotFoundException e) {
                    if (!log.isLoggable(Level.FINE)) break block7;
                    log.log(Level.FINE, "LoadClass: could not load class " + classname, e);
                }
            }
        }
        loader = this.getClass().getClassLoader();
        try {
            ret = loader.loadClass(classname);
            return ret;
        }
        catch (ClassNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "LoadClass: could not load class " + classname, e);
            }
            log.log(Level.SEVERE, LogStringsMessages.WSS_1521_ERROR_GETTING_USER_CLASS());
            throw new XWSSecurityException("Could not find User Class " + classname);
        }
    }

    static {
        GregorianCalendar c = new GregorianCalendar();
        long calculatedOffset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            calculatedOffset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        offset = calculatedOffset;
        log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    }
}

