/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.impl.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BinarySecretImpl
extends BinarySecretType
implements BinarySecret {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public BinarySecretImpl(@NotNull byte[] rawValue, String type) {
        this.setRawValue(rawValue);
        this.setType(type);
    }

    public BinarySecretImpl(@NotNull BinarySecretType bsType) {
        this(bsType.getValue(), bsType.getType());
    }

    public static BinarySecretType fromElement(@NotNull Element element) throws WSTrustException {
        try {
            Unmarshaller u = WSTrustElementFactory.getContext().createUnmarshaller();
            return (BinarySecretType)((JAXBElement)u.unmarshal((Node)element)).getValue();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), (Throwable)ex);
        }
    }

    @NotNull
    public byte[] getRawValue() {
        return super.getValue();
    }

    @NotNull
    public String getTextValue() {
        return Base64.encode((byte[])this.getRawValue());
    }

    public final void setRawValue(@NotNull byte[] rawText) {
        this.setValue(rawText);
    }

    public void setTextValue(@NotNull String encodedText) {
        try {
            this.setValue(Base64.decode((String)encodedText));
        }
        catch (Base64DecodingException de) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0020_ERROR_DECODING(encodedText), de);
            throw new RuntimeException(LogStringsMessages.WST_0020_ERROR_DECODING(encodedText), de);
        }
    }
}

