/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class CipherDataProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private static String CIPHER_VALUE = "CipherValue".intern();
    private static String CIPHER_REFERENCE = "CipherReference".intern();
    private static String TRANSFORMS = "Transforms".intern();
    private static String TRANSFORM = "Transform".intern();
    private Base64Data bd = null;
    private byte[] cipherValue;
    private JAXBFilterProcessingContext pc = null;
    boolean hasCipherReference = false;
    String attachmentContentId = null;
    String attachmentContentType = null;

    public CipherDataProcessor(JAXBFilterProcessingContext pc) {
        this.pc = pc;
    }

    public void process(XMLStreamReader reader) throws XWSSecurityException {
        try {
            if (StreamUtil.moveToNextElement(reader)) {
                if (reader.getLocalName() == CIPHER_VALUE) {
                    if (reader instanceof XMLStreamReaderEx) {
                        reader.next();
                        if (reader.getEventType() == 4) {
                            CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                            if (charSeq instanceof Base64Data) {
                                this.bd = (Base64Data)charSeq;
                            } else {
                                try {
                                    this.cipherValue = Base64.decode(StreamUtil.getCV((XMLStreamReaderEx)reader));
                                }
                                catch (Base64DecodingException ex) {
                                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL((Object)ex), ex);
                                    throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL((Object)ex), ex);
                                }
                            }
                        }
                    } else {
                        try {
                            this.cipherValue = Base64.decode(StreamUtil.getCV(reader));
                        }
                        catch (Base64DecodingException ex) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL((Object)ex), ex);
                            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1922_ERROR_DECODING_CIPHERVAL((Object)ex), ex);
                        }
                    }
                    reader.next();
                    reader.next();
                    return;
                }
                if (reader.getLocalName() == CIPHER_REFERENCE) {
                    this.hasCipherReference = true;
                    String attachUri = reader.getAttributeValue(null, "URI");
                    if (attachUri.startsWith("cid:")) {
                        attachUri = attachUri.substring("cid:".length());
                    }
                    String algorithm = null;
                    if (StreamUtil.moveToNextElement(reader) && reader.getLocalName() == TRANSFORMS) {
                        if (StreamUtil.moveToNextElement(reader) && reader.getLocalName() == TRANSFORM) {
                            algorithm = reader.getAttributeValue(null, "Algorithm");
                            reader.next();
                        }
                        reader.next();
                    }
                    if (algorithm != null && algorithm.equals("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform")) {
                        AttachmentSet attachmentSet = this.pc.getSecurityContext().getAttachmentSet();
                        Attachment as = attachmentSet.get(attachUri);
                        this.cipherValue = as.asByteArray();
                        this.attachmentContentId = as.getContentId();
                        this.attachmentContentType = as.getContentType();
                        reader.next();
                        reader.next();
                        return;
                    }
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1928_UNRECOGNIZED_CIPHERTEXT_TRANSFORM(algorithm));
                    throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1928_UNRECOGNIZED_CIPHERTEXT_TRANSFORM(algorithm), new XWSSecurityException(LogStringsMessages.WSS_1928_UNRECOGNIZED_CIPHERTEXT_TRANSFORM(algorithm)));
                }
            }
            reader.next();
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex), ex);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex), ex);
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL("unexpected element:" + reader.getLocalName()));
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL("unexpected element:" + reader.getLocalName()), null);
    }

    public InputStream readAsStream() throws XWSSecurityException {
        if (this.bd != null) {
            try {
                return this.bd.getInputStream();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex), ex);
                throw new XWSSecurityException(LogStringsMessages.WSS_1923_ERROR_PROCESSING_CIPHERVAL(ex));
            }
        }
        if (this.cipherValue != null) {
            return new ByteArrayInputStream(this.cipherValue);
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA());
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA(), null);
    }

    public byte[] readAsBytes() throws XWSSecurityException {
        if (this.cipherValue != null) {
            return this.cipherValue;
        }
        if (this.bd != null) {
            this.cipherValue = this.bd.getExact();
            return this.cipherValue;
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA());
        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1924_CIPHERVAL_MISSINGIN_CIPHERDATA(), null);
    }

    public boolean hasCipherReference() {
        return this.hasCipherReference;
    }

    public String getAttachmentContentId() {
        return this.attachmentContentId;
    }

    public String getAttachmentContentType() {
        return this.attachmentContentType;
    }
}

