/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.tokens.UsernameToken;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.filter.UsernameTokenDataResolver;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.filter.LogStringsMessages;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;

public class SignatureFilter {
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    public static AuthenticationTokenPolicy.UsernameTokenBinding createUntBinding(FilterProcessingContext context, AuthenticationTokenPolicy.UsernameTokenBinding untBinding, int firstByte) throws XWSSecurityException {
        TimestampPolicy tPolicy;
        String creationTime;
        AuthenticationTokenPolicy.UsernameTokenBinding binding = (AuthenticationTokenPolicy.UsernameTokenBinding)untBinding.clone();
        JAXBFilterProcessingContext opContext = (JAXBFilterProcessingContext)context;
        SignaturePolicy authPolicy = (SignaturePolicy)context.getSecurityPolicy();
        UsernameToken unToken = null;
        unToken = context.getusernameTokenBinding() == null ? new UsernameToken(opContext.getSOAPVersion()) : (untBinding.getUUID().equals(context.getusernameTokenBinding().getUUID()) ? context.getusernameTokenBinding().getUsernameToken() : new UsernameToken(opContext.getSOAPVersion()));
        try {
            binding = UsernameTokenDataResolver.setSaltandIterationsforUsernameToken(opContext, unToken, authPolicy, binding, firstByte);
        }
        catch (UnsupportedEncodingException ex) {
            throw new XWSSecurityException("error occurred while decoding the salt in username token", (Throwable)ex);
        }
        catch (XWSSecurityException ex) {
            throw ex;
        }
        if (binding.getUseNonce() && unToken.getNonceValue() == null) {
            unToken.setNonce(binding.getNonce());
            creationTime = "";
            tPolicy = (TimestampPolicy)binding.getFeatureBinding();
            if (tPolicy == null) {
                tPolicy = (TimestampPolicy)binding.newTimestampFeatureBinding();
            }
            creationTime = tPolicy.getCreationTime();
            unToken.setCreationTime(creationTime);
        }
        if (binding.getUseCreated() && unToken.getCreatedValue() == null) {
            creationTime = "";
            tPolicy = (TimestampPolicy)binding.getFeatureBinding();
            if (tPolicy == null) {
                tPolicy = (TimestampPolicy)binding.newTimestampFeatureBinding();
            }
            creationTime = tPolicy.getCreationTime();
            unToken.setCreationTime(creationTime);
        }
        binding.setUsernameToken(unToken);
        String dataEncAlgo = null;
        dataEncAlgo = context.getAlgorithmSuite() != null ? context.getAlgorithmSuite().getEncryptionAlgorithm() : "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        SecretKey sKey = binding.getSecretKey(SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo));
        binding.setSecretKey(sKey);
        return binding;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        block86: {
            block79: {
                block81: {
                    block82: {
                        block80: {
                            if (context.isInboundMessage()) break block79;
                            policy = (WSSPolicy)context.getSecurityPolicy();
                            resolvedPolicy = (SignaturePolicy)policy;
                            if (context.makeDynamicPolicyCallback()) ** GOTO lbl263
                            keyBinding = (WSSPolicy)((SignaturePolicy)policy).getKeyBinding();
                            if (PolicyTypeUtil.derivedTokenKeyBinding(keyBinding) && PolicyTypeUtil.usernameTokenBinding(originalKeyBinding = (dtk = (DerivedTokenKeyBinding)keyBinding.clone()).getOriginalKeyBinding())) {
                                ckBindingClone = (AuthenticationTokenPolicy.UsernameTokenBinding)originalKeyBinding.clone();
                                skb = new SymmetricKeyBinding();
                                skb.setKeyBinding(ckBindingClone);
                                dtk.setOriginalKeyBinding(skb);
                                keyBinding = dtk;
                            }
                            if (!PolicyTypeUtil.usernameTokenBinding(keyBinding)) break block80;
                            binding = SignatureFilter.createUntBinding(context, (AuthenticationTokenPolicy.UsernameTokenBinding)keyBinding, 1);
                            context.setUsernameTokenBinding((AuthenticationTokenPolicy.UsernameTokenBinding)binding);
                            break block81;
                        }
                        if (!PolicyTypeUtil.x509CertificateBinding(keyBinding)) break block82;
                        try {
                            block84: {
                                block85: {
                                    block83: {
                                        binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding.clone();
                                        certIdentifier = binding.getCertificateIdentifier();
                                        algorithm = binding.getKeyAlgorithm();
                                        if (!"http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(algorithm)) break block83;
                                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                        binding.setX509Certificate(cert);
                                        break block84;
                                    }
                                    if (certIdentifier != null && !"".equals(certIdentifier)) break block85;
                                    ckBinding = (WSSPolicy)binding.getKeyBinding();
                                    if (ckBinding == null) {
                                        ckBinding = (WSSPolicy)binding.newPrivateKeyBinding();
                                    }
                                    if (context.getSecurityEnvironment().getClass().getName().equals("com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl")) {
                                        request = ((DefaultSecurityEnvironmentImpl)context.getSecurityEnvironment()).getDefaultPrivKeyCertRequest(context.getExtraneousProperties());
                                        binding.setX509Certificate(request.getX509Certificate());
                                        if (request.getX509Certificate() == null) {
                                            SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1421_NO_DEFAULT_X_509_CERTIFICATE_PROVIDED());
                                            throw new XWSSecurityException("No default X509Certificate was provided");
                                        }
                                        ((PrivateKeyBinding)ckBinding).setPrivateKey(request.getPrivateKey());
                                    } else {
                                        cert = context.getSecurityEnvironment().getDefaultCertificate(context.getExtraneousProperties());
                                        if (cert == null) {
                                            SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1421_NO_DEFAULT_X_509_CERTIFICATE_PROVIDED());
                                            throw new XWSSecurityException("No default X509Certificate was provided");
                                        }
                                        binding.setX509Certificate(cert);
                                        pk = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
                                        ((PrivateKeyBinding)ckBinding).setPrivateKey(pk);
                                    }
                                    break block84;
                                }
                                if (!context.getSecurityEnvironment().getClass().getName().equals("com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl")) ** GOTO lbl63
                                request = ((DefaultSecurityEnvironmentImpl)context.getSecurityEnvironment()).getAliasPrivKeyCertRequest(certIdentifier);
                                binding.setX509Certificate(request.getX509Certificate());
                                if (request.getX509Certificate() == null) {
                                    SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1421_NO_DEFAULT_X_509_CERTIFICATE_PROVIDED());
                                    throw new XWSSecurityException("No X509Certificate was provided");
                                }
                                ckBinding = (WSSPolicy)binding.getKeyBinding();
                                if (PolicyTypeUtil.privateKeyBinding(ckBinding)) {
                                    ((PrivateKeyBinding)ckBinding).setPrivateKey(request.getPrivateKey());
                                } else if (ckBinding == null) {
                                    ((PrivateKeyBinding)binding.newPrivateKeyBinding()).setPrivateKey(request.getPrivateKey());
                                } else {
                                    SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1416_UNSUPPORTED_KEYBINDING());
                                    throw new XWSSecurityException("Unsupported KeyBinding for X509CertificateBinding");
lbl63:
                                    // 1 sources

                                    cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, true);
                                    binding.setX509Certificate(cert);
                                    ckBinding = (WSSPolicy)binding.getKeyBinding();
                                    key = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), certIdentifier);
                                    if (PolicyTypeUtil.privateKeyBinding(ckBinding)) {
                                        ((PrivateKeyBinding)ckBinding).setPrivateKey(key);
                                    } else if (ckBinding == null) {
                                        ((PrivateKeyBinding)binding.newPrivateKeyBinding()).setPrivateKey(key);
                                    } else {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1416_UNSUPPORTED_KEYBINDING());
                                        throw new XWSSecurityException("Unsupported KeyBinding for X509CertificateBinding");
                                    }
                                }
                            }
                            context.setX509CertificateBinding((AuthenticationTokenPolicy.X509CertificateBinding)binding);
                        }
                        catch (Exception e) {
                            SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1417_EXCEPTION_PROCESSING_SIGNATURE(new Object[]{e.getMessage()}));
                            throw new XWSSecurityException((Throwable)e);
                        }
                    }
                    if (PolicyTypeUtil.kerberosTokenBinding(keyBinding)) {
                        binding = (AuthenticationTokenPolicy.KerberosTokenBinding)keyBinding.clone();
                        algorithm = binding.getKeyAlgorithm();
                        encodedRef = (String)context.getExtraneousProperty("KerbSHA1Value");
                        krbContext = null;
                        if (encodedRef != null) {
                            krbContext = context.getKerberosContext();
                        }
                        dataEncAlgo = null;
                        dataEncAlgo = context.getAlgorithmSuite() != null ? context.getAlgorithmSuite().getEncryptionAlgorithm() : "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                        if (krbContext == null) {
                            SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1423_KERBEROS_CONTEXT_NOTSET());
                            throw new XWSSecurityException("WSS1423.kerberos.context.notset");
                        }
                        kerberosToken = krbContext.getKerberosToken();
                        binding.setTokenValue(kerberosToken);
                        sKey = krbContext.getSecretKey(SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo));
                        binding.setSecretKey(sKey);
                        context.setKerberosTokenBinding((AuthenticationTokenPolicy.KerberosTokenBinding)binding);
                    } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
                        keyBinding = (WSSPolicy)((SignaturePolicy)policy).getKeyBinding();
                        binding = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                        if (binding.getAssertion() != null || binding.getAssertionReader() != null || binding.getAuthorityBinding() != null) {
                            binding.setAssertion(null);
                            binding.setAuthorityBinding(null);
                            binding.setAssertion(null);
                        }
                        binding.isReadOnly(true);
                        dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                        dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                        dynamicContext.inBoundMessage(false);
                        resolvedSAMLBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)context.getExtraneousProperties().get("Saml_Assertion_Client_Cache");
                        if (resolvedSAMLBinding == null) {
                            resolvedSAMLBinding = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), (AuthenticationTokenPolicy.SAMLAssertionBinding)binding, dynamicContext);
                            context.getExtraneousProperties().put("Saml_Assertion_Client_Cache", resolvedSAMLBinding);
                        }
                        if (resolvedSAMLBinding.getAssertion() == null && resolvedSAMLBinding.getAuthorityBinding() == null && resolvedSAMLBinding.getAssertionReader() == null) {
                            SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1418_SAML_INFO_NOTSET());
                            throw new XWSSecurityException("None of SAML Assertion, SAML AuthorityBinding information was set into  the Policy by the CallbackHandler");
                        }
                        policy.setKeyBinding(resolvedSAMLBinding);
                        resolvedPolicy = (SignaturePolicy)policy;
                    } else {
                        if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
                            try {
                                dataEncAlgo = null;
                                dataEncAlgo = context.getAlgorithmSuite() != null ? context.getAlgorithmSuite().getEncryptionAlgorithm() : "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                                binding = (SymmetricKeyBinding)keyBinding.clone();
                                keyIdentifier = binding.getKeyIdentifier();
                                sKey = null;
                                ckBinding = (WSSPolicy)binding.getKeyBinding();
                                wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
                                wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
                                wss10 = wss11Sender == false;
                                v0 = sendEKSHA1 = wss11Receiver != false && wss11Sender != false && SignatureFilter.getReceivedSecret(context) != null;
                                if (PolicyTypeUtil.usernameTokenBinding(ckBinding)) {
                                    try {
                                        if (sendEKSHA1) ** GOTO lbl170
                                        untbinding = SignatureFilter.createUntBinding(context, (AuthenticationTokenPolicy.UsernameTokenBinding)ckBinding, 2);
                                        context.setUsernameTokenBinding(untbinding);
                                        sKey = untbinding.getSecretKey();
                                    }
                                    catch (Exception e) {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1433_ERROR_EXTRACTING_USERNAMETOKEN(), e);
                                        throw new XWSSecurityException((Throwable)e);
                                    }
                                } else if (PolicyTypeUtil.x509CertificateBinding(ckBinding)) {
                                    try {
                                        if (sendEKSHA1) ** GOTO lbl170
                                        ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)ckBinding.clone();
                                        certIdentifier = ckBindingClone.getCertificateIdentifier();
                                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                        ckBindingClone.setX509Certificate(cert);
                                        context.setX509CertificateBinding(ckBindingClone);
                                    }
                                    catch (Exception e) {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1413_ERROR_EXTRACTING_CERTIFICATE(), e);
                                        throw new XWSSecurityException((Throwable)e);
                                    }
                                } else if (PolicyTypeUtil.kerberosTokenBinding(ckBinding)) {
                                    ckBindingClone = (AuthenticationTokenPolicy.KerberosTokenBinding)ckBinding;
                                    encodedRef = (String)context.getExtraneousProperty("KerbSHA1Value");
                                    krbContext = null;
                                    if (encodedRef != null) {
                                        krbContext = context.getKerberosContext();
                                    }
                                    if (krbContext == null) {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1423_KERBEROS_CONTEXT_NOTSET());
                                        throw new XWSSecurityException("WSS1423.kerberos.context.notset");
                                    }
                                    kerberosToken = krbContext.getKerberosToken();
                                    ckBindingClone.setTokenValue(kerberosToken);
                                    sKey = krbContext.getSecretKey(SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo));
                                    ckBindingClone.setSecretKey(sKey);
                                    context.setKerberosTokenBinding(ckBindingClone);
                                }
lbl170:
                                // 7 sources

                                if (!PolicyTypeUtil.kerberosTokenBinding(ckBinding)) {
                                    if (!binding.getKeyIdentifier().equals(MessageConstants._EMPTY)) {
                                        sKey = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keyIdentifier, true);
                                    } else if (sendEKSHA1) {
                                        sKey = SignatureFilter.getReceivedSecret(context);
                                    } else if (wss11Sender || wss10) {
                                        sKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
                                    }
                                }
                                binding.setSecretKey(sKey);
                                context.setSymmetricKeyBinding(binding);
                            }
                            catch (Exception e) {
                                SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1414_ERROR_EXTRACTING_SYMMETRICKEY(new Object[]{e.getMessage()}));
                                throw new XWSSecurityException((Throwable)e);
                            }
                        }
                        if (PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) {
                            itkb = (IssuedTokenKeyBinding)keyBinding;
                            SecurityUtil.resolveIssuedToken(context, itkb);
                        } else if (PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) {
                            dtk = (DerivedTokenKeyBinding)keyBinding.clone();
                            originalKeyBinding = dtk.getOriginalKeyBinding();
                            if (PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) {
                                dataEncAlgo = null;
                                dataEncAlgo = context.getAlgorithmSuite() != null ? context.getAlgorithmSuite().getEncryptionAlgorithm() : "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                                symmBinding = (SymmetricKeyBinding)originalKeyBinding.clone();
                                sKey = null;
                                wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
                                wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
                                wss10 = wss11Sender == false;
                                sendEKSHA1 = wss11Receiver != false && wss11Sender != false && SignatureFilter.getReceivedSecret(context) != null;
                                ckBinding = (WSSPolicy)originalKeyBinding.getKeyBinding();
                                if (PolicyTypeUtil.usernameTokenBinding(ckBinding)) {
                                    try {
                                        if (sendEKSHA1) ** GOTO lbl237
                                        untbinding = SignatureFilter.createUntBinding(context, (AuthenticationTokenPolicy.UsernameTokenBinding)ckBinding, 2);
                                        context.setUsernameTokenBinding(untbinding);
                                    }
                                    catch (Exception e) {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1433_ERROR_EXTRACTING_USERNAMETOKEN(), e);
                                        throw new XWSSecurityException((Throwable)e);
                                    }
                                } else if (PolicyTypeUtil.x509CertificateBinding(ckBinding)) {
                                    try {
                                        if (sendEKSHA1) ** GOTO lbl237
                                        ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)ckBinding.clone();
                                        certIdentifier = ckBindingClone.getCertificateIdentifier();
                                        cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                        ckBindingClone.setX509Certificate(cert);
                                        context.setX509CertificateBinding(ckBindingClone);
                                    }
                                    catch (Exception e) {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1413_ERROR_EXTRACTING_CERTIFICATE(), e);
                                        throw new XWSSecurityException((Throwable)e);
                                    }
                                } else if (PolicyTypeUtil.kerberosTokenBinding(ckBinding)) {
                                    ckBindingClone = (AuthenticationTokenPolicy.KerberosTokenBinding)ckBinding;
                                    encodedRef = (String)context.getExtraneousProperty("KerbSHA1Value");
                                    krbContext = null;
                                    if (encodedRef != null) {
                                        krbContext = context.getKerberosContext();
                                    }
                                    if (krbContext == null) {
                                        SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1423_KERBEROS_CONTEXT_NOTSET());
                                        throw new XWSSecurityException("WSS1423.kerberos.context.notset");
                                    }
                                    kerberosToken = krbContext.getKerberosToken();
                                    ckBindingClone.setTokenValue(kerberosToken);
                                    sKey = krbContext.getSecretKey(SecurityUtil.getSecretKeyAlgorithm(dataEncAlgo));
                                    ckBindingClone.setSecretKey(sKey);
                                    context.setKerberosTokenBinding(ckBindingClone);
                                }
lbl237:
                                // 7 sources

                                if (!PolicyTypeUtil.kerberosTokenBinding(ckBinding)) {
                                    if (sendEKSHA1) {
                                        sKey = SignatureFilter.getReceivedSecret(context);
                                    } else if (wss11Sender || wss10) {
                                        sKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
                                    }
                                }
                                symmBinding.setSecretKey(sKey);
                                context.setSymmetricKeyBinding(symmBinding);
                            } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
                                sctBinding = (SecureConversationTokenKeyBinding)originalKeyBinding;
                                SecurityUtil.resolveSCT(context, sctBinding);
                            } else if (PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) {
                                itkb = (IssuedTokenKeyBinding)originalKeyBinding;
                                SecurityUtil.resolveIssuedToken(context, itkb);
                            }
                        } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) {
                            sctBinding /* !! */  = (SecureConversationTokenKeyBinding)keyBinding;
                            SecurityUtil.resolveSCT(context, sctBinding /* !! */ );
                        } else if (PolicyTypeUtil.keyValueTokenBinding(keyBinding)) {
                            sctBinding /* !! */  = (AuthenticationTokenPolicy.KeyValueTokenBinding)keyBinding.clone();
                        } else {
                            SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1419_UNSUPPORTED_KEYBINDING_SIGNATURE());
                            throw new XWSSecurityException("Unsupported KeyBinding for SignaturePolicy");
lbl263:
                            // 1 sources

                            ((SignaturePolicy)policy).isReadOnly(true);
                            try {
                                dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                                dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                                dynamicContext.inBoundMessage(false);
                                dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                                ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                                HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                                resolvedPolicy = (SignaturePolicy)dynamicCallback.getSecurityPolicy();
                            }
                            catch (Exception e) {
                                SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1420_DYNAMIC_POLICY_SIGNATURE(new Object[]{e.getMessage()}));
                                throw new XWSSecurityException((Throwable)e);
                            }
                        }
                    }
                }
                context.setSecurityPolicy(resolvedPolicy);
                SignatureFilter.sign(context);
                break block86;
            }
            if (context.makeDynamicPolicyCallback()) {
                policy = (WSSPolicy)context.getSecurityPolicy();
                resolvedPolicy = null;
                ((SignaturePolicy)policy).isReadOnly(true);
                try {
                    dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(true);
                    dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    resolvedPolicy = (SignaturePolicy)dynamicCallback.getSecurityPolicy();
                }
                catch (Exception e) {
                    SignatureFilter.log.log(Level.SEVERE, LogStringsMessages.WSS_1420_DYNAMIC_POLICY_SIGNATURE(new Object[]{e.getMessage()}));
                    throw new XWSSecurityException((Throwable)e);
                }
                context.setSecurityPolicy(resolvedPolicy);
            }
            SignatureProcessor.verify(context);
        }
    }

    private static void sign(FilterProcessingContext context) throws XWSSecurityException {
        if (context instanceof JAXBFilterProcessingContext) {
            com.sun.xml.ws.security.opt.impl.dsig.SignatureProcessor.sign((JAXBFilterProcessingContext)context);
        } else {
            SignatureProcessor.sign(context);
        }
    }

    private static SecretKey getReceivedSecret(FilterProcessingContext context) {
        SecretKey sKey = null;
        sKey = (SecretKey)context.getExtraneousProperty("SecretKeyValue");
        return sKey;
    }
}

