/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.apachecrypto;

import com.sun.xml.util.XMLCipherAdapter;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedDataHeaderBlock;
import com.sun.xml.wss.core.EncryptedKeyHeaderBlock;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.ReferenceListHeaderBlock;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.KeyResolver;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.EncryptionPolicyVerifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecryptionProcessor {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.crypto", "com.sun.xml.wss.logging.impl.crypto.LogStrings");

    public static void decrypt(FilterProcessingContext context) throws XWSSecurityException {
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        SOAPElement headerElement = wsseSecurity.getCurrentHeaderElement();
        String localName = headerElement.getLocalName();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "EncryptionProcessor:decrypt : LocalName is " + localName);
        }
        if (localName == null) {
            context.setPVE((Throwable)((Object)new PolicyViolationException("Expected one of EncryptedKey,EncryptedData,ReferenceList as per receiverrequirements, found none")));
            context.isPrimaryPolicyViolation(true);
            return;
        }
        EncryptionPolicy inferredPolicy = null;
        if (context.getMode() == 0 || context.getMode() == 1) {
            inferredPolicy = new EncryptionPolicy();
            context.setInferredPolicy(inferredPolicy);
        }
        SecretKey key = null;
        if ("EncryptedData".equals(localName)) {
            DecryptionProcessor.processEncryptedData(headerElement, key, context);
        } else if ("EncryptedKey".equals(localName)) {
            if (context.getMode() == 3) {
                inferredPolicy = new EncryptionPolicy();
                context.getInferredSecurityPolicy().append(inferredPolicy);
            }
            DecryptionProcessor.processEncryptedKey(context, headerElement);
        } else if ("ReferenceList".equals(localName)) {
            if (context.getMode() == 3) {
                inferredPolicy = new EncryptionPolicy();
                context.getInferredSecurityPolicy().append(inferredPolicy);
            }
            DecryptionProcessor.decryptReferenceList(headerElement, key, null, context);
        } else {
            context.setPVE((Throwable)((Object)new PolicyViolationException("Expected one of EncryptedKey,EncryptedData,ReferenceList as per receiverrequirements, found " + localName)));
            context.isPrimaryPolicyViolation(true);
            return;
        }
        if (context.getMode() == 0) {
            new EncryptionPolicyVerifier(context).verifyPolicy(context.getSecurityPolicy(), context.getInferredPolicy());
        }
    }

    public static void processEncryptedKey(FilterProcessingContext context, SOAPElement xencEncryptedKey) throws XWSSecurityException {
        boolean isBSP = false;
        try {
            SecretKey symmetricKey;
            xencEncryptedKey.normalize();
            Element cipherData = (Element)xencEncryptedKey.getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData", "xenc")).next();
            String cipherValue = cipherData.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getTextContent();
            byte[] decodedCipher = Base64.decode(cipherValue);
            byte[] ekSha1 = MessageDigest.getInstance("SHA-1").digest(decodedCipher);
            String encEkSha1 = Base64.encode(ekSha1);
            context.setExtraneousProperty("EKSHA1Value", encEkSha1);
            EncryptedKeyHeaderBlock encKeyHB = new EncryptedKeyHeaderBlock(xencEncryptedKey);
            String encryptionAlgorithm = encKeyHB.getEncryptionMethodURI();
            SecurityPolicy securityPolicy = context.getSecurityPolicy();
            if (securityPolicy != null && PolicyTypeUtil.encryptionPolicy(securityPolicy)) {
                isBSP = ((EncryptionPolicy)securityPolicy).isBSP();
            }
            EncryptionPolicy infPolicy = null;
            if (context.getMode() != 2) {
                infPolicy = (EncryptionPolicy)context.getInferredPolicy();
            }
            if (!(!isBSP || "http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encryptionAlgorithm) || "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptionAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(encryptionAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(encryptionAlgorithm) || "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(encryptionAlgorithm))) {
                log.log(Level.SEVERE, "WSS1227.keyEncryptionAlg.Violation");
                throw new XWSSecurityException("Violation of BSP5621.  KeyEncryption algorithmMUST be one of #rsa-1_5,#rsa-oaep-mgf1p,#kw-tripledes,#kw-aes256,#kw-aes128");
            }
            XMLCipher xmlCipher = XMLCipher.getInstance((String)encryptionAlgorithm);
            EncryptedKey encryptedKey = xmlCipher.loadEncryptedKey((Element)xencEncryptedKey);
            KeyInfoHeaderBlock keyInfo = new KeyInfoHeaderBlock(encryptedKey.getKeyInfo());
            SOAPElement refListSoapElement = null;
            String commonDataEncAlgo = null;
            refListSoapElement = (SOAPElement)xencEncryptedKey.getChildElements(SOAPFactory.newInstance().createName("ReferenceList", "xenc", "http://www.w3.org/2001/04/xmlenc#")).next();
            commonDataEncAlgo = DecryptionProcessor.getDataEncryptionAlgorithm(refListSoapElement, context.getSecurableSoapMessage());
            if (isBSP && !"http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equalsIgnoreCase(commonDataEncAlgo) && !"http://www.w3.org/2001/04/xmlenc#aes128-cbc".equalsIgnoreCase(commonDataEncAlgo) && !"http://www.w3.org/2001/04/xmlenc#aes256-cbc".equalsIgnoreCase(commonDataEncAlgo)) {
                log.log(Level.SEVERE, "WSS1228.DataEncryptionAlg.Violation");
                throw new XWSSecurityException("Violation of BSP5620 for DataEncryption Algo permitted values");
            }
            Key key = KeyResolver.getKey(keyInfo, false, context);
            xmlCipher.init(4, key);
            if (infPolicy != null) {
                WSSPolicy keyBinding = (WSSPolicy)infPolicy.getKeyBinding();
                if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                    ((AuthenticationTokenPolicy.X509CertificateBinding)keyBinding).setKeyAlgorithm(encryptionAlgorithm);
                } else if (PolicyTypeUtil.samlTokenPolicy(keyBinding)) {
                    ((AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding).setKeyAlgorithm(encryptionAlgorithm);
                }
            }
            XMLCipher dataCipher = null;
            try {
                symmetricKey = (SecretKey)xmlCipher.decryptKey(encryptedKey, commonDataEncAlgo);
                dataCipher = DecryptionProcessor.initXMLCipher(symmetricKey, commonDataEncAlgo);
            }
            catch (XMLEncryptionException xmlee) {
                log.log(Level.SEVERE, "WSS1200.error.decrypting.key");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Decryption of key encryption key failed", xmlee);
            }
            context.setExtraneousProperty("SecretKeyValue", symmetricKey);
            if (refListSoapElement != null) {
                DecryptionProcessor.decryptReferenceList(refListSoapElement, symmetricKey, dataCipher, context);
            }
        }
        catch (WssSoapFaultException wssSfe) {
            log.log(Level.SEVERE, "WSS1229.Error.Processing.EncrpytedKey");
            throw wssSfe;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1229.Error.Processing.EncrpytedKey");
            throw new XWSSecurityException((Throwable)e);
        }
    }

    private static void decryptReferenceList(SOAPElement refListSoapElement, SecretKey key, XMLCipher dataCipher, FilterProcessingContext context) throws XWSSecurityException {
        int count;
        int i;
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        ReferenceListHeaderBlock refList = new ReferenceListHeaderBlock(refListSoapElement);
        NodeList dataRefElements = refList.getDataRefElements();
        int numberOfEncryptedElems = refList.size();
        EncryptionPolicy policy = null;
        ArrayList targets = null;
        boolean partialReqsMet = false;
        ArrayList<EncryptionTarget> optionalTargets = null;
        ArrayList<EncryptionTarget> requiredTargets = null;
        ArrayList<EncryptedData> attachmentTargets = null;
        boolean skipAttachments = false;
        EncryptionTarget allCT = null;
        boolean verifyReq = false;
        if (context.getMode() == 0) {
            policy = (EncryptionPolicy)context.getSecurityPolicy();
            targets = ((EncryptionPolicy.FeatureBinding)policy.getFeatureBinding()).getTargetBindings();
            optionalTargets = new ArrayList<EncryptionTarget>();
            requiredTargets = new ArrayList<EncryptionTarget>();
            i = 0;
            while (i < targets.size()) {
                EncryptionTarget et;
                if ((et = (EncryptionTarget)targets.get(i++)).getEnforce()) {
                    String value = et.getValue();
                    if (value == "cid:*") {
                        if (attachmentTargets == null) {
                            attachmentTargets = new ArrayList<EncryptedData>();
                        }
                        allCT = et;
                        skipAttachments = true;
                        continue;
                    }
                    requiredTargets.add(et);
                    continue;
                }
                optionalTargets.add(et);
            }
            if (requiredTargets.size() > 0 || skipAttachments) {
                verifyReq = true;
            }
        } else if (context.getMode() == 1) {
            policy = new EncryptionPolicy();
            MessagePolicy messagePolicy = (MessagePolicy)context.getSecurityPolicy();
            messagePolicy.append(policy);
        }
        for (i = 0; i < numberOfEncryptedElems; ++i) {
            String refURI = ((SOAPElement)dataRefElements.item(i)).getAttribute("URI");
            SOAPElement encDataElement = null;
            EncryptedData ed = null;
            encDataElement = (SOAPElement)secureMessage.getElementById(refURI.substring(1));
            if (encDataElement.getLocalName() == "EncryptedHeader" || encDataElement.getLocalName().equals("EncryptedHeader")) {
                Iterator itr = encDataElement.getChildElements();
                SOAPElement encDataElementChild = null;
                while (itr.hasNext()) {
                    encDataElementChild = (SOAPElement)itr.next();
                }
                if (encDataElementChild == null) {
                    throw new XWSSecurityException("No EncryptedData child element found in EncryptedHeader");
                }
                ed = DecryptionProcessor.processEncryptedData(encDataElementChild, key, dataCipher, context, requiredTargets, optionalTargets, policy, false);
            } else {
                ed = DecryptionProcessor.processEncryptedData(encDataElement, key, dataCipher, context, requiredTargets, optionalTargets, policy, false);
            }
            if (context.getMode() != 0 || !verifyReq) continue;
            if (ed.isAttachmentData() && skipAttachments) {
                attachmentTargets.add(ed);
                continue;
            }
            if (DecryptionProcessor.verifyTargets(secureMessage, requiredTargets, ed, true)) continue;
            if (optionalTargets.size() == 0) {
                log.log(Level.SEVERE, "WSS1230.failed.receiverReq");
                throw new XWSSecurityException("Receiver requirement for URI" + refURI + " is not met");
            }
            if (DecryptionProcessor.verifyTargets(secureMessage, optionalTargets, ed, false)) continue;
            log.log(Level.SEVERE, "WSS1230.failed.receiverReq");
            throw new XWSSecurityException("Receiver requirement for URI" + refURI + " is not met");
        }
        if (skipAttachments && (count = secureMessage.countAttachments()) > attachmentTargets.size()) {
            log.log(Level.SEVERE, "WSS1238.failed.receiverReq.attachments");
            throw new XWSSecurityException("Receiver requirement cid:* is not met,only " + attachmentTargets.size() + " attachments out of " + count + " were encrypted");
        }
        if (context.getMode() == 0 && requiredTargets.size() > 0) {
            log.log(Level.SEVERE, "WSS1239.failed.receiverReq.more");
            throw new XWSSecurityException("More receiver requirements specified than present in the message");
        }
    }

    public static void processEncryptedData(SOAPElement encDataElement, SecretKey key, FilterProcessingContext context) throws XWSSecurityException {
        EncryptionPolicy policy = null;
        ArrayList<EncryptionTarget> optionalTargets = null;
        ArrayList<EncryptionTarget> requiredTargets = null;
        Object attachmentTargets = null;
        boolean verifyReq = false;
        boolean isBSP = false;
        if (context.getMode() == 1) {
            policy = new EncryptionPolicy();
            MessagePolicy messagePolicy = (MessagePolicy)context.getSecurityPolicy();
            isBSP = messagePolicy.isBSP();
            policy.isBSP(isBSP);
            messagePolicy.append(policy);
        } else if (context.getMode() == 0) {
            policy = (EncryptionPolicy)context.getSecurityPolicy();
            ArrayList targets = ((EncryptionPolicy.FeatureBinding)policy.getFeatureBinding()).getTargetBindings();
            optionalTargets = new ArrayList<EncryptionTarget>();
            requiredTargets = new ArrayList<EncryptionTarget>();
            int i = 0;
            while (i < targets.size()) {
                EncryptionTarget et;
                if ((et = (EncryptionTarget)targets.get(i++)).getEnforce()) {
                    String value = et.getValue();
                    if (value == "cid:*") {
                        log.log(Level.SEVERE, "WSS1201.cid_encrypt_all_notsupported");
                        continue;
                    }
                    requiredTargets.add(et);
                    continue;
                }
                optionalTargets.add(et);
            }
            if (requiredTargets.size() > 0) {
                verifyReq = true;
            }
            String id = encDataElement.getAttribute("Id");
            EncryptedElement ed = (EncryptedElement)DecryptionProcessor.processEncryptedData(encDataElement, key, null, context, requiredTargets, optionalTargets, policy, true);
            if (requiredTargets.size() > 1) {
                log.log(Level.SEVERE, "WSS1240.failed.receiverReq.moretargets");
                throw new XWSSecurityException("Receiver requirement has more targets specified");
            }
            SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
            if (verifyReq && !DecryptionProcessor.verifyTargets(secureMsg, requiredTargets, ed, true)) {
                if (optionalTargets.size() == 0) {
                    log.log(Level.SEVERE, "WSS1241.failed.receiverReq.encryptedData");
                    throw new XWSSecurityException("Receiver requirement for EncryptedData with ID " + id + " is not met");
                }
                if (!DecryptionProcessor.verifyTargets(secureMsg, optionalTargets, ed, false)) {
                    log.log(Level.SEVERE, "WSS1241.failed.receiverReq.encryptedData");
                    throw new XWSSecurityException("Receiver requirement for EncryptedData ID " + id + " is not met");
                }
            }
        } else if (context.getMode() == 2) {
            EncryptedElement encryptedElement = (EncryptedElement)DecryptionProcessor.processEncryptedData(encDataElement, key, null, context, requiredTargets, optionalTargets, policy, true);
        } else if (context.getMode() == 3) {
            context.getInferredSecurityPolicy().append(new EncryptionPolicy());
            EncryptedElement encryptedElement = (EncryptedElement)DecryptionProcessor.processEncryptedData(encDataElement, key, null, context, requiredTargets, optionalTargets, policy, true);
        }
    }

    public static EncryptedData processEncryptedData(SOAPElement encDataElement, SecretKey key, XMLCipher dataCipher, FilterProcessingContext context, ArrayList requiredTargets, ArrayList optionalTargets, EncryptionPolicy encryptionPolicy, boolean updateSH) throws XWSSecurityException {
        EncryptedDataHeaderBlock xencEncryptedData = new EncryptedDataHeaderBlock(encDataElement);
        SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
        KeyInfoHeaderBlock keyInfo = xencEncryptedData.getKeyInfo();
        String algorithm = null;
        algorithm = xencEncryptedData.getEncryptionMethodURI();
        EncryptionPolicy inferredPolicy = (EncryptionPolicy)context.getInferredPolicy();
        EncryptionPolicy.FeatureBinding fb = null;
        EncryptionPolicy inferredWsdlEncPolicy = null;
        if (context.getMode() == 3) {
            try {
                int i = context.getInferredSecurityPolicy().size() - 1;
                inferredWsdlEncPolicy = (EncryptionPolicy)context.getInferredSecurityPolicy().get(i);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1237.Error.Processing.EncrpytedData", e);
                throw new XWSSecurityException((Throwable)e);
            }
        }
        if (inferredPolicy != null) {
            fb = (EncryptionPolicy.FeatureBinding)inferredPolicy.getFeatureBinding();
            fb.setDataEncryptionAlgorithm(algorithm);
        }
        SecretKey symmetricKey = null;
        if (keyInfo == null) {
            if (key == null) {
                log.log(Level.SEVERE, "WSS1231.null.SymmetricKey");
                throw new XWSSecurityException("Symmetric Key is null");
            }
            symmetricKey = key;
        } else {
            context.setDataEncryptionAlgorithm(algorithm);
            symmetricKey = (SecretKey)KeyResolver.getKey(keyInfo, false, context);
            context.setDataEncryptionAlgorithm(null);
        }
        if (symmetricKey == null) {
            log.log(Level.SEVERE, "WSS1202.couldnot.locate.symmetrickey");
            throw new XWSSecurityException("Couldn't locate symmetricKey for decryption");
        }
        boolean isAttachment = false;
        String type = xencEncryptedData.getType();
        if (type.equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only") || type.equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Complete")) {
            isAttachment = true;
        }
        Node parent = null;
        Node prevSibling = null;
        boolean contentOnly = false;
        Element actualEncrypted = null;
        AttachmentPart encryptedAttachment = null;
        AttachmentPart _attachmentBuffer = secureMessage.createAttachmentPart();
        if (isAttachment) {
            String uri = xencEncryptedData.getCipherReference(false, null).getAttribute("URI");
            contentOnly = type.equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only");
            try {
                AttachmentPart p = secureMessage.getAttachmentPart(uri);
                Iterator j = p.getAllMimeHeaders();
                while (j.hasNext()) {
                    MimeHeader mh = (MimeHeader)j.next();
                    _attachmentBuffer.setMimeHeader(mh.getName(), mh.getValue());
                }
                _attachmentBuffer.setDataHandler(p.getDataHandler());
                encryptedAttachment = DecryptionProcessor.decryptAttachment(secureMessage, xencEncryptedData, symmetricKey);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "WSS1232.failedto.decrypt.attachment", ioe);
                throw new XWSSecurityException((Throwable)ioe);
            }
            catch (SOAPException se) {
                log.log(Level.SEVERE, "WSS1232.failedto.decrypt.attachment", se);
                throw new XWSSecurityException((Throwable)se);
            }
            catch (MessagingException me) {
                log.log(Level.SEVERE, "WSS1232.failedto.decrypt.attachment", me);
                throw new XWSSecurityException((Throwable)me);
            }
            encDataElement.detachNode();
        } else {
            parent = encDataElement.getParentNode();
            prevSibling = encDataElement.getPreviousSibling();
            if (dataCipher == null) {
                dataCipher = DecryptionProcessor.initXMLCipher(symmetricKey, algorithm);
            }
            if (parent.getLocalName() == "EncryptedHeader" || parent.getLocalName().equals("EncryptedHeader")) {
                try {
                    encDataElement.getParentNode().getParentNode().replaceChild((Node)encDataElement, parent);
                    parent = encDataElement.getParentNode();
                    prevSibling = encDataElement.getPreviousSibling();
                }
                catch (DOMException e) {
                    log.log(Level.SEVERE, "WSS1242.exception.dom", e);
                    throw new XWSSecurityException((Throwable)e);
                }
            }
            DecryptionProcessor.decryptElementWithCipher(dataCipher, encDataElement, secureMessage);
            SOAPElement currentNode = null;
            if (updateSH && secureMessage.findSecurityHeader().getCurrentHeaderBlockElement() == encDataElement) {
                currentNode = prevSibling == null ? (SOAPElement)parent.getFirstChild() : (SOAPElement)prevSibling.getNextSibling();
                secureMessage.findSecurityHeader().setCurrentHeaderElement(currentNode);
            }
            if (xencEncryptedData.getType().equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                actualEncrypted = (Element)DecryptionProcessor.resolveEncryptedNode(parent, prevSibling, true);
                contentOnly = true;
            } else if (xencEncryptedData.getType().equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                actualEncrypted = (Element)DecryptionProcessor.resolveEncryptedNode(parent, prevSibling, false);
                contentOnly = false;
            }
        }
        if (context.getMode() == 1) {
            if (encryptionPolicy == null) {
                encryptionPolicy = new EncryptionPolicy();
            }
            EncryptionPolicy.FeatureBinding eFB = (EncryptionPolicy.FeatureBinding)encryptionPolicy.getFeatureBinding();
            EncryptionTarget encTarget = new EncryptionTarget();
            encTarget.setDataEncryptionAlgorithm(algorithm);
            encTarget.setContentOnly(contentOnly);
            if (isAttachment) {
                encTarget.addCipherReferenceTransform(type);
            }
            if (encryptedAttachment != null) {
                encTarget.setValue(encryptedAttachment.getContentId());
            } else {
                String id = actualEncrypted.getAttribute("Id");
                if ("".equals(id)) {
                    id = actualEncrypted.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                }
                encTarget.setValue(id);
            }
            encTarget.setType("uri");
            encTarget.setElementData(actualEncrypted);
            Iterator transformItr = xencEncryptedData.getTransforms();
            if (transformItr != null) {
                while (transformItr.hasNext()) {
                    encTarget.addCipherReferenceTransform((String)transformItr.next());
                }
            }
            eFB.addTargetBinding(encTarget);
            return null;
        }
        if (context.getMode() == 0 || context.getMode() == 2) {
            if (isAttachment) {
                return new AttachmentData(encryptedAttachment.getContentId(), contentOnly);
            }
            EncryptedElement encryptedElement = new EncryptedElement(actualEncrypted, contentOnly);
            return encryptedElement;
        }
        if (context.getMode() == 3) {
            QName qname = new QName(actualEncrypted.getNamespaceURI(), actualEncrypted.getLocalName());
            EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)inferredWsdlEncPolicy.getFeatureBinding();
            EncryptionTarget target = new EncryptionTarget();
            if (actualEncrypted.getNamespaceURI() != null && (actualEncrypted.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || actualEncrypted.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd") || actualEncrypted.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/sc") || actualEncrypted.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"))) {
                String id = actualEncrypted.getAttribute("Id");
                if ("".equals(id)) {
                    id = actualEncrypted.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                }
                target.setValue(id);
                target.setType("uri");
            } else {
                target.setQName(qname);
                target.setType("qname");
            }
            target.setDataEncryptionAlgorithm(algorithm);
            target.setContentOnly(contentOnly);
            featureBinding.addTargetBinding(target);
            if (qname.getLocalPart().equals("Assertion")) {
                featureBinding.encryptsIssuedToken(true);
            }
        }
        return null;
    }

    private static String getDataEncryptionAlgorithm(SOAPElement referenceList, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        try {
            ReferenceListHeaderBlock refList = new ReferenceListHeaderBlock(referenceList);
            NodeList dataRefElements = refList.getDataRefElements();
            Element dataRef = (Element)dataRefElements.item(0);
            String refURI = dataRef.getAttribute("URI");
            SOAPElement encDataElement = null;
            encDataElement = (SOAPElement)secureMsg.getElementById(refURI.substring(1));
            NodeList nodeList = encDataElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
            if (nodeList.getLength() <= 0) {
                return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            }
            Element em = (Element)nodeList.item(0);
            if (em != null) {
                String algo = em.getAttribute("Algorithm");
                if ("".equals(algo)) {
                    return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                }
                return algo;
            }
        }
        catch (XWSSecurityException xe) {
            log.log(Level.SEVERE, "WSS1233.failed.get.DataEncryptionAlgorithm", xe);
            throw xe;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WSS1233.failed.get.DataEncryptionAlgorithm", ex);
            throw new XWSSecurityException((Throwable)ex);
        }
        return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    }

    private static AttachmentPart decryptAttachment(SecurableSoapMessage ssm, EncryptedDataHeaderBlock edhb, SecretKey symmetricKey) throws IOException, SOAPException, MessagingException, XWSSecurityException {
        String uri = edhb.getCipherReference(false, null).getAttribute("URI");
        boolean contentOnly = edhb.getType().equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only");
        String mimeType = edhb.getMimeType();
        Element dsTransform = (Element)edhb.getTransforms().next();
        if (!dsTransform.getAttribute("Algorithm").equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform")) {
            log.log(Level.SEVERE, "WSS1234.invalid.transform=");
            throw new XWSSecurityException("Unexpected ds:Transform, " + dsTransform.getAttribute("Algorithm"));
        }
        AttachmentPart part = ssm.getAttachmentPart(uri);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        part.getDataHandler().writeTo((OutputStream)baos);
        byte[] cipherInput = baos.toByteArray();
        String tmp = edhb.getEncryptionMethodURI();
        Cipher decryptor = null;
        byte[] cipherOutput = null;
        try {
            decryptor = XMLCipherAdapter.constructCipher(tmp);
            int ivLen = decryptor.getBlockSize();
            byte[] ivBytes = new byte[ivLen];
            System.arraycopy(cipherInput, 0, ivBytes, 0, ivLen);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            decryptor.init(2, (Key)symmetricKey, iv);
            cipherOutput = decryptor.doFinal(cipherInput, ivLen, cipherInput.length - ivLen);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1232.failedto.decrypt.attachment", e);
            throw new XWSSecurityException((Throwable)e);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(cipherOutput);
        if (contentOnly) {
            part.setContentType(mimeType);
            String[] cLength = part.getMimeHeader("Content-Length");
            if (cLength != null && !cLength[0].equals("")) {
                part.setMimeHeader("Content-Length", Integer.toString(cipherOutput.length));
            }
            part.clearContent();
            part.setDataHandler(new DataHandler((DataSource)new _DS(cipherOutput, mimeType)));
        } else {
            MimeBodyPart decryptedAttachment = new MimeBodyPart((InputStream)is);
            String dcId = decryptedAttachment.getContentID();
            if (dcId == null || !uri.substring(4).equals(dcId.substring(1, dcId.length() - 1))) {
                log.log(Level.SEVERE, "WSS1234.unmatched.content-id");
                throw new XWSSecurityException("Content-Ids in encrypted and decrypted attachments donot match");
            }
            part.removeAllMimeHeaders();
            Enumeration h_enum = decryptedAttachment.getAllHeaders();
            while (h_enum.hasMoreElements()) {
                Header hdr = (Header)h_enum.nextElement();
                String hname = hdr.getName();
                String hvale = hdr.getValue();
                part.setMimeHeader(hname, hvale);
            }
            part.clearContent();
            part.setDataHandler(decryptedAttachment.getDataHandler());
        }
        return part;
    }

    private static boolean verifyTargets(SecurableSoapMessage ssm, ArrayList reqTargets, EncryptedData encData, boolean requiredTarget) throws XWSSecurityException {
        boolean found = false;
        for (int et = 0; et < reqTargets.size(); ++et) {
            EncryptionTarget encTarget = (EncryptionTarget)reqTargets.get(et);
            if (encData.isElementData()) {
                ArrayList list;
                EncryptedElement elementData = (EncryptedElement)encData;
                if (encTarget.getType() == "uri") {
                    Element element;
                    EncryptedElement ee;
                    if (encTarget.isAttachment() || !(ee = new EncryptedElement(element = ssm.getElementById(encTarget.getValue()), encTarget.getContentOnly())).equals((EncryptedElement)encData)) continue;
                    found = true;
                    reqTargets.remove(et);
                    break;
                }
                if (encTarget.getType() == "qname") {
                    ArrayList list2;
                    QName qname = encTarget.getQName();
                    String localPart = qname.getLocalPart();
                    if (!localPart.equals(elementData.getElement().getLocalName()) || !DecryptionProcessor.contains(list2 = DecryptionProcessor.getAllTargetElements(ssm, encTarget, requiredTarget), (EncryptedElement)encData)) continue;
                    reqTargets.remove(et);
                    found = true;
                    break;
                }
                if (encTarget.getType() != "xpath" || !DecryptionProcessor.contains(list = DecryptionProcessor.getAllTargetElements(ssm, encTarget, requiredTarget), (EncryptedElement)encData)) continue;
                reqTargets.remove(et);
                found = true;
                break;
            }
            if (encTarget.getType() != "uri" || !encTarget.isAttachment()) continue;
            if (encTarget.getValue().startsWith("cid:") && encTarget.getEnforce()) {
                AttachmentPart ap = ssm.getAttachmentPart(encTarget.getValue());
                AttachmentData ad = (AttachmentData)encData;
                if (ap == null || ad.getCID() != ap.getContentId() || ad.isContentOnly() != encTarget.getContentOnly()) continue;
                found = true;
                reqTargets.remove(et);
                break;
            }
            reqTargets.remove(et);
            found = true;
            break;
        }
        return found;
    }

    private static boolean contains(List targetList, EncryptedElement ee) {
        for (int i = 0; i < targetList.size(); ++i) {
            EncryptedElement ed = (EncryptedElement)targetList.get(i);
            if (!ed.equals(ee)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEquals(EncryptedData msgEd, EncryptedData reqEd) {
        if (msgEd.isElementData() && reqEd.isElementData()) {
            ((EncryptedElement)msgEd).equals((EncryptedElement)reqEd);
        } else if (msgEd.isAttachmentData() && reqEd.isAttachmentData()) {
            ((AttachmentData)msgEd).equals((AttachmentData)reqEd);
        }
        return false;
    }

    private static ArrayList getAllTargetElements(SecurableSoapMessage ssm, EncryptionTarget target, boolean reqElements) throws XWSSecurityException {
        ArrayList result;
        block7: {
            result = new ArrayList();
            boolean contentOnly = target.getContentOnly();
            try {
                Object obj = ssm.getMessageParts(target);
                if (obj instanceof SOAPElement) {
                    DecryptionProcessor.contribute((Node)obj, result, contentOnly);
                } else if (obj instanceof NodeList) {
                    DecryptionProcessor.contribute((NodeList)obj, result, contentOnly);
                } else if (obj instanceof Node) {
                    DecryptionProcessor.contribute((Node)obj, result, contentOnly);
                }
            }
            catch (XWSSecurityException xwse) {
                if (!reqElements) break block7;
                log.log(Level.SEVERE, "WSS1235.failedto.get.targetElements", xwse);
                throw xwse;
            }
        }
        return result;
    }

    private static void contribute(NodeList targetElements, ArrayList result, boolean contentOnly) {
        for (int i = 0; i < targetElements.getLength(); ++i) {
            DecryptionProcessor.contribute(targetElements.item(i), result, contentOnly);
        }
    }

    private static void contribute(Node element, ArrayList result, boolean contentOnly) {
        EncryptedElement targetElement = new EncryptedElement((Element)element, contentOnly);
        result.add(targetElement);
    }

    private static void contribute(AttachmentPart element, ArrayList result, boolean contentOnly) {
        AttachmentData targetElement = new AttachmentData(element.getContentId(), contentOnly);
        result.add(targetElement);
    }

    private static Node resolveEncryptedNode(Node parent, Node prevSibling, boolean contentOnly) {
        Node actualEncrypted = null;
        actualEncrypted = !contentOnly ? (prevSibling == null ? parent.getFirstChild() : prevSibling.getNextSibling()) : parent;
        return actualEncrypted;
    }

    private static XMLCipher initXMLCipher(Key key, String algorithm) throws XWSSecurityException {
        XMLCipher xmlCipher;
        try {
            xmlCipher = XMLCipher.getInstance((String)algorithm);
            xmlCipher.init(2, key);
        }
        catch (XMLEncryptionException xee) {
            log.log(Level.SEVERE, "WSS1203.unableto.decrypt.message", new Object[]{xee.getMessage()});
            throw new XWSSecurityException("Unable to decrypt message", (Throwable)xee);
        }
        return xmlCipher;
    }

    private static Document decryptElementWithCipher(XMLCipher xmlCipher, SOAPElement element, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        Document document = null;
        element.normalize();
        try {
            document = xmlCipher.doFinal((Document)secureMessage.getSOAPPart(), (Element)element);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS1203.unableto.decrypt.message", new Object[]{e.getMessage()});
            XWSSecurityException xse = new XWSSecurityException("Unable to decrypt message", (Throwable)e);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Unable to decrypt message", xse);
        }
        return document;
    }

    private static class _DS
    implements DataSource {
        byte[] _b = null;
        String _mt = null;

        _DS(byte[] b, String mt) {
            this._b = b;
            this._mt = mt;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this._b);
        }

        public OutputStream getOutputStream() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this._b, 0, this._b.length);
            return baos;
        }

        public String getName() {
            return "_DS";
        }

        public String getContentType() {
            return this._mt;
        }
    }

    private static class EncryptedElement
    implements EncryptedData {
        private Element element;
        private boolean contentOnly;
        private EncryptionPolicy policy = null;

        public EncryptedElement(Element element, boolean contentOnly) {
            this.element = element;
            this.contentOnly = contentOnly;
        }

        public Element getElement() {
            return this.element;
        }

        public boolean getContentOnly() {
            return this.contentOnly;
        }

        public boolean equals(EncryptedElement element) {
            EncryptedElement encryptedElement = element;
            return encryptedElement.getElement() == this.element && encryptedElement.getContentOnly() == this.contentOnly;
        }

        public void setpolicy(EncryptionPolicy policy) {
            this.policy = policy;
        }

        public EncryptionPolicy getPolicy() {
            return this.policy;
        }

        @Override
        public boolean isElementData() {
            return true;
        }

        @Override
        public boolean isAttachmentData() {
            return false;
        }
    }

    private static class AttachmentData
    implements EncryptedData {
        private String cid = null;
        private boolean contentOnly = false;

        public AttachmentData(String cid, boolean co) {
            this.cid = cid;
            this.contentOnly = co;
        }

        public String getCID() {
            return this.cid;
        }

        public boolean isContentOnly() {
            return this.contentOnly;
        }

        public boolean equals(AttachmentData data) {
            return this.cid != null && this.cid.equals(data.getCID()) && this.contentOnly == data.isContentOnly();
        }

        @Override
        public boolean isElementData() {
            return false;
        }

        @Override
        public boolean isAttachmentData() {
            return true;
        }
    }

    private static interface EncryptedData {
        public boolean isElementData();

        public boolean isAttachmentData();
    }
}

