/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.LogStringsMessages;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.UnsupportedPolicyAssertion;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class SecurityContextToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SecurityContextToken,
SecurityAssertionValidator {
    private String id;
    private boolean populated = false;
    private String tokenType;
    private PolicyAssertion rdKey = null;
    private Set<String> referenceType = null;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String includeToken;

    public SecurityContextToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public Iterator getTokenRefernceType() {
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.rdKey != null;
    }

    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public String getTokenId() {
        return this.id;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isSecurityContextTokenType(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart().intern();
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.rdKey = assertion;
                    continue;
                }
                if (PolicyUtil.isRequireExternalUriReference(assertion, this.spVersion)) {
                    if (this.referenceType == null) {
                        this.referenceType = new HashSet<String>();
                    }
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (assertion.isOptional()) continue;
                if (Constants.logger.getLevel() == Level.SEVERE) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0100_INVALID_SECURITY_ASSERTION(assertion, "SecurityContextToken"));
                }
                if (!isServer) continue;
                throw new UnsupportedPolicyAssertion("Policy assertion " + assertion + " is not supported under SecurityContextToken assertion");
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

