/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.assertion.saml20.jaxb20;

import com.sun.xml.security.core.dsig.KeyInfoType;
import com.sun.xml.wss.logging.LogStringsMessages;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.SubjectConfirmationDataType;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.util.DateUtils;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubjectConfirmationData
extends SubjectConfirmationDataType
implements com.sun.xml.wss.saml.SubjectConfirmationData {
    protected PublicKey keyInfoKeyValue = null;
    private Date notBeforeDate = null;
    private Date notOnOrAfterDate = null;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public SubjectConfirmationData() {
    }

    public static SubjectConfirmationDataType fromElement(Element element) throws SAMLException {
        try {
            JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            return (SubjectConfirmationDataType)u.unmarshal((Node)element);
        }
        catch (Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }

    public SubjectConfirmationData(String address, String inResponseTo, GregorianCalendar notBefore, GregorianCalendar notOnOrAfter, String recipient, Element keyInfo) throws SAMLException {
        DatatypeFactory factory;
        JAXBContext jc = null;
        Unmarshaller u = null;
        try {
            jc = SAML20JAXBUtil.getJAXBContext();
            u = jc.createUnmarshaller();
        }
        catch (Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
        this.setAddress(address);
        this.setInResponseTo(inResponseTo);
        if (notBefore != null) {
            try {
                factory = DatatypeFactory.newInstance();
                this.setNotBefore(factory.newXMLGregorianCalendar(notBefore));
            }
            catch (DatatypeConfigurationException ex) {
                // empty catch block
            }
        }
        if (notOnOrAfter != null) {
            try {
                factory = DatatypeFactory.newInstance();
                this.setNotOnOrAfter(factory.newXMLGregorianCalendar(notOnOrAfter));
            }
            catch (DatatypeConfigurationException ex) {
                // empty catch block
            }
        }
        this.setRecipient(recipient);
        try {
            if (keyInfo != null) {
                this.getContent().add((KeyInfoType)((JAXBElement)u.unmarshal((Node)keyInfo)).getValue());
            }
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    public SubjectConfirmationData(SubjectConfirmationDataType subConfDataType) {
        this.setAddress(subConfDataType.getAddress());
        this.setInResponseTo(subConfDataType.getInResponseTo());
        this.setNotBefore(subConfDataType.getNotBefore());
        this.setNotOnOrAfter(subConfDataType.getNotOnOrAfter());
        this.setRecipient(subConfDataType.getRecipient());
    }

    @Override
    public Date getNotBeforeDate() {
        if (this.notBeforeDate == null && super.getNotBefore() != null) {
            try {
                this.notBeforeDate = DateUtils.stringToDate(super.getNotBefore().toString());
            }
            catch (ParseException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0430_SAML_GET_NOT_BEFORE_DATE_OR_GET_NOT_ON_OR_AFTER_DATE_PARSE_FAILED(), ex);
            }
        }
        return this.notBeforeDate;
    }

    @Override
    public Date getNotOnOrAfterDate() {
        if (this.notOnOrAfterDate == null && super.getNotOnOrAfter() != null) {
            try {
                this.notOnOrAfterDate = DateUtils.stringToDate(super.getNotOnOrAfter().toString());
            }
            catch (ParseException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0430_SAML_GET_NOT_BEFORE_DATE_OR_GET_NOT_ON_OR_AFTER_DATE_PARSE_FAILED(), ex);
            }
        }
        return this.notOnOrAfterDate;
    }
}

