/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TeeFilter {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private static final String prettyPrintStylesheet = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:wsse='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'\n  version='1.0'>\n  <xsl:output method='xml' indent='yes'/>\n  <xsl:strip-space elements='*'/>\n  <xsl:template match='/'>\n    <xsl:apply-templates/>\n  </xsl:template>\n  <xsl:template match='node() | @*'>\n    <xsl:choose>\n      <xsl:when test='contains(name(current()), \"wsse:Password\")'>\n        <wsse:Password Type='{@Type}'>****</wsse:Password>\n      </xsl:when>\n      <xsl:otherwise>\n        <xsl:copy>\n          <xsl:apply-templates select='node() | @*'/>\n        </xsl:copy>\n      </xsl:otherwise>\n    </xsl:choose>\n  </xsl:template>\n</xsl:stylesheet>\n";
    private OutputStream out;
    private Templates templates;

    public TeeFilter(OutputStream out, Source stylesheet) throws XWSSecurityException {
        this.init(out, stylesheet);
    }

    public TeeFilter(OutputStream out, boolean prettyPrint) throws XWSSecurityException {
        if (prettyPrint) {
            this.init(out, this.getPrettyPrintStylesheet());
        } else {
            this.init(out, null);
        }
    }

    public TeeFilter(OutputStream out) throws XWSSecurityException {
        this.init(out, null);
    }

    public TeeFilter() throws XWSSecurityException {
        this.init(null, null);
    }

    private void init(OutputStream out, Source stylesheet) throws XWSSecurityException {
        this.out = out;
        if (stylesheet == null) {
            this.templates = null;
        } else {
            TransformerFactory tf = WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
            try {
                this.templates = tf.newTemplates(stylesheet);
            }
            catch (TransformerConfigurationException e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0147_DIAG_CAUSE_1(), new Object[]{e.getMessage()});
                throw new XWSSecurityException("Unable to use stylesheet", (Throwable)e);
            }
        }
    }

    private Source getPrettyPrintStylesheet() {
        byte[] xsltBytes = prettyPrintStylesheet.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(xsltBytes);
        StreamSource stylesheetSource = new StreamSource(bais);
        return stylesheetSource;
    }

    public void process(SOAPMessage secureMessage) throws XWSSecurityException {
        if (this.out == null) {
            return;
        }
        try {
            if (secureMessage.countAttachments() > 0) {
                secureMessage.writeTo(this.out);
            } else {
                Transformer transformer = this.templates == null ? WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING).newTransformer() : this.templates.newTransformer();
                Source msgSource = secureMessage.getSOAPPart().getContent();
                transformer.transform(msgSource, new StreamResult(this.out));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0148_UNABLETO_PROCESS_SOAPMESSAGE(new Object[]{ex.getMessage()}));
            throw new XWSSecurityException("Unable to process SOAPMessage", (Throwable)ex);
        }
    }
}

