/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.security.core.dsig.CustomStreamWriterImpl;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.Reference;
import com.sun.xml.ws.security.opt.crypto.dsig.Signature;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.jvnet.staxex.XMLStreamWriterEx;

public class JAXBSignatureHeaderElement
implements SecurityHeaderElement,
SecurityElementWriter {
    private boolean isCanonicalized = false;
    private byte[] cs = null;
    private Signature signature = null;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private Marshaller marshaller = null;
    private XMLSignContext signContext = null;

    public JAXBSignatureHeaderElement(Signature signature, SOAPVersion soapVersion) {
        this.signature = signature;
        this.soapVersion = soapVersion;
    }

    public JAXBSignatureHeaderElement(Signature signature, SOAPVersion soapVersion, XMLSignContext signctx) {
        this.signature = signature;
        this.soapVersion = soapVersion;
        this.signContext = signctx;
    }

    @Override
    public String getId() {
        return this.signature.getId();
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    @Override
    public String getLocalPart() {
        return "Signature";
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        try {
            this.getMarshaller().marshal((Object)this.signature, (Result)xbr);
        }
        catch (JAXBException je) {
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        try {
            if (streamWriter instanceof Map) {
                OutputStream os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream");
                if (os != null) {
                    streamWriter.writeCharacters("");
                    this.getMarshaller().marshal((Object)this.signature, os);
                    return;
                }
            } else if (streamWriter instanceof XMLStreamWriterEx) {
                CustomStreamWriterImpl swi = new CustomStreamWriterImpl(streamWriter);
                this.getMarshaller().marshal((Object)this.signature, (XMLStreamWriter)((Object)swi));
            } else {
                this.getMarshaller().marshal((Object)this.signature, streamWriter);
            }
        }
        catch (JAXBException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            marshaller.marshal((Object)this.signature, streamWriter);
        }
        catch (JAXBException jbe) {
            throw new XMLStreamException(jbe);
        }
    }

    public byte[] canonicalize(String algorithm, List<AttributeNS> namespaceDecls) {
        if (!this.isCanonicalized()) {
            this.canonicalizeSignature();
        }
        return this.cs;
    }

    public boolean isCanonicalized() {
        return this.isCanonicalized;
    }

    private Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.marshaller = JAXBUtil.createMarshaller(this.soapVersion);
        }
        return this.marshaller;
    }

    private void canonicalizeSignature() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        JAXBElement je;
        Object data;
        List<Object> list;
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(id);
        String refId = sb.toString();
        KeyInfo ki = this.signature.getKeyInfo();
        if (ki != null && (list = ki.getContent()).size() > 0 && (data = (je = (JAXBElement)list.get(0)).getValue()) instanceof SecurityHeaderElement && ((SecurityHeaderElement)data).refersToSecHdrWithId(id)) {
            return true;
        }
        List refList = this.signature.getSignedInfo().getReferences();
        for (int i = 0; i < refList.size(); ++i) {
            Reference ref = (Reference)refList.get(i);
            if (!ref.getURI().equals(refId)) continue;
            return true;
        }
        return false;
    }

    public void sign() throws XMLStreamException {
        try {
            this.signature.sign(this.signContext);
        }
        catch (MarshalException me) {
            throw new XMLStreamException(me);
        }
        catch (XMLSignatureException xse) {
            throw new XMLStreamException(xse);
        }
    }
}

