/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Claims;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Issuer;
import com.sun.xml.ws.security.impl.policy.IssuerName;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class HttpsToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.HttpsToken,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private boolean requireCC = false;
    private boolean httpBasicAuthentication = false;
    private boolean httpDigestAuthentication = false;
    private String id = "";
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName rccQname;
    private Issuer issuer = null;
    private IssuerName issuerName = null;
    private Claims claims = null;

    public HttpsToken() {
        this.id = PolicyUtil.randomUUID();
        this.rccQname = new QName(this.spVersion.namespaceUri, "RequireClientCertificate");
    }

    public HttpsToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.rccQname = new QName(this.spVersion.namespaceUri, "RequireClientCertificate");
    }

    public void setRequireClientCertificate(boolean value) {
        Map attrs = this.getAttributes();
        QName rccQname = new QName(this.spVersion.namespaceUri, "RequireClientCertificate");
        attrs.put(rccQname, Boolean.toString(value));
        this.requireCC = value;
    }

    @Override
    public boolean isRequireClientCertificate() {
        this.populate();
        return this.requireCC;
    }

    public String getIncludeToken() {
        throw new UnsupportedOperationException("This method is not supported for HttpsToken");
    }

    public void setIncludeToken(String type) {
        throw new UnsupportedOperationException("This method is not supported for HttpsToken");
    }

    public String getTokenId() {
        return this.id;
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public IssuerName getIssuerName() {
        this.populate();
        return this.issuerName;
    }

    @Override
    public Claims getClaims() {
        this.populate();
        return this.claims;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri.equals(this.spVersion.namespaceUri)) {
                String value = this.getAttributeValue(this.rccQname);
                this.requireCC = Boolean.valueOf(value);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isRequireClientCertificate(assertion, this.spVersion)) {
                    this.requireCC = true;
                    continue;
                }
                if (PolicyUtil.isHttpBasicAuthentication(assertion, this.spVersion)) {
                    this.httpBasicAuthentication = true;
                    continue;
                }
                if (PolicyUtil.isHttpDigestAuthentication(assertion, this.spVersion)) {
                    this.httpDigestAuthentication = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "HttpsToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            if (this.hasParameters()) {
                Iterator it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion;
                    assertion = (PolicyAssertion)it.next();
                    if (PolicyUtil.isIssuer(assertion, this.spVersion)) {
                        this.issuer = (Issuer)assertion;
                        continue;
                    }
                    if (PolicyUtil.isIssuerName(assertion, this.spVersion)) {
                        this.issuerName = (IssuerName)assertion;
                        continue;
                    }
                    if (!PolicyUtil.isClaimsElement(assertion) || !SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri)) continue;
                    this.claims = (Claims)assertion;
                }
            }
            if (this.issuer != null && this.issuerName != null) {
                Constants.log_invalid_assertion(this.issuerName, isServer, "SecureConversationToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_INVALID_VALUE;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }

    @Override
    public boolean isHttpBasicAuthentication() {
        this.populate();
        if (SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri.equals(this.spVersion.namespaceUri)) {
            throw new UnsupportedOperationException("HttpBasicAuthentication is only supported forSecurityPolicy 1.2 and later");
        }
        return this.httpBasicAuthentication;
    }

    @Override
    public boolean isHttpDigestAuthentication() {
        this.populate();
        if (SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri.equals(this.spVersion.namespaceUri)) {
            throw new UnsupportedOperationException("HttpDigestAuthentication is only supported forSecurityPolicy 1.2 and later");
        }
        return this.httpDigestAuthentication;
    }
}

