/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Claims;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Issuer;
import com.sun.xml.ws.security.impl.policy.IssuerName;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureConversationToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SecureConversationToken,
SecurityAssertionValidator {
    private NestedPolicy bootstrapPolicy = null;
    private String id = null;
    private boolean populated = false;
    private PolicyAssertion rdKey = null;
    private Set<String> referenceType = null;
    private Issuer issuer = null;
    private IssuerName issuerName = null;
    private String tokenType = null;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String includeToken;
    private PolicyAssertion mustNotSendCancel = null;
    private PolicyAssertion mustNotSendRenew = null;
    private Claims claims = null;

    public SecureConversationToken() {
        this.id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public SecureConversationToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public Set getTokenRefernceTypes() {
        this.populate();
        if (this.referenceType == null) {
            return Collections.emptySet();
        }
        return this.referenceType;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.rdKey != null;
    }

    @Override
    public boolean isMustNotSendCancel() {
        this.populate();
        return this.mustNotSendCancel != null;
    }

    @Override
    public boolean isMustNotSendRenew() {
        this.populate();
        return this.mustNotSendRenew != null;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public IssuerName getIssuerName() {
        this.populate();
        return this.issuerName;
    }

    @Override
    public Claims getClaims() {
        this.populate();
        return this.claims;
    }

    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        Map attrs = this.getAttributes();
        QName tokenName = new QName(this.spVersion.namespaceUri, "IncludeToken");
        attrs.put(tokenName, type);
    }

    @Override
    public NestedPolicy getBootstrapPolicy() {
        this.populate();
        return this.bootstrapPolicy;
    }

    public String getTokenId() {
        return this.id;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            String tmp = this.getAttributeValue(this.itQname);
            if (tmp != null) {
                this.includeToken = tmp;
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isBootstrapPolicy(assertion, this.spVersion)) {
                    this.bootstrapPolicy = assertion.getNestedPolicy();
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.rdKey = assertion;
                    continue;
                }
                if (PolicyUtil.isRequireExternalUriReference(assertion, this.spVersion)) {
                    if (this.referenceType == null) {
                        this.referenceType = new HashSet<String>();
                    }
                    this.referenceType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (PolicyUtil.isSC10SecurityContextToken(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart();
                    continue;
                }
                if (PolicyUtil.isMustNotSendCancel(assertion, this.spVersion)) {
                    this.mustNotSendCancel = assertion;
                    continue;
                }
                if (PolicyUtil.isMustNotSendRenew(assertion, this.spVersion)) {
                    this.mustNotSendRenew = assertion;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "SecureConversationToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            if (this.hasNestedAssertions()) {
                Iterator it = this.getNestedAssertionsIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = (PolicyAssertion)it.next();
                    if (PolicyUtil.isIssuer(assertion, this.spVersion)) {
                        this.issuer = (Issuer)assertion;
                        continue;
                    }
                    if (PolicyUtil.isIssuerName(assertion, this.spVersion)) {
                        this.issuerName = (IssuerName)assertion;
                        continue;
                    }
                    if (!PolicyUtil.isClaimsElement(assertion) || !SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri)) continue;
                    this.claims = (Claims)assertion;
                }
            }
            if (this.issuer != null && this.issuerName != null) {
                Constants.log_invalid_assertion(this.issuerName, isServer, "SecureConversationToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_INVALID_VALUE;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

