/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSecurityException;
import java.io.InputStream;
import javax.security.auth.callback.CallbackHandler;

public abstract class XWSSProcessorFactory {
    public static final String XWSS_PROCESSOR_FACTORY_PROPERTY = "com.sun.xml.wss.XWSSProcessorFactory";
    public static final String DEFAULT_XWSS_PROCESSOR_FACTORY = "com.sun.xml.wss.impl.misc.XWSSProcessorFactory2_0Impl";

    public static XWSSProcessorFactory newInstance() throws XWSSecurityException {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new XWSSecurityException(x.toString(), (Throwable)x);
        }
        try {
            String systemProp = System.getProperty(XWSS_PROCESSOR_FACTORY_PROPERTY);
            if (systemProp != null) {
                return (XWSSProcessorFactory)XWSSProcessorFactory.newInstance(systemProp, classLoader);
            }
            return (XWSSProcessorFactory)XWSSProcessorFactory.newInstance(DEFAULT_XWSS_PROCESSOR_FACTORY, classLoader);
        }
        catch (SecurityException se) {
            throw new XWSSecurityException(se.toString(), (Throwable)se);
        }
    }

    public abstract XWSSProcessor createProcessorForSecurityConfiguration(InputStream var1, CallbackHandler var2) throws XWSSecurityException;

    private static Object newInstance(String className, ClassLoader classLoader) throws XWSSecurityException {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new XWSSecurityException("Processor Factory " + className + " not found", (Throwable)x);
        }
        catch (Exception x) {
            throw new XWSSecurityException("Processor Factory " + className + " could not be instantiated: " + x, (Throwable)x);
        }
    }
}

