/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.security.opt.crypto.JAXBData;
import com.sun.xml.ws.security.opt.crypto.StreamWriterData;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;

public class StAXSTRTransformWriter
implements XMLStreamWriter,
StreamWriterData {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    private XMLStreamWriter nextWriter = null;
    private boolean ignore = false;
    private boolean derefSAMLKeyIdentifier = false;
    private Data data = null;
    private int index = 0;
    private NamespaceContextEx ns = null;
    private boolean directReference = false;
    private boolean first = true;
    private String directReferenceValue = "";
    private XMLCryptoContext xMLCryptoContext;
    private String strId = "";

    public StAXSTRTransformWriter(XMLStreamWriter writer, Data data, XMLCryptoContext xMLCryptoContext) {
        this.nextWriter = writer;
        this.data = data;
        if (data instanceof JAXBData) {
            this.ns = ((JAXBData)data).getNamespaceContext();
        } else if (data instanceof StreamWriterData) {
            this.ns = ((StreamWriterData)data).getNamespaceContext();
        }
        this.xMLCryptoContext = xMLCryptoContext;
    }

    public StAXSTRTransformWriter(Data data, XMLCryptoContext xMLCryptoContext, String refId) {
        this.data = data;
        if (data instanceof JAXBData) {
            this.ns = ((JAXBData)data).getNamespaceContext();
        } else if (data instanceof StreamWriterData) {
            this.ns = ((StreamWriterData)data).getNamespaceContext();
        }
        this.xMLCryptoContext = xMLCryptoContext;
        this.strId = refId;
    }

    public NamespaceContextEx getNamespaceContext() {
        return this.ns;
    }

    public void close() throws XMLStreamException {
        this.nextWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.nextWriter.flush();
    }

    public void writeEndDocument() throws XMLStreamException {
        if (this.index > 0) {
            int size = this.index;
            for (int i = 0; i < size; ++i) {
                this.writeEndElement();
            }
        }
        this.nextWriter.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.index == 1 && !this.ignore) {
            this.nextWriter.writeEndElement();
        }
        if (this.index > 0) {
            --this.index;
        }
        if (this.index == 0) {
            if (this.ignore) {
                this.ignore = false;
                this.derefernceSTR();
            }
            this.nextWriter.writeEndElement();
            if (this.derefSAMLKeyIdentifier) {
                this.derefSAMLKeyIdentifier = false;
            }
            if (this.directReference) {
                this.directReference = false;
            }
            return;
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartDocument();
        }
    }

    public void writeCharacters(char[] c, int index, int len) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeCharacters(c, index, len);
        } else if (this.derefSAMLKeyIdentifier) {
            this.strId = String.valueOf(c, index, len);
            if (this.strId == null) {
                throw new XMLStreamException("SAML Key Identifier is empty in SecurityTokenReference");
            }
        }
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.setDefaultNamespace(string);
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeCData(string);
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeCharacters(string);
        } else if (this.derefSAMLKeyIdentifier) {
            this.strId = string;
            if (this.strId == null) {
                throw new XMLStreamException("SAML Key Identifier is empty in SecurityTokenReference");
            }
        }
    }

    public void writeComment(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeComment(string);
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeDTD(string);
        }
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeDefaultNamespace(string);
        }
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEmptyElement(string);
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEntityRef(string);
        }
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeProcessingInstruction(string);
        }
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartDocument(string);
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartElement(string);
        }
        this.first = false;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.setNamespaceContext(namespaceContext);
        }
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.nextWriter.getProperty(string);
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.nextWriter.getPrefix(string);
    }

    public void setPrefix(String string, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.setPrefix(string, string0);
        }
    }

    public void writeAttribute(String localname, String value) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeAttribute(localname, value);
        } else if (this.directReference) {
            if (localname == "URI") {
                this.directReferenceValue = value;
            }
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(value) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(value)) {
            this.derefSAMLKeyIdentifier = true;
        }
    }

    public void writeEmptyElement(String string, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEmptyElement(string, string0);
        }
    }

    public void writeNamespace(String string, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeNamespace(string, string0);
        }
    }

    public void writeProcessingInstruction(String string, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeProcessingInstruction(string, string0);
        }
    }

    public void writeStartDocument(String string, String string0) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeStartDocument(string, string0);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (!this.ignore) {
            if (this.first && localName == "SecurityTokenReference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                return;
            }
            this.nextWriter.writeStartElement(namespaceURI, localName);
        } else {
            ++this.index;
        }
        this.first = false;
    }

    public void writeAttribute(String uri, String localname, String value) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeAttribute(uri, localname, value);
        } else if (this.directReference && localname == "URI") {
            this.directReferenceValue = value;
        }
    }

    public void writeEmptyElement(String string, String string0, String string1) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeEmptyElement(string, string0, string1);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (!this.ignore) {
            if (this.first && localName == "SecurityTokenReference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                return;
            }
            if (this.first && localName == "Reference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                this.directReference = true;
                this.nextWriter.writeNamespace(prefix, namespaceURI);
                return;
            }
            if (this.first && localName == "KeyIdentifier" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
                this.ignore = true;
                ++this.index;
                this.nextWriter.writeNamespace(prefix, namespaceURI);
            } else {
                this.nextWriter.writeStartElement(prefix, localName, namespaceURI);
            }
        } else if (localName == "Reference" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
            ++this.index;
            this.directReference = true;
        } else if (localName == "KeyIdentifier" && namespaceURI == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") {
            ++this.index;
            this.nextWriter.writeNamespace(prefix, namespaceURI);
        } else {
            this.nextWriter.writeStartElement(prefix, localName, namespaceURI);
        }
        this.first = false;
    }

    public void writeAttribute(String prefix, String uri, String localName, String value) throws XMLStreamException {
        if (!this.ignore) {
            this.nextWriter.writeNamespace(prefix, uri);
            this.nextWriter.writeAttribute(prefix, uri, localName, value);
        } else if (this.directReference && localName == "URI") {
            this.directReferenceValue = value;
        }
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        this.nextWriter = writer;
        if (this.nextWriter instanceof StAXEXC14nCanonicalizerImpl) {
            ((StAXEXC14nCanonicalizerImpl)this.nextWriter).forceDefaultNS(true);
        }
        if (this.data instanceof JAXBData) {
            try {
                ((JAXBData)this.data).writeTo(this);
                NamespaceContextEx nc = ((JAXBData)this.data).getNamespaceContext();
                for (NamespaceContextEx.Binding nd : nc) {
                    this.nextWriter.writeNamespace(nd.getPrefix(), nd.getNamespaceURI());
                }
            }
            catch (XWSSecurityException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1706_ERROR_ENVELOPED_SIGNATURE(), ex);
                throw new XMLStreamException("Error occurred while performing Enveloped Signature");
            }
        } else if (this.data instanceof StreamWriterData) {
            StreamWriterData swd = (StreamWriterData)this.data;
            NamespaceContextEx nc = swd.getNamespaceContext();
            for (NamespaceContextEx.Binding nd : nc) {
                this.nextWriter.writeNamespace(nd.getPrefix(), nd.getNamespaceURI());
            }
            ((StreamWriterData)this.data).write(this);
        } else if (this.data instanceof OctectStreamData) {
            ((OctectStreamData)this.data).write(this);
        }
    }

    void derefernceSTR() throws XMLStreamException {
        Data token = null;
        URIDereferencer deRef = this.xMLCryptoContext.getURIDereferencer();
        final String uri = this.directReference ? this.directReferenceValue : (this.strId != null && this.strId.length() > 0 ? this.strId : "");
        URIReference ref = new URIReference(){

            public String getType() {
                return "";
            }

            public String getURI() {
                return uri;
            }
        };
        try {
            token = deRef.dereference(ref, this.xMLCryptoContext);
        }
        catch (URIReferenceException ue) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1716_ERROR_DEREFERENCE_STR_TRANSFORM(), ue);
            throw new XMLStreamException("Error occurred while dereferencing STR-Transform's Reference Element", ue);
        }
        if (token != null) {
            if (token instanceof JAXBData) {
                try {
                    ((JAXBData)token).writeTo(this);
                }
                catch (XWSSecurityException ex) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1706_ERROR_ENVELOPED_SIGNATURE(), ex);
                    throw new XMLStreamException("Error occurred while performing Enveloped Signature");
                }
            } else if (token instanceof StreamWriterData) {
                ((StreamWriterData)token).write(this);
            } else if (token instanceof OctectStreamData) {
                ((OctectStreamData)token).write(this);
            }
        }
    }
}

