/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.ha;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HighlyAvailableMap<K extends Serializable, V>
implements Map<K, V> {
    private static final Logger LOGGER = Logger.getLogger(HighlyAvailableMap.class);
    private final Map<K, V> localMap;
    private final ReplicationManager<K, V> replicationManager;
    private final String loggerProlog;

    public static <K extends Serializable, V extends Serializable> HighlyAvailableMap<K, V> create(String name, Map<K, V> wrappedMap, BackingStore<K, V> backingStore) {
        return new HighlyAvailableMap<K, V>(name, wrappedMap, new SimpleReplicationManager<K, V>(name + "_MANAGER", backingStore));
    }

    public static <K extends Serializable, V extends Serializable> HighlyAvailableMap<K, V> createSticky(String name, Map<K, V> wrappedMap, BackingStore<StickyKey, V> backingStore) {
        return new HighlyAvailableMap<K, V>(name, wrappedMap, new StickyReplicationManager(name + "_MANAGER", backingStore));
    }

    public static <K extends Serializable, V> HighlyAvailableMap<K, V> create(String name, Map<K, V> wrappedMap, ReplicationManager<K, V> replicationManager) {
        if (replicationManager == null) {
            replicationManager = new NoopReplicationManager(name + "_MANAGER");
        }
        return new HighlyAvailableMap<K, V>(name, wrappedMap, replicationManager);
    }

    private HighlyAvailableMap(String name, Map<K, V> wrappedMap, ReplicationManager<K, V> replicationManager) {
        this.loggerProlog = "[" + name + "]: ";
        this.localMap = wrappedMap;
        this.replicationManager = replicationManager;
    }

    @Override
    public int size() {
        return this.localMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.localMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Serializable _key = (Serializable)key;
        if (this.localMap.containsKey(_key)) {
            return true;
        }
        return this.tryLoad(_key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.localMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Serializable _key;
        V value;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Retrieving data for key [" + key + "]");
        }
        if ((value = this.localMap.get(_key = (Serializable)key)) != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Data for key [" + key + "] found in a local cache: " + value);
            }
            return value;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Data for key [" + key + "] not found in the local cache - consulting replication manager");
        }
        return this.tryLoad(_key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Storing data for key [" + key + "]: " + value);
        }
        this.replicationManager.save(key, value, (oldValue = this.localMap.put(key, value)) == null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Old data replaced for key [" + key + "]: " + oldValue);
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        Serializable _key = (Serializable)key;
        if (!this.localMap.containsKey(_key)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Data for key [" + key + "] not found in the local cache - consulting replication manager");
            }
            this.tryLoad(_key);
        }
        V oldValue = this.localMap.remove(_key);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Removing data for key [" + key + "]: " + oldValue);
        }
        this.replicationManager.remove(_key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put((K)((Serializable)e.getKey()), e.getValue());
        }
    }

    private V tryLoad(K key) {
        V value;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Using replication manager to load data for key [" + key + "]");
        }
        if ((value = this.replicationManager.load(key)) != null) {
            this.localMap.put(key, value);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Replication manager returned data for key [" + key + "]: " + value);
        }
        return value;
    }

    @Override
    public void clear() {
        for (Serializable key : this.localMap.keySet()) {
            this.replicationManager.remove(key);
        }
        this.localMap.clear();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "HA map cleared");
        }
    }

    @Override
    public Set<K> keySet() {
        return this.localMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.localMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.localMap.entrySet();
    }

    public Map<K, V> getLocalMapCopy() {
        return new HashMap<K, V>(this.localMap);
    }

    public void invalidateCache() {
        this.localMap.clear();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "local cache invalidated");
        }
    }

    public ReplicationManager<K, V> getReplicationManager() {
        return this.replicationManager;
    }

    public void close() {
        this.replicationManager.close();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "HA map closed");
        }
    }

    public void destroy() {
        this.replicationManager.destroy();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "HA map destroyed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StickyReplicationManager<K extends Serializable, V extends Serializable>
    implements ReplicationManager<K, V> {
        private final BackingStore<StickyKey, V> backingStore;
        private final String loggerProlog;

        public StickyReplicationManager(String name, BackingStore<StickyKey, V> backingStore) {
            this.backingStore = backingStore;
            this.loggerProlog = "[" + name + "]: ";
        }

        @Override
        public V load(K key) {
            Serializable data = HighAvailabilityProvider.loadFrom(this.backingStore, (Serializable)new StickyKey(key), null);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "loaded data for key [" + key + "]: " + data);
            }
            return (V)data;
        }

        @Override
        public void save(K key, V value, boolean isNew) {
            HaInfo haInfo;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "sending for replication [key=" + key + ", value=" + value + ", isNew=" + isNew + "]");
            }
            if ((haInfo = HaContext.currentHaInfo()) != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.loggerProlog + "Existing HaInfo found, using it for data replication: " + HaContext.asString((HaInfo)haInfo));
                }
                HighAvailabilityProvider.saveTo(this.backingStore, (Serializable)new StickyKey(key, haInfo.getKey()), value, (boolean)isNew);
            } else {
                StickyKey stickyKey = new StickyKey(key);
                String replicaId = HighAvailabilityProvider.saveTo(this.backingStore, (Serializable)stickyKey, value, (boolean)isNew);
                haInfo = new HaInfo(stickyKey.getHashKey(), replicaId, false);
                HaContext.updateHaInfo((HaInfo)haInfo);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(this.loggerProlog + "No HaInfo found, created new after data replication: " + HaContext.asString((HaInfo)haInfo));
                }
            }
        }

        @Override
        public void remove(K key) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "removing data for key: " + key);
            }
            HighAvailabilityProvider.removeFrom(this.backingStore, (Serializable)new StickyKey(key));
        }

        @Override
        public void close() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "closing backing store");
            }
            HighAvailabilityProvider.close(this.backingStore);
        }

        @Override
        public void destroy() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "destroying backing store");
            }
            HighAvailabilityProvider.destroy(this.backingStore);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SimpleReplicationManager<K extends Serializable, V extends Serializable>
    implements ReplicationManager<K, V> {
        private final BackingStore<K, V> backingStore;
        private final String loggerProlog;

        public SimpleReplicationManager(String name, BackingStore<K, V> backingStore) {
            this.backingStore = backingStore;
            this.loggerProlog = "[" + name + "]: ";
        }

        @Override
        public V load(K key) {
            Serializable data = HighAvailabilityProvider.loadFrom(this.backingStore, key, null);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "loaded data for key [" + key + "]: " + data);
            }
            return (V)data;
        }

        @Override
        public void save(K key, V value, boolean isNew) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "sending for replication [key=" + key + ", value=" + value + ", isNew=" + isNew + "]");
            }
            HighAvailabilityProvider.saveTo(this.backingStore, key, value, (boolean)isNew);
        }

        @Override
        public void remove(K key) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "removing data for key: " + key);
            }
            HighAvailabilityProvider.removeFrom(this.backingStore, key);
        }

        @Override
        public void close() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "closing backing store");
            }
            HighAvailabilityProvider.close(this.backingStore);
        }

        @Override
        public void destroy() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "destroying backing store");
            }
            HighAvailabilityProvider.destroy(this.backingStore);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NoopReplicationManager<K extends Serializable, V>
    implements ReplicationManager<K, V> {
        private final String loggerProlog;

        public NoopReplicationManager(String name) {
            this.loggerProlog = "[" + name + "]: ";
        }

        @Override
        public V load(K key) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "load() method invoked for key: " + key);
            }
            return null;
        }

        @Override
        public void save(K key, V value, boolean isNew) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "save() method invoked for [key=" + key + ", value=" + value + ", isNew=" + isNew + "]");
            }
        }

        @Override
        public void remove(K key) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "remove() method invoked for key: " + key);
            }
        }

        @Override
        public void close() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "close() invoked");
            }
        }

        @Override
        public void destroy() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "destroy() invoked");
            }
        }
    }
}

