/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.ha.HighlyAvailableMap;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceMaintenanceTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.SequenceDataPojo;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.UnackedMessageReplicationManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InVmSequenceManager
implements SequenceManager,
ReplicationManager<String, AbstractSequence> {
    private static final Logger LOGGER = Logger.getLogger(InVmSequenceManager.class);
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final HighlyAvailableMap<String, AbstractSequence> sequences;
    private final BackingStore<StickyKey, SequenceDataPojo> sequenceDataBs;
    private final HighlyAvailableMap<String, String> boundSequences;
    private final HighlyAvailableMap<String, ApplicationMessage> unackedMessageStore;
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;
    private final long sequenceInactivityTimeout;
    private final long maxConcurrentInboundSequences;
    private final AtomicLong actualConcurrentInboundSequences;

    public InVmSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, RmConfiguration configuration) {
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
        this.sequenceInactivityTimeout = configuration.getRmFeature().getSequenceInactivityTimeout();
        this.actualConcurrentInboundSequences = new AtomicLong(0L);
        this.maxConcurrentInboundSequences = configuration.getRmFeature().getMaxConcurrentSessions();
        BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
        this.boundSequences = HighlyAvailableMap.create(new HashMap(), (BackingStore)HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, uniqueEndpointId + "_BOUND_SEQUENCE_BS", String.class, String.class));
        this.sequenceDataBs = HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, uniqueEndpointId + "_SEQUENCE_DATA_BS", StickyKey.class, SequenceDataPojo.class);
        this.sequences = HighlyAvailableMap.create(new HashMap(), (ReplicationManager)this);
        UnackedMessageReplicationManager unackedMsgRM = null;
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            unackedMsgRM = new UnackedMessageReplicationManager(uniqueEndpointId);
        }
        this.unackedMessageStore = HighlyAvailableMap.create(new HashMap(), (ReplicationManager)unackedMsgRM);
        MaintenanceTaskExecutor.INSTANCE.register((DelayedTaskManager.DelayedTask)new SequenceMaintenanceTask(this, configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS), configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Sequence> sequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>((Map<String, Sequence>)this.sequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> boundSequences() {
        try {
            this.dataLock.readLock().lock();
            Map map = this.boundSequences.getLocalMapCopy();
            return map;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public long concurrentlyOpenedInboundSequencesCount() {
        return this.actualConcurrentInboundSequences.longValue();
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        SequenceDataPojo sequenceDataPojo = new SequenceDataPojo(sequenceId, strId, expirationTime, false, this.sequenceDataBs);
        sequenceDataPojo.setState(Sequence.State.CREATED);
        sequenceDataPojo.setAckRequestedFlag(false);
        sequenceDataPojo.setLastMessageNumber(0L);
        sequenceDataPojo.setLastActivityTime(this.currentTimeInMillis());
        sequenceDataPojo.setLastAcknowledgementRequestTime(0L);
        InVmSequenceData data = InVmSequenceData.newInstace(sequenceDataPojo, this, this.unackedMessageStore);
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        long actualSessions = this.actualConcurrentInboundSequences.incrementAndGet();
        if (this.maxConcurrentInboundSequences >= 0L && this.maxConcurrentInboundSequences < actualSessions) {
            this.actualConcurrentInboundSequences.decrementAndGet();
            throw new RxRuntimeException(LocalizationMessages.WSRM_1156_MAX_CONCURRENT_SESSIONS_REACHED(this.maxConcurrentInboundSequences));
        }
        SequenceDataPojo sequenceDataPojo = new SequenceDataPojo(sequenceId, strId, expirationTime, true, this.sequenceDataBs);
        sequenceDataPojo.setState(Sequence.State.CREATED);
        sequenceDataPojo.setAckRequestedFlag(false);
        sequenceDataPojo.setLastMessageNumber(0L);
        sequenceDataPojo.setLastActivityTime(this.currentTimeInMillis());
        sequenceDataPojo.setLastAcknowledgementRequestTime(0L);
        InVmSequenceData data = InVmSequenceData.newInstace(sequenceDataPojo, this, this.unackedMessageStore);
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        if (sequenceId == null) {
            throw new UnknownSequenceException("[null-sequence-identifier]");
        }
        try {
            this.dataLock.readLock().lock();
            Sequence sequence = (Sequence)this.sequences.get((Object)sequenceId);
            if (sequence == null) {
                throw new UnknownSequenceException(sequenceId);
            }
            if (this.shouldTeminate(sequence)) {
                this.dataLock.readLock().unlock();
                this.tryTerminateSequence(sequenceId);
                this.dataLock.readLock().lock();
            }
            Sequence sequence2 = sequence;
            return sequence2;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        if (sequenceId == null) {
            return false;
        }
        try {
            this.dataLock.readLock().lock();
            Sequence s = (Sequence)this.sequences.get((Object)sequenceId);
            boolean bl = s != null && s.getState() != Sequence.State.TERMINATING;
            return bl;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence tryTerminateSequence(String sequenceId) {
        if (sequenceId == null) {
            return null;
        }
        try {
            this.dataLock.writeLock().lock();
            Sequence sequence = (Sequence)this.sequences.get((Object)sequenceId);
            if (sequence == null) {
                Sequence sequence2 = null;
                return sequence2;
            }
            if (sequence.getState() != Sequence.State.TERMINATING) {
                if (sequence instanceof InboundSequence) {
                    this.actualConcurrentInboundSequences.decrementAndGet();
                }
                sequence.preDestroy();
            }
            Sequence sequence3 = sequence;
            return sequence3;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.tryTerminateSequence(sequenceId);
        if (sequence == null) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (!this.sequences.containsKey((Object)referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey((Object)boundSequenceId)) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            this.boundSequences.put((Serializable)((Object)referenceSequenceId), (Object)boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            if (!this.isValid(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            AbstractSequence abstractSequence = this.boundSequences.containsKey((Object)referenceSequenceId) ? (AbstractSequence)this.sequences.get(this.boundSequences.get((Object)referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (this.sequences.containsKey((Object)sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put((Serializable)((Object)sequence.getId()), (Object)sequence);
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMaintenance() {
        LOGGER.entering();
        try {
            this.dataLock.writeLock().lock();
            Iterator sequenceKeyIterator = this.sequences.keySet().iterator();
            while (sequenceKeyIterator.hasNext()) {
                String key = (String)sequenceKeyIterator.next();
                Sequence sequence = (Sequence)this.sequences.get((Object)key);
                if (this.shouldRemove(sequence)) {
                    LOGGER.config(LocalizationMessages.WSRM_1152_REMOVING_SEQUENCE(sequence.getId()));
                    sequenceKeyIterator.remove();
                    this.sequences.getReplicationManager().remove((Serializable)((Object)key));
                    if (!this.boundSequences.containsKey((Object)sequence.getId())) continue;
                    this.boundSequences.remove((Object)sequence.getId());
                    continue;
                }
                if (!this.shouldTeminate(sequence)) continue;
                LOGGER.config(LocalizationMessages.WSRM_1153_TERMINATING_SEQUENCE(sequence.getId()));
                this.tryTerminateSequence(sequence.getId());
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
            LOGGER.exiting();
        }
    }

    private boolean shouldTeminate(Sequence sequence) {
        return sequence.getState() != Sequence.State.TERMINATING && (sequence.isExpired() || sequence.getLastActivityTime() + this.sequenceInactivityTimeout < this.currentTimeInMillis());
    }

    private boolean shouldRemove(Sequence sequence) {
        return sequence.getState() == Sequence.State.TERMINATING;
    }

    @Override
    public void invalidateCache() {
        this.sequences.invalidateCache();
        this.boundSequences.invalidateCache();
        this.unackedMessageStore.invalidateCache();
    }

    public AbstractSequence load(String key) {
        SequenceDataPojo state = (SequenceDataPojo)HighAvailabilityProvider.loadFrom(this.sequenceDataBs, (Serializable)new StickyKey((Serializable)((Object)key)), null);
        if (state == null) {
            return null;
        }
        state.setBackingStore(this.sequenceDataBs);
        InVmSequenceData data = InVmSequenceData.loadReplica(state, this, this.unackedMessageStore);
        return state.isInbound() ? new InboundSequence(data, this.outboundQueueBuilder, this) : new OutboundSequence(data, this.outboundQueueBuilder, this);
    }

    public void save(String key, AbstractSequence value, boolean isNew) {
        SequenceData _data = value.getData();
        if (!(_data instanceof InVmSequenceData)) {
            throw new IllegalArgumentException("Unsupported sequence data class: " + _data.getClass().getName());
        }
        InVmSequenceData data = (InVmSequenceData)_data;
        HaInfo haInfo = HaContext.currentHaInfo();
        if (haInfo != null) {
            HighAvailabilityProvider.saveTo(this.sequenceDataBs, (Serializable)new StickyKey((Serializable)((Object)key), haInfo.getKey()), (Serializable)data.getSequenceStatePojo(), (boolean)isNew);
        } else {
            StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
            String replicaId = HighAvailabilityProvider.saveTo(this.sequenceDataBs, (Serializable)stickyKey, (Serializable)data.getSequenceStatePojo(), (boolean)isNew);
            HaContext.updateHaInfo((HaInfo)new HaInfo(stickyKey.getHashKey(), replicaId, false));
        }
    }

    public void remove(String key) {
        HighAvailabilityProvider.removeFrom(this.sequenceDataBs, (Serializable)new StickyKey((Serializable)((Object)key)));
    }

    public void close() {
        HighAvailabilityProvider.close(this.sequenceDataBs);
    }

    public void destroy() {
        HighAvailabilityProvider.destroy(this.sequenceDataBs);
    }
}

