/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.DelayedTaskManager;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.MessageHandler;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum RedeliveryTaskExecutor {
    INSTANCE;

    private static final Logger LOGGER;
    private final DelayedTaskManager delayedTaskManager = DelayedTaskManager.createManager((String)"redelivery-task-executor", (int)5);

    public boolean register(final ApplicationMessage message, long delay, TimeUnit timeUnit, final MessageHandler messageHandler) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("A message with number [ %d ] has been scheduled for a redelivery on a sequence [ %s ] with a delay of %d %s", message.getMessageNumber(), message.getSequenceId(), delay, timeUnit.toString().toLowerCase()));
        }
        final HaContext.State state = HaContext.currentState();
        return this.delayedTaskManager.register(new DelayedTaskManager.DelayedTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(DelayedTaskManager manager) {
                HaContext.State oldState = HaContext.initFrom((HaContext.State)state);
                try {
                    messageHandler.putToDeliveryQueue(message);
                }
                finally {
                    HaContext.initFrom((HaContext.State)oldState);
                }
            }

            public String getName() {
                return String.format("redelivery of a message with number [ %d ] on a sequenece [ %s ]", message.getMessageNumber(), message.getSequenceId());
            }
        }, delay, timeUnit);
    }

    static {
        LOGGER = Logger.getLogger(RedeliveryTaskExecutor.class);
    }
}

