/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.message.RxMessage;
import com.sun.xml.ws.rx.message.jaxws.SerializableMessage;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessageBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class JaxwsApplicationMessage
extends ApplicationMessageBase {
    private final SerializableMessage jaxwsMessage;

    public JaxwsApplicationMessage(@NotNull Packet packet, @NotNull String correlationId) {
        super(correlationId);
        assert (packet != null);
        assert (packet.getMessage() != null);
        this.jaxwsMessage = new SerializableMessage(packet, null);
    }

    private JaxwsApplicationMessage(@NotNull SerializableMessage jaxwsMessage, int initialResendCounterValue, @NotNull String correlationId, @NotNull String sequenceId, long messageNumber) {
        super(initialResendCounterValue, correlationId, sequenceId, messageNumber, null);
        this.jaxwsMessage = jaxwsMessage;
    }

    @NotNull
    public Message getJaxwsMessage() {
        return this.jaxwsMessage.getMessage();
    }

    @NotNull
    public Packet getPacket() {
        return this.jaxwsMessage.getPacket();
    }

    void setPacket(Packet newPacket) {
        this.jaxwsMessage.setPacket(newPacket);
    }

    public byte[] toBytes() {
        return this.jaxwsMessage.toBytes();
    }

    public String getWsaAction() {
        return this.jaxwsMessage.getWsaAction();
    }

    public JaxwsApplicationMessageState getState() {
        return new JaxwsApplicationMessageState(this);
    }

    public static JaxwsApplicationMessage newInstance(@NotNull InputStream dataStream, int initialResendCounterValue, @NotNull String correlationId, @NotNull String wsaAction, @NotNull String sequenceId, long messageNumber) {
        SerializableMessage jaxwsMessage = SerializableMessage.newInstance((InputStream)dataStream, (String)wsaAction);
        return new JaxwsApplicationMessage(jaxwsMessage, initialResendCounterValue, correlationId, sequenceId, messageNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JAX-WS Application Message { ");
        sb.append("sequenceId=[ ").append(this.getSequenceId()).append(" ], ");
        sb.append("messageNumber=[ ").append(this.getMessageNumber()).append(" ], ");
        sb.append("correlationId=[ ").append(this.getCorrelationId()).append(" ], ");
        sb.append("nextResendCount=[ ").append(this.getNextResendCount()).append(" ], ");
        sb.append("wsaAction=[ ").append(this.jaxwsMessage.getWsaAction());
        sb.append(" ] }");
        return super.toString();
    }

    public static class JaxwsApplicationMessageState
    implements RxMessage.State {
        private final byte[] data;
        private final int nextResendCount;
        private final String correlationId;
        private final String wsaAction;
        private final String sequenceId;
        private final long messageNumber;

        private JaxwsApplicationMessageState(JaxwsApplicationMessage message) {
            this.data = message.toBytes();
            this.nextResendCount = message.getNextResendCount();
            this.correlationId = message.getCorrelationId();
            this.wsaAction = message.getWsaAction();
            this.sequenceId = message.getSequenceId();
            this.messageNumber = message.getMessageNumber();
        }

        public JaxwsApplicationMessage toMessage() {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            return JaxwsApplicationMessage.newInstance(bais, this.nextResendCount, this.correlationId, this.wsaAction, this.sequenceId, this.messageNumber);
        }
    }
}

