/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.ScheduledTaskManager;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.dev.ProtocolMessageHandler;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MakeConnectionElement;
import com.sun.xml.ws.rx.mc.runtime.McClientTube;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.WsMcResponseHandler;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

final class MakeConnectionSenderTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(MakeConnectionSenderTask.class);
    private final String wsmcAnonymousAddress;
    private final Header wsmcAnnonymousReplyToHeader;
    private final Header wsmcAnnonymousFaultToHeader;
    private long lastMcMessageTimestamp;
    private final AtomicBoolean isMcRequestPending;
    private int scheduledMcRequestCounter;
    private final McConfiguration configuration;
    private final Communicator communicator;
    private final SuspendedFiberStorage suspendedFiberStorage;
    private final Map<String, ProtocolMessageHandler> mapOfRegisteredProtocolMessageHandlers;
    private final ScheduledTaskManager scheduler;
    private final AtomicBoolean isRunning;
    private final AtomicBoolean wasShutdown;

    MakeConnectionSenderTask(Communicator communicator, SuspendedFiberStorage suspendedFiberStorage, String wsmcAnonymousAddress, Header wsmcAnnonymousReplyToHeader, Header wsmcAnnonymousFaultToHeader, McConfiguration configuration) {
        this.communicator = communicator;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.wsmcAnonymousAddress = wsmcAnonymousAddress;
        this.wsmcAnnonymousReplyToHeader = wsmcAnnonymousReplyToHeader;
        this.wsmcAnnonymousFaultToHeader = wsmcAnnonymousFaultToHeader;
        this.configuration = configuration;
        this.mapOfRegisteredProtocolMessageHandlers = new HashMap<String, ProtocolMessageHandler>();
        this.lastMcMessageTimestamp = System.currentTimeMillis();
        this.isMcRequestPending = new AtomicBoolean(false);
        this.scheduledMcRequestCounter = 0;
        this.scheduler = new ScheduledTaskManager("MakeConnectionSenderTask", communicator.getContainer());
        this.isRunning = new AtomicBoolean(false);
        this.wasShutdown = new AtomicBoolean(false);
    }

    public void start() {
        if (this.wasShutdown.get()) {
            throw new IllegalStateException("This task instance has already been shut down in the past.");
        }
        if (this.isRunning.compareAndSet(false, true)) {
            this.scheduler.startTask((Runnable)this, 2000L, 500L);
        }
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public boolean wasShutdown() {
        return this.wasShutdown.get();
    }

    public void shutdown() {
        if (this.isRunning.compareAndSet(true, false) && this.wasShutdown.compareAndSet(false, true)) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public synchronized void run() {
        if (!this.isMcRequestPending.get() && this.resendMakeConnectionIntervalPassed() && (this.scheduledMcRequestCounter > 0 || this.suspendedFibersReadyForResend())) {
            this.sendMcRequest();
        }
    }

    private boolean suspendedFibersReadyForResend() {
        while (!this.suspendedFiberStorage.isEmpty()) {
            long oldestRegistrationAge = System.currentTimeMillis() - this.suspendedFiberStorage.getOldestRegistrationTimestamp();
            if (oldestRegistrationAge > this.configuration.getFeature().getResponseRetrievalTimeout()) {
                ((Fiber)this.suspendedFiberStorage.removeOldest()).resume((Throwable)new RxRuntimeException(LocalizationMessages.WSMC_0123_RESPONSE_RETRIEVAL_TIMED_OUT()));
                continue;
            }
            return oldestRegistrationAge > this.configuration.getFeature().getBaseMakeConnectionRequetsInterval();
        }
        return false;
    }

    private synchronized boolean resendMakeConnectionIntervalPassed() {
        return System.currentTimeMillis() - this.lastMcMessageTimestamp > this.configuration.getFeature().getBaseMakeConnectionRequetsInterval();
    }

    synchronized void register(ProtocolMessageHandler handler) {
        for (String wsaAction : handler.getSuportedWsaActions()) {
            ProtocolMessageHandler oldHandler;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Registering ProtocolMessageHandler of class [ %s ] to process WS-A action [ %s ]", handler.getClass().getName(), wsaAction));
            }
            if ((oldHandler = this.mapOfRegisteredProtocolMessageHandlers.put(wsaAction, handler)) == null || !LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(LocalizationMessages.WSMC_0101_DUPLICATE_PROTOCOL_MESSAGE_HANDLER(wsaAction, oldHandler.getClass().getName(), handler.getClass().getName()));
        }
    }

    synchronized void scheduleMcRequest() {
        ++this.scheduledMcRequestCounter;
    }

    private void sendMcRequest() {
        Packet mcRequest = this.communicator.createRequestPacket((Object)new MakeConnectionElement(this.wsmcAnonymousAddress), this.configuration.getRuntimeVersion().protocolVersion.wsmcAction, true);
        McClientTube.setMcAnnonymousHeaders(mcRequest.getMessage().getHeaders(), this.configuration.getAddressingVersion(), this.wsmcAnnonymousReplyToHeader, this.wsmcAnnonymousFaultToHeader);
        this.isMcRequestPending.set(true);
        try {
            this.communicator.sendAsync(mcRequest, (Fiber.CompletionCallback)new WsMcResponseHandler(this.configuration, this, this.suspendedFiberStorage, this.mapOfRegisteredProtocolMessageHandlers));
        }
        finally {
            this.lastMcMessageTimestamp = System.currentTimeMillis();
            if (--this.scheduledMcRequestCounter < 0) {
                this.scheduledMcRequestCounter = 0;
            }
        }
    }

    synchronized void clearMcRequestPendingFlag() {
        this.isMcRequestPending.set(false);
    }
}

