/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.wss.provider.wsit.PacketMapMessageInfo;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import com.sun.xml.wss.provider.wsit.PipeHelper;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.xml.ws.WebServiceException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ServerSecurityPipe
extends AbstractFilterPipeImpl {
    protected static final Logger logger = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private final boolean isHttpBinding;
    private PipeHelper helper;

    public ServerSecurityPipe(Map<String, Object> props, Pipe next, boolean isHttpBinding) {
        super(next);
        props.put("SECURITY_PIPE", (Object)this);
        this.helper = new PipeHelper("SOAP", props, null);
        this.isHttpBinding = isHttpBinding;
    }

    protected ServerSecurityPipe(ServerSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.helper = that.helper;
        this.isHttpBinding = that.isHttpBinding;
    }

    public void preDestroy() {
        this.helper.disable();
        this.next.preDestroy();
    }

    public Pipe copy(PipeCloner cloner) {
        return new ServerSecurityPipe(this, cloner);
    }

    public Packet process(Packet request) {
        if (this.isHttpBinding) {
            return this.next.process(request);
        }
        Packet response = null;
        try {
            response = this.processRequest(request);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Failure in security pipe process", e);
            }
            response = this.helper.makeFaultResponse(response, e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet processRequest(Packet request) throws Exception {
        AuthStatus status = AuthStatus.SUCCESS;
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        Subject serverSubject = (Subject)request.invocationProperties.get("SERVER_SUBJECT");
        ServerAuthContext sAC = this.helper.getServerAuthContext(info, serverSubject);
        Subject clientSubject = this.getClientSubject(request);
        try {
            if (sAC != null) {
                status = sAC.validateRequest((MessageInfo)info, clientSubject, serverSubject);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0053_ERROR_VALIDATE_REQUEST(), e);
            WebServiceException wse = new WebServiceException("Cannot validate request for", (Throwable)e);
            status = AuthStatus.SEND_FAILURE;
            Packet packet = this.helper.getFaultResponse(info.getRequestPacket(), info.getResponsePacket(), wse);
            return packet;
        }
        finally {
            Packet validatedRequest = info.getRequestPacket();
        }
        Packet response = null;
        if (status == AuthStatus.SUCCESS) {
            Packet validatedRequest;
            boolean authorized = true;
            this.helper.authorize(validatedRequest);
            if (authorized) {
                if (System.getSecurityManager() == null) {
                    try {
                        response = this.next.process(validatedRequest);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0055_WS_ERROR_NEXT_PIPE(), e);
                        response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), e);
                    }
                } else {
                    try {
                        response = (Packet)Subject.doAsPrivileged(clientSubject, new PrivilegedExceptionAction(){

                            public Object run() {
                                return ServerSecurityPipe.this.next.process(validatedRequest);
                            }
                        }, null);
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        if (cause instanceof AuthException) {
                            logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0055_WS_ERROR_NEXT_PIPE(), cause);
                        }
                        response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), cause);
                    }
                }
            }
            if (response == null) {
                WebServiceException wse = new WebServiceException("Invocation of Service {0} returned null response packet");
                response = this.helper.getFaultResponse(validatedRequest, info.getResponsePacket(), wse);
                logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0056_NULL_RESPONSE(), wse);
            }
            if (sAC != null && response.getMessage() != null) {
                info.setResponsePacket(response);
                response = this.processResponse(info, sAC, serverSubject);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ws.status_validate_request", status);
            }
            response = info.getResponsePacket();
        }
        return response;
    }

    private Packet processResponse(PacketMessageInfo info, ServerAuthContext sAC, Subject serverSubject) {
        AuthStatus status;
        try {
            status = sAC.secureResponse((MessageInfo)info, serverSubject);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "ws.error_secure_response", e);
                }
            } else {
                logger.log(Level.SEVERE, LogStringsMessages.WSITPVD_0054_ERROR_SECURE_RESPONSE(), e);
            }
            return this.helper.makeFaultResponse(info.getResponsePacket(), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ws.status_secure_response", status);
        }
        return info.getResponsePacket();
    }

    private Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = this.helper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }
}

