/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.policy;

import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.api.tx.at.WsatNamespace;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.tx.at.policy.AtAlwaysCapability;
import com.sun.xml.ws.tx.at.policy.AtAssertion;
import com.sun.xml.ws.tx.at.policy.EjbTransactionType;
import com.sun.xml.ws.tx.at.policy.WsatAssertionBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

public final class AtPolicyCreator {
    private static final Map<WsatNamespace, Map<Transactional.TransactionFlowType, Map<EjbTransactionType, Collection<WsatAssertionBase>>>> SUPPORTED_COMBINATIONS = new EnumMap<WsatNamespace, Map<Transactional.TransactionFlowType, Map<EjbTransactionType, Collection<WsatAssertionBase>>>>(WsatNamespace.class);

    private static void registerCombination(WsatNamespace version, Transactional.TransactionFlowType flowType, EjbTransactionType ejbTat, WsatAssertionBase ... assertions) {
        if (assertions == null) {
            assertions = new WsatAssertionBase[]{};
        }
        SUPPORTED_COMBINATIONS.get(version).get(flowType).put(ejbTat, Arrays.asList(assertions));
    }

    public static Policy createPolicy(String policyId, WsatNamespace version, Transactional.TransactionFlowType wsatFlowType, EjbTransactionType ejbTat) {
        if (wsatFlowType == null || ejbTat == null) {
            return null;
        }
        Collection<WsatAssertionBase> assertions = SUPPORTED_COMBINATIONS.get(version).get(wsatFlowType).get((Object)ejbTat);
        if (assertions == null) {
            throw new IllegalArgumentException(String.format("Unsupported combinantion: WS-AT namespace: [ %s ], WS-AT flow type: [ %s ], EJB transaction attribute: [ %s ]", new Object[]{version, wsatFlowType, ejbTat}));
        }
        if (assertions.isEmpty()) {
            return null;
        }
        ArrayList<AssertionSet> assertionSets = new ArrayList<AssertionSet>(1);
        assertionSets.add(AssertionSet.createAssertionSet(assertions));
        return Policy.createPolicy((String)"", (String)policyId, assertionSets);
    }

    static {
        for (WsatNamespace ns : WsatNamespace.values()) {
            EnumMap nsMap = new EnumMap(Transactional.TransactionFlowType.class);
            for (Transactional.TransactionFlowType flowType : Transactional.TransactionFlowType.values()) {
                nsMap.put(flowType, new EnumMap(EjbTransactionType.class));
            }
            SUPPORTED_COMBINATIONS.put(ns, nsMap);
        }
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.MANDATORY, EjbTransactionType.NOT_DEFINED, new AtAssertion(WsatNamespace.WSAT200410, false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.MANDATORY, EjbTransactionType.MANDATORY, new AtAssertion(WsatNamespace.WSAT200410, false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.MANDATORY, EjbTransactionType.REQUIRED, new AtAssertion(WsatNamespace.WSAT200410, false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.SUPPORTS, EjbTransactionType.NOT_DEFINED, new AtAssertion(WsatNamespace.WSAT200410, true));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.SUPPORTS, EjbTransactionType.SUPPORTS, new AtAssertion(WsatNamespace.WSAT200410, true));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.SUPPORTS, EjbTransactionType.REQUIRED, new AtAssertion(WsatNamespace.WSAT200410, true), new AtAlwaysCapability(false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.NEVER, EjbTransactionType.NOT_DEFINED, new WsatAssertionBase[0]);
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.NEVER, EjbTransactionType.NEVER, new WsatAssertionBase[0]);
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.NEVER, EjbTransactionType.REQUIRES_NEW, new AtAlwaysCapability(false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200410, Transactional.TransactionFlowType.NEVER, EjbTransactionType.REQUIRED, new AtAlwaysCapability(false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.MANDATORY, EjbTransactionType.NOT_DEFINED, new AtAssertion(WsatNamespace.WSAT200606, false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.MANDATORY, EjbTransactionType.MANDATORY, new AtAssertion(WsatNamespace.WSAT200606, false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.MANDATORY, EjbTransactionType.REQUIRED, new AtAssertion(WsatNamespace.WSAT200606, false));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.SUPPORTS, EjbTransactionType.NOT_DEFINED, new AtAssertion(WsatNamespace.WSAT200606, true));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.SUPPORTS, EjbTransactionType.SUPPORTS, new AtAssertion(WsatNamespace.WSAT200606, true));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.SUPPORTS, EjbTransactionType.REQUIRED, new AtAssertion(WsatNamespace.WSAT200606, true));
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.NEVER, EjbTransactionType.NOT_DEFINED, new WsatAssertionBase[0]);
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.NEVER, EjbTransactionType.NEVER, new WsatAssertionBase[0]);
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.NEVER, EjbTransactionType.REQUIRES_NEW, new WsatAssertionBase[0]);
        AtPolicyCreator.registerCombination(WsatNamespace.WSAT200606, Transactional.TransactionFlowType.NEVER, EjbTransactionType.NOT_SUPPORTED, new WsatAssertionBase[0]);
    }
}

