/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policy.AlgorithmSuite;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.LogStringsMessages;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.impl.policy.Trust13;
import com.sun.xml.ws.security.impl.policyconv.AsymmetricBindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.BindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.EncryptionAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.NilBindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.RequiredElementsProcessor;
import com.sun.xml.ws.security.impl.policyconv.SymmetricBindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.TransportBindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyContainer;
import com.sun.xml.ws.security.policy.AsymmetricBinding;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.EncryptedElements;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.EncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.EndorsingEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.EndorsingSupportingTokens;
import com.sun.xml.ws.security.policy.RequiredElements;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.SignedEndorsingEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.SignedEndorsingSupportingTokens;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.ws.security.policy.SignedSupportingTokens;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.TransportBinding;
import com.sun.xml.ws.security.policy.WSSAssertion;
import com.sun.xml.wss.impl.MessageLayout;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class XWSSPolicyGenerator {
    String _protectionOrder = "";
    SignaturePolicy _primarySP = null;
    EncryptionPolicy _primaryEP = null;
    EncryptionPolicy _sEncPolicy = null;
    SignaturePolicy _csSP = null;
    XWSSPolicyContainer _policyContainer = null;
    Binding _binding;
    Policy effectivePolicy = null;
    boolean isServer = false;
    boolean isIncoming = false;
    private PolicyAssertion wssAssertion = null;
    private WSSAssertion wss11 = null;
    private Trust10 trust10 = null;
    private Trust13 trust13 = null;
    private boolean encryptBody = false;
    private Vector<SignedParts> signedParts = new Vector();
    private Vector<EncryptedParts> encryptedParts = new Vector();
    private Vector<SignedElements> signedElements = new Vector();
    private Vector<EncryptedElements> encryptedElements = new Vector();
    private boolean ignoreST = false;
    private boolean transportBinding = false;
    private IntegrityAssertionProcessor iAP = null;
    private EncryptionAssertionProcessor eAP = null;
    private Binding policyBinding = null;
    private List<RequiredElements> reqElements = new ArrayList<RequiredElements>();
    private SecurityPolicyVersion spVersion;
    private boolean isIssuedTokenAsEncryptedSupportingToken = false;

    public XWSSPolicyGenerator(Policy effectivePolicy, boolean isServer, boolean isIncoming, SecurityPolicyVersion spVersion) {
        this.effectivePolicy = effectivePolicy;
        this._policyContainer = new XWSSPolicyContainer(isServer, isIncoming);
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.spVersion = spVersion;
    }

    public XWSSPolicyGenerator(Policy effectivePolicy, boolean isServer, boolean isIncoming) {
        this.effectivePolicy = effectivePolicy;
        this._policyContainer = new XWSSPolicyContainer(isServer, isIncoming);
        this.isServer = isServer;
        this.isIncoming = isIncoming;
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public com.sun.xml.ws.security.policy.AlgorithmSuite getBindingLevelAlgSuite() {
        if (this._binding != null) {
            return this._binding.getAlgorithmSuite();
        }
        return new AlgorithmSuite();
    }

    public void process(boolean ignoreST) throws PolicyException {
        this.ignoreST = ignoreST;
        this.process();
    }

    public void process() throws PolicyException {
        this.collectPolicies();
        PolicyAssertion binding = (PolicyAssertion)this.getBinding();
        this.policyBinding = (Binding)binding;
        if (binding == null) {
            NilBindingProcessor nbp = new NilBindingProcessor(this.isServer, this.isIncoming, this._policyContainer);
            nbp.process();
            this.processNonBindingAssertions(nbp);
            return;
        }
        if (PolicyUtil.isTransportBinding(binding, this.spVersion)) {
            if (Constants.logger.isLoggable(Level.FINE)) {
                Constants.logger.log(Level.FINE, "TransportBinding was configured in the policy");
            }
            TransportBindingProcessor tbp = new TransportBindingProcessor((TransportBinding)binding, this.isServer, this.isIncoming, this._policyContainer);
            tbp.process();
            this.processNonBindingAssertions(tbp);
            this.transportBinding = true;
        } else {
            this.iAP = new IntegrityAssertionProcessor(this._binding.getAlgorithmSuite(), this._binding.isSignContent());
            this.eAP = new EncryptionAssertionProcessor(this._binding.getAlgorithmSuite(), false);
            this._policyContainer.setPolicyContainerMode(this._binding.getLayout());
            if (PolicyUtil.isSymmetricBinding(binding.getName(), this.spVersion)) {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "SymmetricBinding was configured in the policy");
                }
                SymmetricBindingProcessor sbp = new SymmetricBindingProcessor((SymmetricBinding)this._binding, this._policyContainer, this.isServer, this.isIncoming, this.signedParts, this.encryptedParts, this.signedElements, this.encryptedElements);
                if (this.wssAssertion != null && PolicyUtil.isWSS11(this.wssAssertion, this.spVersion)) {
                    sbp.setWSS11((WSSAssertion)this.wssAssertion);
                }
                sbp.process();
                this.processNonBindingAssertions(sbp);
                sbp.close();
            } else if (PolicyUtil.isAsymmetricBinding(binding.getName(), this.spVersion)) {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "AsymmetricBinding was configured in the policy");
                }
                AsymmetricBindingProcessor abp = new AsymmetricBindingProcessor((AsymmetricBinding)this._binding, this._policyContainer, this.isServer, this.isIncoming, this.signedParts, this.encryptedParts, this.signedElements, this.encryptedElements);
                if (this.wssAssertion != null && PolicyUtil.isWSS11(this.wssAssertion, this.spVersion)) {
                    abp.setWSS11((WSSAssertion)this.wssAssertion);
                }
                abp.process();
                this.processNonBindingAssertions(abp);
                abp.close();
            }
        }
    }

    public MessagePolicy getXWSSPolicy() throws PolicyException {
        MessagePolicy mp = null;
        try {
            mp = this.wssAssertion != null ? this._policyContainer.getMessagePolicy(PolicyUtil.isWSS11(this.wssAssertion, this.spVersion)) : this._policyContainer.getMessagePolicy(false);
        }
        catch (PolicyGenerationException ex) {
            Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0113_UNABLE_TO_DIGEST_POLICY(this.effectivePolicy), ex);
            throw new PolicyException("Unable to digest SecurityPolicy ");
        }
        if (this.wssAssertion != null) {
            try {
                mp.setWSSAssertion(this.getWssAssertion((WSSAssertion)this.wssAssertion));
            }
            catch (PolicyGenerationException ex) {
                Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0104_ERROR_SIGNATURE_CONFIRMATION_ELEMENT(ex.getMessage()), ex);
                throw new PolicyException(LogStringsMessages.SP_0104_ERROR_SIGNATURE_CONFIRMATION_ELEMENT(ex.getMessage()));
            }
        }
        if (this.policyBinding != null && this.policyBinding.getAlgorithmSuite() != null) {
            mp.setAlgorithmSuite(this.getAlgoSuite(this.policyBinding.getAlgorithmSuite()));
        }
        if (this.policyBinding != null && this.policyBinding.getLayout() != null) {
            mp.setLayout(this.getLayout(this.policyBinding.getLayout()));
        }
        if (this.isIncoming && this.reqElements.size() > 0) {
            try {
                RequiredElementsProcessor rep = new RequiredElementsProcessor(this.reqElements, mp);
                rep.process();
            }
            catch (PolicyGenerationException ex) {
                Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0103_ERROR_REQUIRED_ELEMENTS(ex.getMessage()), ex);
                throw new PolicyException(LogStringsMessages.SP_0103_ERROR_REQUIRED_ELEMENTS(ex.getMessage()));
            }
        }
        if (this.transportBinding) {
            mp.setSSL(this.transportBinding);
        }
        return mp;
    }

    private void processNonBindingAssertions(BindingProcessor bindingProcessor) throws PolicyException {
        for (AssertionSet assertionSet : this.effectivePolicy) {
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isBinding(assertion, this.spVersion)) continue;
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((SupportingTokens)assertion);
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isSignedSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((SignedSupportingTokens)assertion);
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isEndorsedSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((EndorsingSupportingTokens)assertion);
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isSignedEndorsingSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((SignedEndorsingSupportingTokens)assertion);
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isSignedEncryptedSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((SignedEncryptedSupportingTokens)assertion);
                    this.isIssuedTokenAsEncryptedSupportingToken(bindingProcessor.isIssuedTokenAsEncryptedSupportingToken());
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isEncryptedSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((EncryptedSupportingTokens)assertion);
                    this.isIssuedTokenAsEncryptedSupportingToken(bindingProcessor.isIssuedTokenAsEncryptedSupportingToken());
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isEndorsingEncryptedSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((EndorsingEncryptedSupportingTokens)assertion);
                    this.isIssuedTokenAsEncryptedSupportingToken(bindingProcessor.isIssuedTokenAsEncryptedSupportingToken());
                    continue;
                }
                if (!this.ignoreST && this.shouldAddST() && PolicyUtil.isSignedEndorsingEncryptedSupportingToken(assertion, this.spVersion)) {
                    bindingProcessor.processSupportingTokens((SignedEndorsingEncryptedSupportingTokens)assertion);
                    this.isIssuedTokenAsEncryptedSupportingToken(bindingProcessor.isIssuedTokenAsEncryptedSupportingToken());
                    continue;
                }
                if (PolicyUtil.isWSS10(assertion, this.spVersion)) {
                    this.wssAssertion = assertion;
                    continue;
                }
                if (PolicyUtil.isWSS11(assertion, this.spVersion)) {
                    this.wssAssertion = assertion;
                    continue;
                }
                if (PolicyUtil.isTrust10(assertion, this.spVersion)) {
                    this.trust10 = (Trust10)assertion;
                    continue;
                }
                if (!PolicyUtil.isTrust13(assertion, this.spVersion)) continue;
                this.trust13 = (Trust13)assertion;
            }
        }
    }

    private Binding getBinding() {
        return this._binding;
    }

    private void collectPolicies() {
        for (AssertionSet assertionSet : this.effectivePolicy) {
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isSignedParts(assertion, this.spVersion)) {
                    this.signedParts.add((SignedParts)assertion);
                    continue;
                }
                if (PolicyUtil.isEncryptParts(assertion, this.spVersion)) {
                    this.encryptedParts.add((EncryptedParts)assertion);
                    continue;
                }
                if (PolicyUtil.isSignedElements(assertion, this.spVersion)) {
                    this.signedElements.add((SignedElements)assertion);
                    continue;
                }
                if (PolicyUtil.isEncryptedElements(assertion, this.spVersion)) {
                    this.encryptedElements.add((EncryptedElements)assertion);
                    continue;
                }
                if (PolicyUtil.isWSS10(assertion, this.spVersion)) {
                    this.wssAssertion = assertion;
                    continue;
                }
                if (PolicyUtil.isWSS11(assertion, this.spVersion)) {
                    this.wssAssertion = assertion;
                    continue;
                }
                if (PolicyUtil.isTrust10(assertion, this.spVersion)) {
                    this.trust10 = (Trust10)assertion;
                    continue;
                }
                if (PolicyUtil.isTrust13(assertion, this.spVersion)) {
                    this.trust13 = (Trust13)assertion;
                    continue;
                }
                if (PolicyUtil.isBinding(assertion, this.spVersion)) {
                    this._binding = (Binding)assertion;
                    continue;
                }
                if (!PolicyUtil.isRequiredElements(assertion, this.spVersion)) continue;
                this.reqElements.add((RequiredElements)assertion);
            }
        }
    }

    private boolean shouldAddST() {
        if (this.isServer && !this.isIncoming) {
            return false;
        }
        return this.isServer || !this.isIncoming;
    }

    protected com.sun.xml.wss.impl.AlgorithmSuite getAlgoSuite(com.sun.xml.ws.security.policy.AlgorithmSuite suite) {
        com.sun.xml.wss.impl.AlgorithmSuite als = new com.sun.xml.wss.impl.AlgorithmSuite(suite.getDigestAlgorithm(), suite.getEncryptionAlgorithm(), suite.getSymmetricKeyAlgorithm(), suite.getAsymmetricKeyAlgorithm());
        als.setSignatureAlgorithm(suite.getSignatureAlgorithm());
        return als;
    }

    protected com.sun.xml.wss.impl.WSSAssertion getWssAssertion(WSSAssertion asser) {
        return new com.sun.xml.wss.impl.WSSAssertion(asser.getRequiredProperties(), asser.getType());
    }

    protected MessageLayout getLayout(com.sun.xml.ws.security.policy.MessageLayout layout) {
        switch (layout) {
            case Strict: {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "MessageLayout has been configured to be  STRICT ");
                }
                return MessageLayout.Strict;
            }
            case Lax: {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "MessageLayout has been configured to be LAX ");
                }
                return MessageLayout.Lax;
            }
            case LaxTsFirst: {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "MessageLayout has been configured to be LaxTimestampFirst ");
                }
                return MessageLayout.LaxTsFirst;
            }
            case LaxTsLast: {
                if (Constants.logger.isLoggable(Level.FINE)) {
                    Constants.logger.log(Level.FINE, "MessageLayout has been configured tp be LaxTimestampLast ");
                }
                return MessageLayout.LaxTsLast;
            }
        }
        if (Constants.logger.isLoggable(Level.SEVERE)) {
            Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0106_UNKNOWN_MESSAGE_LAYOUT((Object)layout));
        }
        throw new RuntimeException(LogStringsMessages.SP_0106_UNKNOWN_MESSAGE_LAYOUT((Object)layout));
    }

    public boolean isIssuedTokenAsEncryptedSupportingToken() {
        return this.isIssuedTokenAsEncryptedSupportingToken;
    }

    private void isIssuedTokenAsEncryptedSupportingToken(boolean value) {
        this.isIssuedTokenAsEncryptedSupportingToken = value;
    }
}

