/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContextManager;
import jakarta.transaction.Transaction;
import jakarta.xml.ws.EndpointReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ForeignRecoveryContext
implements Externalizable {
    private static final long serialVersionUID = -3257083889097518770L;
    private static int klassVersion = 1032;
    private Xid fxid;
    private Transactional.Version version;
    private EndpointReference epr;
    private String txLogLocation;
    private boolean recovered;
    private static transient Logger LOGGER = Logger.getLogger(ForeignRecoveryContext.class);

    public ForeignRecoveryContext() {
    }

    ForeignRecoveryContext(Xid xid) {
        this.fxid = xid;
    }

    public void setEndpointReference(EndpointReference epr, Transactional.Version version) {
        this.epr = epr;
        this.version = version;
    }

    public Xid getXid() {
        return this.fxid;
    }

    public EndpointReference getEndpointReference() {
        return this.epr;
    }

    Transactional.Version getVersion() {
        return this.version;
    }

    Transaction getTransaction() {
        if (this.fxid == null) {
            throw new AssertionError((Object)("No Tid to Xid mapping for " + this));
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        klassVersion = in.readInt();
        this.fxid = (Xid)in.readObject();
        this.debug("ForeignRecoveryContext.readExternal tid:" + this.fxid);
        this.version = (Transactional.Version)in.readObject();
        int len = in.readInt();
        byte[] eprBytes = new byte[len];
        in.readFully(eprBytes);
        this.epr = EndpointReference.readFrom((Source)new StreamSource(new ByteArrayInputStream(eprBytes)));
        this.debug("ForeignRecoveryContext.readExternal EndpointReference:" + this.epr);
        ForeignRecoveryContextManager.getInstance().add(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(klassVersion);
        out.writeObject(this.fxid);
        out.writeObject(this.version);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.epr.writeTo((Result)new StreamResult(bos));
        byte[] eprBytes = bos.toByteArray();
        out.writeInt(eprBytes.length);
        out.write(eprBytes);
    }

    public String toString() {
        return "ForeignRecoveryContext[tid=" + this.fxid + ", endPointreference=" + this.epr + ", version = " + this.version + "]";
    }

    private void debug(String msg) {
        LOGGER.info(msg);
    }

    public void setTxLogLocation(String logLocation) {
        this.txLogLocation = logLocation;
    }

    public String getTxLogLocation() {
        return this.txLogLocation;
    }

    public void setRecovered() {
        this.recovered = true;
    }

    public boolean isRecovered() {
        return this.recovered;
    }
}

