/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.api.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.DerivedKeyTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.IssuedTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.KerberosTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.KeyValueTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SCTBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SamlTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SymmetricTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.UsernameTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.X509TokenBuilder;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.AlgorithmSuite;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.security.Key;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TokenProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    private Key signingKey = null;
    private TokenBuilder builder = null;
    private WSSPolicy keyBinding = null;
    private JAXBFilterProcessingContext context = null;

    public TokenProcessor(SignaturePolicy sp, JAXBFilterProcessingContext context) {
        this.context = context;
        this.keyBinding = (WSSPolicy)sp.getKeyBinding();
    }

    public BuilderResult process() throws XWSSecurityException {
        String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        AlgorithmSuite algSuite = this.context.getAlgorithmSuite();
        String tmp = null;
        if (algSuite != null) {
            tmp = algSuite.getAsymmetricKeyAlgorithm();
        }
        if (tmp != null && !"".equals(tmp)) {
            keyEncAlgo = tmp;
        }
        if (algSuite != null) {
            tmp = algSuite.getEncryptionAlgorithm();
        }
        if (tmp != null && !"".equals(tmp)) {
            dataEncAlgo = tmp;
        }
        if (PolicyTypeUtil.usernameTokenBinding(this.keyBinding)) {
            AuthenticationTokenPolicy.UsernameTokenBinding usernameTokenBinding = null;
            if (this.context.getusernameTokenBinding() != null) {
                usernameTokenBinding = this.context.getusernameTokenBinding();
                this.context.setUsernameTokenBinding(null);
            } else {
                usernameTokenBinding = (AuthenticationTokenPolicy.UsernameTokenBinding)this.keyBinding;
            }
            this.signingKey = usernameTokenBinding.getSecretKey();
            this.builder = new UsernameTokenBuilder(this.context, usernameTokenBinding);
            BuilderResult untResult = this.builder.process();
            untResult.setDataProtectionKey(this.signingKey);
            return untResult;
        }
        if (PolicyTypeUtil.x509CertificateBinding(this.keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = null;
            if (this.context.getX509CertificateBinding() != null) {
                certificateBinding = this.context.getX509CertificateBinding();
                this.context.setX509CertificateBinding(null);
            } else {
                certificateBinding = (AuthenticationTokenPolicy.X509CertificateBinding)this.keyBinding;
            }
            PrivateKeyBinding privKBinding = (PrivateKeyBinding)certificateBinding.getKeyBinding();
            this.signingKey = privKBinding.getPrivateKey();
            this.builder = new X509TokenBuilder(this.context, certificateBinding);
            BuilderResult xtbResult = this.builder.process();
            xtbResult.setDataProtectionKey(this.signingKey);
            return xtbResult;
        }
        if (PolicyTypeUtil.kerberosTokenBinding(this.keyBinding)) {
            AuthenticationTokenPolicy.KerberosTokenBinding krbBinding = null;
            if (this.context.getKerberosTokenBinding() != null) {
                krbBinding = this.context.getKerberosTokenBinding();
                this.context.setKerberosTokenBinding(null);
            } else {
                krbBinding = (AuthenticationTokenPolicy.KerberosTokenBinding)this.keyBinding;
            }
            this.signingKey = krbBinding.getSecretKey();
            this.builder = new KerberosTokenBuilder(this.context, krbBinding);
            BuilderResult ktbResult = this.builder.process();
            ktbResult.setDataProtectionKey(this.signingKey);
            return ktbResult;
        }
        if (PolicyTypeUtil.symmetricKeyBinding(this.keyBinding)) {
            SymmetricKeyBinding skb = null;
            if (this.context.getSymmetricKeyBinding() != null) {
                skb = this.context.getSymmetricKeyBinding();
                this.context.setSymmetricKeyBinding(null);
            } else {
                skb = (SymmetricKeyBinding)this.keyBinding;
            }
            this.builder = new SymmetricTokenBuilder(skb, this.context, dataEncAlgo, keyEncAlgo);
            return this.builder.process();
        }
        if (PolicyTypeUtil.derivedTokenKeyBinding(this.keyBinding)) {
            DerivedTokenKeyBinding dtk = (DerivedTokenKeyBinding)this.keyBinding;
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSCNS();
            this.builder = new DerivedKeyTokenBuilder(this.context, dtk);
            return this.builder.process();
        }
        if (PolicyTypeUtil.issuedTokenKeyBinding(this.keyBinding)) {
            IssuedTokenBuilder itb = new IssuedTokenBuilder(this.context, (IssuedTokenKeyBinding)this.keyBinding);
            return itb.process();
        }
        if (PolicyTypeUtil.secureConversationTokenKeyBinding(this.keyBinding)) {
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSCNS();
            SCTBuilder sctBuilder = new SCTBuilder(this.context, (SecureConversationTokenKeyBinding)this.keyBinding);
            return sctBuilder.process();
        }
        if (PolicyTypeUtil.samlTokenPolicy(this.keyBinding)) {
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSAMLNS();
            SamlTokenBuilder stb = new SamlTokenBuilder(this.context, (AuthenticationTokenPolicy.SAMLAssertionBinding)this.keyBinding, true);
            return stb.process();
        }
        if (PolicyTypeUtil.keyValueTokenBinding(this.keyBinding)) {
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSAMLNS();
            KeyValueTokenBuilder sctBuilder = new KeyValueTokenBuilder(this.context, (AuthenticationTokenPolicy.KeyValueTokenBinding)this.keyBinding);
            return sctBuilder.process();
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1703_UNSUPPORTED_KEYBINDING_SIGNATUREPOLICY(this.keyBinding));
        throw new UnsupportedOperationException("Unsupported Key Binding" + this.keyBinding);
    }
}

