/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust;

import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.ws.api.security.trust.STSAuthorizationProvider;
import com.sun.xml.ws.api.security.trust.STSTokenProvider;
import com.sun.xml.ws.api.security.trust.WSTrustContract;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.STSConfigurationProvider;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustClientContract;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.impl.DefaultSAMLTokenProvider;
import com.sun.xml.ws.security.trust.impl.DefaultSTSAttributeProvider;
import com.sun.xml.ws.security.trust.impl.DefaultSTSAuthorizationProvider;
import com.sun.xml.ws.security.trust.impl.TrustPluginImpl;
import com.sun.xml.ws.security.trust.impl.WSTrustClientContractImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSTrustFactory {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    public static TrustPlugin newTrustPlugin() {
        return new TrustPluginImpl();
    }

    public static WSTrustContract<BaseSTSRequest, BaseSTSResponse> newWSTrustContract(STSConfiguration config, String appliesTo) throws WSTrustException {
        String type = config.getType();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1002_PROVIDER_TYPE(type));
        }
        WSTrustContract contract = null;
        try {
            Class<?> clazz = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            clazz = loader == null ? Class.forName(type) : loader.loadClass(type);
            if (clazz != null) {
                Class<?> typedClass = clazz;
                contract = (WSTrustContract)typedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                contract.init(config);
            }
        }
        catch (ClassNotFoundException ex) {
            contract = null;
            log.log(Level.SEVERE, LogStringsMessages.WST_0005_CLASSNOTFOUND_NULL_CONTRACT(type), ex);
            throw new WSTrustException(LogStringsMessages.WST_0005_CLASSNOTFOUND_NULL_CONTRACT(type), ex);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0038_INIT_CONTRACT_FAIL(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0038_INIT_CONTRACT_FAIL(), ex);
        }
        return contract;
    }

    public static WSTrustClientContract createWSTrustClientContract() {
        return new WSTrustClientContractImpl();
    }

    public static STSAuthorizationProvider getSTSAuthorizationProvider() {
        STSAuthorizationProvider authzProvider = null;
        ServiceFinder finder = ServiceFinder.find(STSAuthorizationProvider.class);
        Iterator it = finder.iterator();
        authzProvider = it.hasNext() ? (STSAuthorizationProvider)it.next() : new DefaultSTSAuthorizationProvider();
        return authzProvider;
    }

    public static STSAttributeProvider getSTSAttributeProvider() {
        STSAttributeProvider attrProvider = null;
        ServiceFinder finder = ServiceFinder.find(STSAttributeProvider.class);
        Iterator it = finder.iterator();
        attrProvider = it.hasNext() ? (STSAttributeProvider)it.next() : new DefaultSTSAttributeProvider();
        return attrProvider;
    }

    public static STSTokenProvider getSTSTokenProvider() {
        STSTokenProvider tokenProvider = null;
        ServiceFinder finder = ServiceFinder.find(STSTokenProvider.class);
        Iterator it = finder.iterator();
        tokenProvider = it.hasNext() ? (STSTokenProvider)it.next() : new DefaultSAMLTokenProvider();
        return tokenProvider;
    }

    public static STSConfiguration getRuntimeSTSConfiguration() {
        STSConfigurationProvider configProvider = null;
        ServiceFinder finder = ServiceFinder.find(STSConfigurationProvider.class);
        Iterator it = finder.iterator();
        if (it.hasNext()) {
            configProvider = (STSConfigurationProvider)it.next();
        }
        if (configProvider != null) {
            return configProvider.getSTSConfiguration();
        }
        return null;
    }

    private WSTrustFactory() {
    }
}

