/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.resolver;

import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.dsig.NamespaceContextImpl;
import com.sun.xml.wss.impl.misc.URI;
import com.sun.xml.wss.impl.resolver.AttachmentSignatureInput;
import com.sun.xml.wss.logging.LogStringsMessages;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class URIResolver
extends ResourceResolverSpi {
    int referenceType = -1;
    private SOAPMessage soapMsg = null;
    private static String implementationClassName = URIResolver.class.getName();
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl", "com.sun.xml.wss.logging.LogStrings");
    private static final int ID_REFERENCE = 0;
    private static final int CID_REFERENCE = 1;
    private static final int CLOCATION_REFERENCE = 2;
    private final String[] errors = new String[]{"Can not resolve reference type", "Required SOAPMessage instance to resolve reference"};

    public URIResolver() {
    }

    public URIResolver(SOAPMessage soapMsg) {
        this.soapMsg = soapMsg;
    }

    public void setSOAPMessage(SOAPMessage soapMsg) {
        this.soapMsg = soapMsg;
    }

    public static String getResolverName() {
        return implementationClassName;
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        XMLSignatureInput result = null;
        if (this.referenceType == -1 && !this.engineCanResolve(uri, baseURI)) {
            throw this.generateException(uri, baseURI, this.errors[0]);
        }
        switch (this.referenceType) {
            case 0: {
                result = this._resolveId(uri, baseURI);
                break;
            }
            case 1: {
                result = this._resolveCid(uri, baseURI);
                break;
            }
            case 2: {
                try {
                    result = this._resolveClocation(uri, baseURI);
                }
                catch (URIResolverException ure) {
                    ResourceResolverContext resContext = new ResourceResolverContext(uri, baseURI, false);
                    result = ResourceResolver.resolve((ResourceResolverContext)resContext);
                }
                break;
            }
        }
        this.referenceType = -1;
        return result;
    }

    private XMLSignatureInput _resolveId(Attr uri, String baseUri) throws ResourceResolverException {
        XMLSignatureInput result = null;
        String uriNodeValue = uri.getNodeValue();
        Document doc = uri.getOwnerDocument();
        XMLUtils.circumventBug2650((Document)doc);
        Element selectedElem = null;
        if (uriNodeValue.equals("")) {
            selectedElem = doc.getDocumentElement();
        } else {
            String id = uriNodeValue.substring(1);
            selectedElem = this.getElementById(doc, id);
        }
        if (selectedElem == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0604_CANNOT_FIND_ELEMENT());
            throw new ResourceResolverException("empty", uri.getValue(), baseUri);
        }
        Set resultSet = this.prepareNodeSet(selectedElem);
        result = new XMLSignatureInput(resultSet);
        result.setMIMEType("text/xml");
        try {
            URI uriNew = new URI(new URI(baseUri), uriNodeValue);
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(baseUri);
        }
        return result;
    }

    private XMLSignatureInput _resolveCid(Attr uri, String baseUri) throws ResourceResolverException {
        AttachmentSignatureInput result = null;
        String uriNodeValue = uri.getNodeValue();
        if (this.soapMsg == null) {
            throw this.generateException(uri, baseUri, this.errors[1]);
        }
        try {
            AttachmentPart _part = ((SecurableSoapMessage)this.soapMsg).getAttachmentPart(uriNodeValue);
            if (_part == null) {
                throw new ResourceResolverException("empty", uri.getValue(), baseUri);
            }
            Object[] obj = AttachmentSignatureInput._getSignatureInput(_part);
            result = new AttachmentSignatureInput((byte[])obj[1]);
            result.setMimeHeaders((Vector)obj[0]);
            result.setContentType(_part.getContentType());
        }
        catch (Exception e) {
            throw new ResourceResolverException(e, uri.getValue(), baseUri, "empty");
        }
        try {
            URI uriNew = new URI(new URI(baseUri), uriNodeValue);
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(baseUri);
        }
        return result;
    }

    private XMLSignatureInput _resolveClocation(Attr uri, String baseUri) throws ResourceResolverException, URIResolverException {
        URI uriNew = null;
        AttachmentSignatureInput result = null;
        try {
            uriNew = this.getNewURI(uri.getNodeValue(), baseUri);
        }
        catch (URI.MalformedURIException ex) {
            throw new ResourceResolverException((Exception)ex, uri.getValue(), baseUri, "empty");
        }
        if (this.soapMsg == null) {
            throw this.generateException(uri, baseUri, this.errors[1]);
        }
        try {
            AttachmentPart _part = ((SecurableSoapMessage)this.soapMsg).getAttachmentPart(uriNew.toString());
            if (_part == null) {
                throw new URIResolverException();
            }
            Object[] obj = AttachmentSignatureInput._getSignatureInput(_part);
            result = new AttachmentSignatureInput((byte[])obj[1]);
            result.setMimeHeaders((Vector)obj[0]);
            result.setContentType(_part.getContentType());
        }
        catch (XWSSecurityException | SOAPException | IOException e) {
            throw new ResourceResolverException((Exception)e, uri.getValue(), baseUri, "empty");
        }
        result.setSourceURI(uriNew.toString());
        return result;
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.startsWith("#")) {
            this.referenceType = 0;
            return true;
        }
        if (uriNodeValue.startsWith("cid:")) {
            this.referenceType = 1;
            return true;
        }
        if (uriNodeValue.startsWith("attachmentRef:")) {
            this.referenceType = 1;
            return true;
        }
        URI uriNew = null;
        try {
            uriNew = this.getNewURI(uriNodeValue, baseURI);
        }
        catch (URI.MalformedURIException ex) {
            return false;
        }
        if (uriNew != null && uriNew.getScheme().equals("http") || uriNodeValue.startsWith("thismessage:/") || !uriNew.getScheme().equals("ftp") && !uriNew.getScheme().equals("telnet") && !uriNew.getScheme().equals("gopher") && !uriNew.getScheme().equals("news") && !uriNew.getScheme().equals("mailto") && !uriNew.getScheme().equals("file")) {
            this.referenceType = 2;
            return true;
        }
        return false;
    }

    private Element getElementById(Document doc, String id) {
        NodeList assertions;
        int len;
        XPathExpression xpathExpr;
        Element selement = doc.getElementById(id);
        if (selement != null) {
            return selement;
        }
        Element element = null;
        NodeList elems = null;
        String xpath = "//*[@wsu:Id='" + id + "']";
        XPathFactory xpathFactory = WSITXMLFactory.createXPathFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
        XPath xPATH = xpathFactory.newXPath();
        xPATH.setNamespaceContext(this.getNamespaceContext(doc));
        try {
            xpathExpr = xPATH.compile(xpath);
            elems = (NodeList)xpathExpr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            log.log(Level.SEVERE, "WSS0375.error.apache.xpathAPI", new Object[]{id, ex.getMessage()});
            throw new XWSSecurityRuntimeException(ex);
        }
        if (elems != null) {
            if (elems.getLength() > 1) {
                throw new XWSSecurityRuntimeException("XPath Query resulted in more than one node");
            }
            element = (Element)elems.item(0);
        }
        if (element == null) {
            xpath = "//*[@Id='" + id + "']";
            try {
                xpathExpr = xPATH.compile(xpath);
                elems = (NodeList)xpathExpr.evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0375_ERROR_APACHE_XPATH_API(id, ex.getMessage()), new Object[]{id, ex.getMessage()});
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        if (elems != null) {
            if (elems.getLength() > 1) {
                for (int i = 0; i < elems.getLength(); ++i) {
                    Element elem = (Element)elems.item(i);
                    String namespace = elem.getNamespaceURI();
                    if (!namespace.equals("http://www.w3.org/2000/09/xmldsig#") && !namespace.equals("http://www.w3.org/2001/04/xmlenc#")) continue;
                    element = elem;
                    break;
                }
            } else {
                element = (Element)elems.item(0);
            }
        }
        if (element == null && (len = (assertions = doc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")).getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                Element elem = (Element)assertions.item(i);
                String assertionId = elem.getAttribute("AssertionID");
                if (!id.equals(assertionId)) continue;
                element = elem;
                break;
            }
        }
        return element;
    }

    private ResourceResolverException generateException(Attr uri, String baseUri, String error) {
        XWSSecurityException xwssE = new XWSSecurityException(error);
        return new ResourceResolverException((Exception)xwssE, uri.getValue(), baseUri, "empty");
    }

    private Set prepareNodeSet(Node node) {
        HashSet nodeSet = new HashSet();
        if (node != null) {
            this.nodeSetMinusCommentNodes(node, nodeSet, null);
        }
        return nodeSet;
    }

    private void nodeSetMinusCommentNodes(Node node, Set nodeSet, Node prevSibling) {
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        nodeSet.add(attrs.item(i));
                    }
                }
                nodeSet.add(node);
                Node pSibling = null;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.nodeSetMinusCommentNodes(child, nodeSet, pSibling);
                    pSibling = child;
                }
                break;
            }
            case 3: 
            case 4: {
                if (prevSibling != null && (prevSibling.getNodeType() == 3 || prevSibling.getNodeType() == 4)) {
                    return;
                }
            }
            case 7: {
                nodeSet.add(node);
            }
        }
    }

    private URI getNewURI(String uri, String baseUri) throws URI.MalformedURIException {
        if (baseUri == null || "".equals(baseUri)) {
            return new URI(uri);
        }
        return new URI(new URI(baseUri), uri);
    }

    public NamespaceContext getNamespaceContext(Document doc) {
        NamespaceContextImpl nsContext = new NamespaceContextImpl();
        nsContext.add(doc.getDocumentElement().getPrefix(), doc.getDocumentElement().getNamespaceURI());
        if (doc.getDocumentElement().getNamespaceURI() == "http://www.w3.org/2003/05/soap-envelope") {
            nsContext.add("SOAP-ENV", "http://www.w3.org/2003/05/soap-envelope");
            nsContext.add("env", "http://www.w3.org/2003/05/soap-envelope");
        }
        nsContext.add("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        nsContext.add("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        return nsContext;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext rrc) throws ResourceResolverException {
        return this.engineResolve(rrc.attr, rrc.baseUri);
    }

    public boolean engineCanResolveURI(ResourceResolverContext rrc) {
        return this.engineCanResolve(rrc.attr, rrc.baseUri);
    }

    private static final class URIResolverException
    extends Exception {
        private static final long serialVersionUID = -509497777933987914L;

        private URIResolverException() {
        }
    }
}

