/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.ws.security.opt.impl.message.MessageWrapper;
import com.sun.xml.ws.security.opt.impl.message.SecuredMessage;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.wss.BasicSecurityProfile;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageLayout;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import jakarta.xml.soap.SOAPMessage;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class JAXBFilterProcessingContext
extends FilterProcessingContext {
    protected static final Logger logger = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private int uid = 5001;
    private boolean isBSP = false;
    private Message pvMsg = null;
    SecuredMessage securedMessage = null;
    SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    SecurityHeader secHeader = null;
    private SecurityContext securityContext = null;
    private Message message = null;
    private boolean isOneWay = false;
    private boolean isSAMLEK = false;
    private AddressingVersion addrVer = null;
    private org.jvnet.staxex.NamespaceContextEx nsc = null;
    private XMLStreamBuffer xmlBuffer = null;
    private boolean isSSL = false;
    private HashMap<String, Key> currentSecretMap = new HashMap();
    private boolean disablePayloadBuffering = false;
    private boolean disbaleIncPrefix = false;
    private boolean encHeaderContent = false;
    private boolean allowMissingTimestamp = false;
    private boolean mustUnderstandValue = true;
    private BasicSecurityProfile bspContext = null;
    private String edId = null;

    public JAXBFilterProcessingContext() {
        this.bspContext = new BasicSecurityProfile();
    }

    public JAXBFilterProcessingContext(ProcessingContext context) {
        this.bspContext = new BasicSecurityProfile();
    }

    public JAXBFilterProcessingContext(Map invocationProps) {
        this.properties = invocationProps;
        this.bspContext = new BasicSecurityProfile();
    }

    public JAXBFilterProcessingContext(String messageIdentifier, SecurityPolicy securityPolicy, Message message, SOAPVersion soapVersion) throws XWSSecurityException {
        this.setSecurityPolicy(securityPolicy);
        this.setMessageIdentifier(messageIdentifier);
        this.securedMessage = new SecuredMessage(message, this.getSecurityHeader(), soapVersion);
        this.soapVersion = soapVersion;
        this.securedMessage.setRootElements(this.getNamespaceContext());
        this.bspContext = new BasicSecurityProfile();
    }

    public SecuredMessage getSecuredMessage() {
        return this.securedMessage;
    }

    public void isOneWayMessage(boolean value) {
        this.isOneWay = value;
    }

    public void setEdIdforEh(String id) {
        this.edId = id;
    }

    public String getEdIdforEh() {
        return this.edId;
    }

    public void setJAXWSMessage(Message jaxWsMessage, SOAPVersion soapVersion) {
        QName secQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
        this.secHeader = (SecurityHeader)jaxWsMessage.getHeaders().get(secQName, false);
        this.securedMessage = new SecuredMessage(jaxWsMessage, this.getSecurityHeader(), soapVersion);
        this.soapVersion = soapVersion;
        this.securedMessage.setRootElements(this.getNamespaceContext());
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getJAXWSMessage() {
        if (this.message != null) {
            return this.message;
        }
        return new MessageWrapper(this.securedMessage, this.isOneWay);
    }

    public SOAPVersion getSOAPVersion() {
        return this.soapVersion;
    }

    public void setSOAPVersion(SOAPVersion sv) {
        this.soapVersion = sv;
    }

    public boolean isSOAP12() {
        return this.soapVersion == SOAPVersion.SOAP_12;
    }

    public SecurityHeader getSecurityHeader() {
        if (this.secHeader == null) {
            this.secHeader = new WSSElementFactory(this.soapVersion).createSecurityHeader(this.getLayout(), this.soapVersion.nsUri, this.mustUnderstandValue);
        }
        return this.secHeader;
    }

    @Override
    protected SecurableSoapMessage getSecureMessage() {
        return null;
    }

    @Override
    protected void setSecureMessage(SecurableSoapMessage msg) {
    }

    @Override
    public void setSOAPMessage(SOAPMessage message) {
    }

    @Override
    public SOAPMessage getSOAPMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(ProcessingContext ctxx1, ProcessingContext ctxx2) throws XWSSecurityException {
        if (ctxx2 instanceof JAXBFilterProcessingContext) {
            JAXBFilterProcessingContext ctx1 = (JAXBFilterProcessingContext)ctxx1;
            JAXBFilterProcessingContext ctx2 = (JAXBFilterProcessingContext)ctxx2;
            super.copy(ctx1, ctx2);
            ctx1.setJAXWSMessage(ctx2.getJAXWSMessage(), ctx2.soapVersion);
        } else {
            super.copy(ctxx1, ctxx2);
        }
    }

    public synchronized String generateID() {
        ++this.uid;
        return "_" + this.uid;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public org.jvnet.staxex.NamespaceContextEx getNamespaceContext() {
        if (this.nsc == null) {
            this.nsc = this.soapVersion == SOAPVersion.SOAP_11 ? new NamespaceContextEx(false) : new NamespaceContextEx(true);
            if (this.getWSSAssertion() != null) {
                if (this.getWSSAssertion().getType().equals("1.1")) {
                    ((NamespaceContextEx)this.nsc).addWSS11NS();
                    ((NamespaceContextEx)this.nsc).addWSSNS();
                } else {
                    ((NamespaceContextEx)this.nsc).addWSSNS();
                }
            } else {
                ((NamespaceContextEx)this.nsc).addWSSNS();
            }
            ((NamespaceContextEx)this.nsc).addXSDNS();
        }
        return this.nsc;
    }

    public boolean isSAMLEK() {
        return this.isSAMLEK;
    }

    public void isSAMLEK(boolean isSAMLEK) {
        this.isSAMLEK = isSAMLEK;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addrVer;
    }

    public void setAddressingVersion(AddressingVersion addrVer) {
        this.addrVer = addrVer;
    }

    public void setCurrentBuffer(XMLStreamBuffer buffer) {
        this.xmlBuffer = buffer;
    }

    public XMLStreamBuffer getCurrentBuffer() {
        return this.xmlBuffer;
    }

    public void setSecure(boolean value) {
        this.isSSL = value;
    }

    public boolean isSecure() {
        return this.isSSL;
    }

    public int getLayout() {
        MessagePolicy mp = (MessagePolicy)this.getSecurityPolicy();
        if (mp != null) {
            if (MessageLayout.Strict == mp.getLayout()) {
                return 1;
            }
            if (MessageLayout.Lax == mp.getLayout()) {
                return 0;
            }
            if (MessageLayout.LaxTsFirst == mp.getLayout()) {
                return 2;
            }
            if (MessageLayout.LaxTsLast == mp.getLayout()) {
                return 3;
            }
        }
        return 1;
    }

    public void addToCurrentSecretMap(String ekId, Key key) {
        this.currentSecretMap.put(ekId, key);
    }

    public Key getCurrentSecretFromMap(String ekId) {
        return this.currentSecretMap.get(ekId);
    }

    public boolean getDisablePayloadBuffering() {
        return this.disablePayloadBuffering;
    }

    public void setDisablePayloadBuffering(boolean value) {
        this.disablePayloadBuffering = value;
    }

    public boolean getDisableIncPrefix() {
        return this.disbaleIncPrefix;
    }

    public void setDisableIncPrefix(boolean disableIncPrefix) {
        this.disbaleIncPrefix = disableIncPrefix;
    }

    public boolean getEncHeaderContent() {
        return this.encHeaderContent;
    }

    public void setEncHeaderContent(boolean encHeaderContent) {
        this.encHeaderContent = encHeaderContent;
    }

    public void setBSP(boolean value) {
        this.isBSP = value;
    }

    public boolean isBSP() {
        return this.isBSP;
    }

    public BasicSecurityProfile getBSPContext() {
        return this.bspContext;
    }

    public Message getPVMessage() {
        return this.pvMsg;
    }

    public void setPVMessage(Message msg) {
        this.pvMsg = msg;
    }

    public boolean isMissingTimestampAllowed() {
        return this.allowMissingTimestamp;
    }

    public void setAllowMissingTimestamp(boolean allowMissingTimestamp) {
        this.allowMissingTimestamp = allowMissingTimestamp;
    }

    public boolean getMustUnderstandValue() {
        return this.mustUnderstandValue;
    }

    public void setMustUnderstandValue(boolean muValue) {
        this.mustUnderstandValue = muValue;
    }
}

