/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.policy.spi_impl;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.ws.policy.subject.WsdlBindingSubject;
import com.sun.xml.ws.rx.mc.api.MakeConnectionSupportedFeature;
import com.sun.xml.ws.rx.mc.policy.wsmc200702.MakeConnectionSupportedAssertion;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class McPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(McPolicyMapConfigurator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LinkedList<PolicySubject> subjects = new LinkedList<PolicySubject>();
        try {
            LOGGER.entering(new Object[]{policyMap, model, wsBinding});
            this.updateMakeConnectionSettings(subjects, wsBinding, model, policyMap);
            LinkedList<PolicySubject> linkedList = subjects;
            return linkedList;
        }
        finally {
            LOGGER.exiting(subjects);
        }
    }

    private Policy createMakeConnectionPolicy(QName bindingName) {
        return Policy.createPolicy(null, (String)(bindingName.getLocalPart() + "_MCSupported_Policy"), Arrays.asList(AssertionSet.createAssertionSet(Arrays.asList(new MakeConnectionSupportedAssertion()))));
    }

    private void updateMakeConnectionSettings(Collection<PolicySubject> subjects, WSBinding wsBinding, SEIModel model, PolicyMap policyMap) throws PolicyException, IllegalArgumentException {
        Policy existingPolicy;
        MakeConnectionSupportedFeature mcFeature = (MakeConnectionSupportedFeature)wsBinding.getFeature(MakeConnectionSupportedFeature.class);
        if (mcFeature == null || !mcFeature.isEnabled()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Make connection feature enabled on service '%s', port '%s'", model.getServiceQName(), model.getPortName()));
        }
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)model.getServiceQName(), (QName)model.getPortName());
        Policy policy = existingPolicy = policyMap != null ? policyMap.getEndpointEffectivePolicy(endpointKey) : null;
        if (existingPolicy == null || !existingPolicy.contains(MakeConnectionSupportedAssertion.NAME)) {
            Policy mcPolicy = this.createMakeConnectionPolicy(model.getBoundPortTypeName());
            WsdlBindingSubject wsdlSubject = WsdlBindingSubject.createBindingSubject((QName)model.getBoundPortTypeName());
            PolicySubject subject = new PolicySubject((Object)wsdlSubject, mcPolicy);
            subjects.add(subject);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Added make connection policy with ID '%s' to binding element '%s'", mcPolicy.getIdOrName(), model.getBoundPortTypeName()));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Make connection assertion is already present in the endpoint policy");
        }
    }
}

