/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ClientAuthModule;
import jakarta.xml.soap.SOAPMessage;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class WSITClientAuthModule
implements ClientAuthModule {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private Class[] supported = new Class[2];
    protected static final String DEBUG = "debug";
    private boolean debug = false;

    public WSITClientAuthModule() {
        this.supported[0] = SOAPMessage.class;
        this.supported[1] = Message.class;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) {
        String bg = (String)options.get(DEBUG);
        if (bg != null && bg.equals("true")) {
            this.debug = true;
        }
    }

    public Class[] getSupportedMessageTypes() {
        return this.supported;
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) {
        return AuthStatus.SUCCESS;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        if (subject == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0037_NULL_SUBJECT());
            throw new AuthException(LogStringsMessages.WSITPVD_0037_NULL_SUBJECT());
        }
        if (!subject.isReadOnly()) {
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        try {
            principals.clear();
        }
        catch (UnsupportedOperationException uoe) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), uoe);
        }
        Iterator<Object> pi = privateCredentials.iterator();
        while (pi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)pi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), dfe);
            }
            catch (ClassCastException cce) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), cce);
            }
        }
        Iterator<Object> qi = publicCredentials.iterator();
        while (qi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)qi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), dfe);
            }
            catch (ClassCastException cce) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), cce);
            }
        }
    }
}

