/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.addressing.policy.Address;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Issuer
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.Issuer,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private Address address;
    private Address metadataAddress;
    private boolean populated = false;
    private PolicyAssertion refProps = null;
    private PolicyAssertion refParams = null;
    private PolicyAssertion serviceName = null;
    private String portType = null;
    private Element identityEle = null;

    public Issuer() {
    }

    public Issuer(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void getAddressFromMetadata(PolicyAssertion addressingMetadata) {
        PolicyAssertion metadata = null;
        PolicyAssertion metadataSection = null;
        PolicyAssertion metadataReference = null;
        if (addressingMetadata != null) {
            PolicyAssertion assertion;
            Iterator iterator;
            if (addressingMetadata.hasParameters()) {
                iterator = addressingMetadata.getParametersIterator();
                while (iterator.hasNext()) {
                    assertion = (PolicyAssertion)iterator.next();
                    if (!PolicyUtil.isMetadata(assertion)) continue;
                    metadata = assertion;
                    break;
                }
            }
            if (metadata != null) {
                if (metadata.hasParameters()) {
                    iterator = metadata.getParametersIterator();
                    while (iterator.hasNext()) {
                        assertion = (PolicyAssertion)iterator.next();
                        if (!PolicyUtil.isMetadataSection(assertion)) continue;
                        metadataSection = assertion;
                        break;
                    }
                }
                if (metadataSection != null) {
                    if (metadataSection.hasParameters()) {
                        iterator = metadataSection.getParametersIterator();
                        while (iterator.hasNext()) {
                            assertion = (PolicyAssertion)iterator.next();
                            if (!PolicyUtil.isMetadataReference(assertion)) continue;
                            metadataReference = assertion;
                            break;
                        }
                    }
                    if (metadataReference != null && metadataReference.hasParameters()) {
                        iterator = metadataReference.getParametersIterator();
                        while (iterator.hasNext()) {
                            assertion = (PolicyAssertion)iterator.next();
                            if (!PolicyUtil.isAddress(assertion)) continue;
                            this.metadataAddress = (Address)assertion;
                            break;
                        }
                    }
                }
            }
        }
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            if (this.hasNestedAssertions()) {
                Iterator it = this.getNestedAssertionsIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = (PolicyAssertion)it.next();
                    if (PolicyUtil.isAddress(assertion)) {
                        this.address = (Address)assertion;
                        continue;
                    }
                    if (PolicyUtil.isPortType(assertion)) {
                        this.portType = assertion.getValue();
                        continue;
                    }
                    if (PolicyUtil.isReferenceParameters(assertion)) {
                        this.refParams = assertion;
                        continue;
                    }
                    if (PolicyUtil.isReferenceProperties(assertion)) {
                        this.refProps = assertion;
                        continue;
                    }
                    if (PolicyUtil.isServiceName(assertion)) {
                        this.serviceName = assertion;
                        continue;
                    }
                    if (PolicyUtil.isAddressingMetadata(assertion)) {
                        this.getAddressFromMetadata(assertion);
                        continue;
                    }
                    if (!"Identity".equals(assertion.getName().getLocalPart())) continue;
                    Document doc = PolicyUtil.policyAssertionToDoc(assertion);
                    this.identityEle = (Element)doc.getElementsByTagNameNS("*", "Identity").item(0);
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public Address getAddress() {
        this.populate();
        return this.address;
    }

    @Override
    public String getPortType() {
        this.populate();
        return this.portType;
    }

    @Override
    public PolicyAssertion getReferenceParameters() {
        this.populate();
        return this.refParams;
    }

    @Override
    public PolicyAssertion getReferenceProperties() {
        this.populate();
        return this.refProps;
    }

    @Override
    public PolicyAssertion getServiceName() {
        this.populate();
        return this.serviceName;
    }

    @Override
    public Element getIdentity() {
        this.populate();
        return this.identityEle;
    }

    @Override
    public Address getMetadataAddress() {
        this.populate();
        return this.metadataAddress;
    }
}

