/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.ws.api.security.trust.STSAuthorizationProvider;
import com.sun.xml.ws.api.security.trust.STSTokenProvider;
import com.sun.xml.ws.api.security.trust.Status;
import com.sun.xml.ws.api.security.trust.WSTrustContract;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.io.IOException;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSTrustContractImpl
implements WSTrustContract<BaseSTSRequest, BaseSTSResponse> {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    protected static final String SAML_SENDER_VOUCHES_1_0 = "urn:oasis:names:tc:SAML:1.0:cm::sender-vouches";
    protected static final String SAML_SENDER_VOUCHES_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    protected STSConfiguration stsConfig;
    protected WSTrustVersion wstVer;
    protected WSTrustElementFactory eleFac;
    private static final int DEFAULT_KEY_SIZE = 256;

    @Override
    public void init(STSConfiguration stsConfig) {
        this.stsConfig = stsConfig;
        this.wstVer = (WSTrustVersion)stsConfig.getOtherOptions().get("WSTrustVersion");
        this.eleFac = WSTrustElementFactory.newInstance(this.wstVer);
    }

    @Override
    public BaseSTSResponse issue(BaseSTSRequest request, IssuedTokenContext context) throws WSTrustException {
        STSAuthorizationProvider authzProvider;
        ActAs actAs;
        Claims claims;
        Subject subject;
        RequestSecurityToken rst = (RequestSecurityToken)request;
        SecondaryParameters secParas = null;
        context.getOtherProperties().put("wstVersion", this.wstVer);
        if (this.wstVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            secParas = rst.getSecondaryParameters();
        }
        AppliesTo applies = rst.getAppliesTo();
        String appliesTo = null;
        X509Certificate serCert = null;
        List<Object> at = null;
        if (applies != null) {
            at = WSTrustUtil.parseAppliesTo(applies);
            for (int i = 0; i < at.size(); ++i) {
                Object obj = at.get(i);
                if (obj instanceof String) {
                    appliesTo = (String)obj;
                    continue;
                }
                if (!(obj instanceof X509Certificate)) continue;
                serCert = (X509Certificate)obj;
            }
        }
        context.setAppliesTo(appliesTo);
        String issuer = this.stsConfig.getIssuer();
        context.setTokenIssuer(issuer);
        TrustSPMetadata spMd = this.stsConfig.getTrustSPMetadata(appliesTo);
        if (spMd == null) {
            spMd = this.stsConfig.getTrustSPMetadata("default");
        }
        if (spMd == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
        }
        if (serCert == null) {
            serCert = this.getServiceCertificate(spMd, appliesTo);
        }
        if (serCert != null) {
            context.getOtherProperties().put("tagetedServiceCertificate", serCert);
        }
        Object[] certAndKey = this.getSTSCertAndPrivateKey();
        context.getOtherProperties().put("stsCertificate", certAndKey[0]);
        context.getOtherProperties().put("stsPrivateKey", certAndKey[1]);
        String tokenType = null;
        URI tokenTypeURI = rst.getTokenType();
        if (tokenTypeURI == null && secParas != null) {
            tokenTypeURI = secParas.getTokenType();
        }
        if ((tokenType = tokenTypeURI != null ? tokenTypeURI.toString() : spMd.getTokenType()) == null) {
            tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
        }
        context.setTokenType(tokenType);
        String keyType = null;
        URI keyTypeURI = rst.getKeyType();
        if (keyTypeURI == null && secParas != null) {
            keyTypeURI = secParas.getKeyType();
        }
        if ((keyType = keyTypeURI != null ? keyTypeURI.toString() : spMd.getKeyType()) == null) {
            keyType = this.wstVer.getSymmetricKeyTypeURI();
        }
        context.setKeyType(keyType);
        String encryptionAlgorithm = null;
        URI encryptionAlgorithmURI = rst.getEncryptionAlgorithm();
        if (encryptionAlgorithmURI == null && secParas != null) {
            encryptionAlgorithmURI = secParas.getEncryptionAlgorithm();
        }
        if (encryptionAlgorithmURI != null) {
            encryptionAlgorithm = encryptionAlgorithmURI.toString();
        }
        context.setEncryptionAlgorithm(encryptionAlgorithm);
        String signatureAlgorithm = null;
        URI signatureAlgorithmURI = rst.getSignatureAlgorithm();
        if (signatureAlgorithmURI == null && secParas != null) {
            signatureAlgorithmURI = secParas.getSignatureAlgorithm();
        }
        if (signatureAlgorithmURI != null) {
            signatureAlgorithm = signatureAlgorithmURI.toString();
        }
        context.setSignatureAlgorithm(signatureAlgorithm);
        String canonicalizationAlgorithm = null;
        URI canonicalizationAlgorithmURI = rst.getCanonicalizationAlgorithm();
        if (canonicalizationAlgorithmURI == null && secParas != null) {
            canonicalizationAlgorithmURI = secParas.getCanonicalizationAlgorithm();
        }
        if (canonicalizationAlgorithmURI != null) {
            canonicalizationAlgorithm = canonicalizationAlgorithmURI.toString();
        }
        context.setCanonicalizationAlgorithm(canonicalizationAlgorithm);
        URI keyWrapAlgorithmURI = null;
        if (secParas != null) {
            keyWrapAlgorithmURI = secParas.getKeyWrapAlgorithm();
        }
        if (keyWrapAlgorithmURI != null) {
            context.getOtherProperties().put("keyWrapAlgorithm", keyWrapAlgorithmURI.toString());
        }
        if ((subject = context.getRequestorSubject()) == null) {
            AccessControlContext acc = AccessController.getContext();
            subject = Subject.getSubject(acc);
            context.setRequestorSubject(subject);
        }
        if (subject == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0030_REQUESTOR_NULL());
            throw new WSTrustException(LogStringsMessages.WST_0030_REQUESTOR_NULL());
        }
        String authnCtx = (String)this.stsConfig.getOtherOptions().get("AuthnContextClass");
        if (authnCtx != null) {
            context.getOtherProperties().put("authnContext", authnCtx);
        }
        if ((claims = rst.getClaims()) == null && secParas != null) {
            claims = secParas.getClaims();
        }
        if (claims != null) {
            List<Object> si = rst.getExtensionElements();
            claims.getSupportingProperties().addAll(si);
            if (at != null) {
                claims.getSupportingProperties().addAll(at);
            }
        } else {
            claims = this.eleFac.createClaims();
        }
        Object confirMethod = null;
        Element assertionInRST = (Element)this.stsConfig.getOtherOptions().get("SamlAssertionElementInRST");
        OnBehalfOf obo = rst.getOnBehalfOf();
        if (obo != null) {
            Object oboToken = obo.getAny();
            if (assertionInRST != null) {
                oboToken = assertionInRST;
            }
            if (oboToken != null) {
                subject.getPublicCredentials().add(this.eleFac.toElement(oboToken));
                claims.getOtherAttributes().put(new QName("OnBehalfOf"), "true");
                context.getOtherProperties().put("OnBehalfOf", "true");
                Subject oboSubj = new Subject();
                oboSubj.getPublicCredentials().add(this.eleFac.toElement(oboToken));
                claims.getSupportingProperties().add(oboSubj);
            }
        }
        if ((actAs = rst.getActAs()) != null) {
            Object actAsToken = actAs.getAny();
            if (assertionInRST != null) {
                actAsToken = assertionInRST;
            }
            if (actAsToken != null) {
                claims.getOtherAttributes().put(new QName("ActAs"), "true");
                context.getOtherProperties().put("ActAs", "true");
                Subject actAsSubj = new Subject();
                actAsSubj.getPublicCredentials().add(this.eleFac.toElement(actAsToken));
                claims.getSupportingProperties().add(actAsSubj);
            }
        }
        if (confirMethod != null) {
            context.getOtherProperties().put("samlConfirmationMethod", confirMethod);
        }
        if (!(authzProvider = WSTrustFactory.getSTSAuthorizationProvider()).isAuthorized(subject, appliesTo, tokenType, keyType)) {
            String user = subject.getPrincipals().iterator().next().getName();
            log.log(Level.SEVERE, LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
        }
        STSAttributeProvider attrProvider = WSTrustFactory.getSTSAttributeProvider();
        Map<QName, List<String>> claimedAttrs = attrProvider.getClaimedAttributes(subject, appliesTo, tokenType, claims);
        context.getOtherProperties().put("cliamedAttributes", claimedAttrs);
        RequestedProofToken proofToken = null;
        Entropy serverEntropy = null;
        int keySize = 0;
        if (this.wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            proofToken = this.eleFac.createRequestedProofToken();
            byte[] clientEntr = null;
            Entropy clientEntropy = rst.getEntropy();
            if (clientEntropy != null) {
                BinarySecret clientBS = clientEntropy.getBinarySecret();
                if (clientBS == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, LogStringsMessages.WST_1009_NULL_BINARY_SECRET());
                    }
                } else {
                    clientEntr = clientBS.getRawValue();
                }
            }
            if ((keySize = (int)rst.getKeySize()) < 1 && secParas != null) {
                keySize = (int)secParas.getKeySize();
            }
            if (keySize < 1) {
                keySize = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1010_KEY_SIZE(keySize, 256));
            }
            byte[] key = WSTrustUtil.generateRandomSecret(keySize / 8);
            BinarySecret serverBS = this.eleFac.createBinarySecret(key, this.wstVer.getNonceBinarySecretTypeURI());
            serverEntropy = this.eleFac.createEntropy(serverBS);
            try {
                if (clientEntr != null && clientEntr.length > 0) {
                    proofToken.setComputedKey(URI.create(this.wstVer.getCKPSHA1algorithmURI()));
                    proofToken.setProofTokenType("ComputedKey");
                    key = SecurityUtil.P_SHA1(clientEntr, key, keySize / 8);
                } else {
                    proofToken.setProofTokenType("BinarySecret");
                    proofToken.setBinarySecret(serverBS);
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0013_ERROR_SECRET_KEY(this.wstVer.getCKPSHA1algorithmURI(), keySize, appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0013_ERROR_SECRET_KEY(this.wstVer.getCKPSHA1algorithmURI(), keySize, appliesTo), ex);
            }
            context.setProofKey(key);
        } else if (this.wstVer.getPublicKeyTypeURI().equals(keyType)) {
            UseKey useKey = rst.getUseKey();
            if (useKey != null) {
                Element uk = this.eleFac.toElement(useKey.getToken().getTokenValue());
                context.getOtherProperties().put("ConfirmationKeyInfo", uk);
            }
            Set<Object> certs = subject.getPublicCredentials();
            boolean addedClientCert = false;
            for (Object o : certs) {
                if (!(o instanceof X509Certificate)) continue;
                X509Certificate clientCert = (X509Certificate)o;
                context.setRequestorCertificate(clientCert);
                addedClientCert = true;
            }
            if (!addedClientCert && useKey == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
        } else if (!this.wstVer.getBearerKeyTypeURI().equals(keyType)) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
        }
        Lifetime lifetime = rst.getLifetime();
        long currentTime = WSTrustUtil.getCurrentTimeWithOffset();
        long lifespan = -1L;
        if (lifetime == null) {
            lifespan = this.stsConfig.getIssuedTokenTimeout();
            lifetime = WSTrustUtil.createLifetime(currentTime, lifespan, this.wstVer);
        } else {
            lifespan = WSTrustUtil.getLifeSpan(lifetime);
        }
        context.setCreationTime(new Date(currentTime));
        context.setExpirationTime(new Date(currentTime + lifespan));
        STSTokenProvider tokenProvider = WSTrustFactory.getSTSTokenProvider();
        tokenProvider.generateToken(context);
        RequestedSecurityToken reqSecTok = this.eleFac.createRequestedSecurityToken();
        Token issuedToken = context.getSecurityToken();
        if (this.stsConfig.getEncryptIssuedToken() && serCert != null) {
            String keyWrapAlgo = (String)context.getOtherProperties().get("keyWrapAlgorithm");
            Element encTokenEle = this.encryptToken((Element)issuedToken.getTokenValue(), serCert, appliesTo, encryptionAlgorithm, keyWrapAlgo);
            issuedToken = new GenericToken(encTokenEle);
        }
        reqSecTok.setToken(issuedToken);
        SecurityTokenReference raSTR = (SecurityTokenReference)context.getAttachedSecurityTokenReference();
        SecurityTokenReference ruSTR = (SecurityTokenReference)context.getUnAttachedSecurityTokenReference();
        RequestedAttachedReference raRef = null;
        if (raSTR != null) {
            raRef = this.eleFac.createRequestedAttachedReference(raSTR);
        }
        RequestedUnattachedReference ruRef = null;
        if (ruSTR != null) {
            ruRef = this.eleFac.createRequestedUnattachedReference(ruSTR);
        }
        URI ctx = null;
        String rstCtx = rst.getContext();
        if (rstCtx != null) {
            ctx = URI.create(rstCtx);
        }
        RequestSecurityTokenResponse rstr = this.eleFac.createRSTRForIssue(URI.create(tokenType), ctx, reqSecTok, applies, raRef, ruRef, proofToken, serverEntropy, lifetime);
        if (keySize > 0) {
            rstr.setKeySize(keySize);
        }
        this.handleExtension(rst, rstr, context);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1006_CREATED_RST_ISSUE(WSTrustUtil.elemToString(rst, this.wstVer)));
            log.log(Level.FINE, LogStringsMessages.WST_1007_CREATED_RSTR_ISSUE(WSTrustUtil.elemToString(rstr, this.wstVer)));
        }
        if (this.wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
            ArrayList<RequestSecurityTokenResponse> list = new ArrayList<RequestSecurityTokenResponse>();
            list.add(rstr);
            RequestSecurityTokenResponseCollection rstrc = this.eleFac.createRSTRC(list);
            return rstrc;
        }
        return rstr;
    }

    protected void handleExtension(BaseSTSRequest request, BaseSTSResponse response, IssuedTokenContext context) throws WSTrustException {
    }

    @Override
    public BaseSTSResponse renew(BaseSTSRequest rst, IssuedTokenContext context) {
        throw new UnsupportedOperationException("Unsupported operation: renew");
    }

    @Override
    public BaseSTSResponse cancel(BaseSTSRequest rst, IssuedTokenContext context, Map map) {
        throw new UnsupportedOperationException("Unsupported operation: cancel");
    }

    @Override
    public BaseSTSResponse validate(BaseSTSRequest request, IssuedTokenContext context) throws WSTrustException {
        RequestSecurityToken rst = (RequestSecurityToken)request;
        Object[] certAndKey = this.getSTSCertAndPrivateKey();
        context.getOtherProperties().put("stsCertificate", certAndKey[0]);
        context.getOtherProperties().put("stsPrivateKey", certAndKey[1]);
        context.getOtherProperties().put("wstVersion", this.wstVer);
        URI tokenType = rst.getTokenType();
        context.setTokenType(tokenType.toString());
        Element token = null;
        Element assertionInRST = (Element)this.stsConfig.getOtherOptions().get("SamlAssertionElementInRST");
        if (assertionInRST != null) {
            token = assertionInRST;
        } else if (this.wstVer.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            List<Object> exts = rst.getExtensionElements();
            if (exts.size() > 0) {
                token = (Element)exts.get(0);
            }
        } else {
            ValidateTarget vt = rst.getValidateTarget();
            token = (Element)vt.getAny();
        }
        context.setTarget(new GenericToken(token));
        STSTokenProvider tokenProvider = WSTrustFactory.getSTSTokenProvider();
        tokenProvider.isValideToken(context);
        RequestedSecurityToken reqSecTok = null;
        if (!this.wstVer.getValidateStatuesTokenType().equals(tokenType.toString())) {
            reqSecTok = this.eleFac.createRequestedSecurityToken();
            Token issuedToken = context.getSecurityToken();
            reqSecTok.setToken(issuedToken);
        }
        RequestSecurityTokenResponse rstr = this.eleFac.createRSTRForValidate(tokenType, reqSecTok, (Status)context.getOtherProperties().get("status"));
        if (this.wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
            ArrayList<RequestSecurityTokenResponse> list = new ArrayList<RequestSecurityTokenResponse>();
            list.add(rstr);
            RequestSecurityTokenResponseCollection rstrc = this.eleFac.createRSTRC(list);
            return rstrc;
        }
        return rstr;
    }

    @Override
    public void handleUnsolicited(BaseSTSResponse rstr, IssuedTokenContext context) {
        throw new UnsupportedOperationException("Unsupported operation: handleUnsolicited");
    }

    private X509Certificate getServiceCertificate(TrustSPMetadata spMd, String appliesTo) throws WSTrustException {
        String certAlias = spMd.getCertAlias();
        X509Certificate cert = null;
        CallbackHandler callbackHandler = this.stsConfig.getCallbackHandler();
        if (callbackHandler != null) {
            EncryptionKeyCallback.AliasX509CertificateRequest req = new EncryptionKeyCallback.AliasX509CertificateRequest(spMd.getCertAlias());
            EncryptionKeyCallback callback = new EncryptionKeyCallback(req);
            Callback[] callbacks = new Callback[]{callback};
            try {
                callbackHandler.handle(callbacks);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            }
            cert = req.getX509Certificate();
        } else {
            SecurityEnvironment secEnv = (SecurityEnvironment)this.stsConfig.getOtherOptions().get("SecurityEnvironment");
            try {
                cert = secEnv.getCertificate(this.stsConfig.getOtherOptions(), certAlias, false);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0033_UNABLE_GET_SERVICE_CERT(appliesTo), ex);
            }
        }
        return cert;
    }

    private Object[] getSTSCertAndPrivateKey() throws WSTrustException {
        X509Certificate stsCert = null;
        PrivateKey stsPrivKey = null;
        CallbackHandler callbackHandler = this.stsConfig.getCallbackHandler();
        if (callbackHandler != null) {
            SignatureKeyCallback.DefaultPrivKeyCertRequest request = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
            SignatureKeyCallback skc = new SignatureKeyCallback(request);
            Callback[] callbacks = new Callback[]{skc};
            try {
                callbackHandler.handle(callbacks);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
            }
            catch (UnsupportedCallbackException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
            }
            stsPrivKey = request.getPrivateKey();
            stsCert = request.getX509Certificate();
        } else {
            SecurityEnvironment secEnv = (SecurityEnvironment)this.stsConfig.getOtherOptions().get("SecurityEnvironment");
            try {
                stsCert = secEnv.getDefaultCertificate(this.stsConfig.getOtherOptions());
                stsPrivKey = secEnv.getPrivateKey(this.stsConfig.getOtherOptions(), stsCert);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0043_UNABLE_GET_STS_KEY(), ex);
            }
        }
        Object[] results = new Object[]{stsCert, stsPrivKey};
        return results;
    }

    private Element encryptToken(Element assertion, X509Certificate serCert, String appliesTo, String encryptionAlgorithm, String keyWrapAlgorithm) throws WSTrustException {
        Element encDataEle = null;
        try {
            XMLCipher cipher = encryptionAlgorithm != null ? XMLCipher.getInstance((String)encryptionAlgorithm) : XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            int keysizeInBytes = 32;
            byte[] skey = WSTrustUtil.generateRandomSecret(32);
            cipher.init(1, (Key)new SecretKeySpec(skey, "AES"));
            Document owner = assertion.getOwnerDocument();
            EncryptedData encData = cipher.encryptData(owner, assertion);
            String id = "uuid-" + UUID.randomUUID();
            encData.setId(id);
            KeyInfo encKeyInfo = new KeyInfo(owner);
            EncryptedKey encKey = WSTrustUtil.encryptKey(owner, skey, serCert, keyWrapAlgorithm);
            encKeyInfo.add(encKey);
            encData.setKeyInfo(encKeyInfo);
            encDataEle = cipher.martial(encData);
        }
        catch (XMLEncryptionException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0044_ERROR_ENCRYPT_ISSUED_TOKEN(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0044_ERROR_ENCRYPT_ISSUED_TOKEN(appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0040_ERROR_ENCRYPT_PROOFKEY(appliesTo), ex);
        }
        return encDataEle;
    }

    private String getSenderVouchesMethod(String tokenType) {
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            return SAML_SENDER_VOUCHES_1_0;
        }
        if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            return SAML_SENDER_VOUCHES_2_0;
        }
        return null;
    }
}

