/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceClosedException;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceTerminatedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="Reliable Messaging Sequence")
public interface Sequence {
    public static final long UNSPECIFIED_MESSAGE_ID = 0L;
    public static final long MIN_MESSAGE_ID = 1L;
    public static final long MAX_MESSAGE_ID = Long.MAX_VALUE;
    public static final long NO_EXPIRY = -1L;

    @ManagedAttribute
    @Description(value="Unique sequence identifier")
    public String getId();

    @ManagedAttribute
    @Description(value="Last message identifier register on this sequence")
    public long getLastMessageNumber();

    public void registerMessage(@NotNull ApplicationMessage var1, boolean var2) throws DuplicateMessageRegistrationException, AbstractSoapFaultException;

    @Nullable
    public ApplicationMessage retrieveMessage(@NotNull String var1);

    public DeliveryQueue getDeliveryQueue();

    public void acknowledgeMessageNumbers(List<AckRange> var1) throws AbstractSoapFaultException;

    public void acknowledgeMessageNumber(long var1) throws AbstractSoapFaultException;

    public boolean isFailedOver(long var1);

    public List<AckRange> getAcknowledgedMessageNumbers();

    public boolean isAcknowledged(long var1);

    @ManagedAttribute
    @Description(value="True if the sequence has unacknowledged message identifiers")
    public boolean hasUnacknowledgedMessages();

    @ManagedAttribute
    @Description(value="Runtime state of the sequence")
    public State getState();

    public void setAckRequestedFlag();

    public void clearAckRequestedFlag();

    @ManagedAttribute
    @Description(value="True if AckRequested flag set")
    public boolean isAckRequested();

    public void updateLastAcknowledgementRequestTime();

    public boolean isStandaloneAcknowledgementRequestSchedulable(long var1);

    @ManagedAttribute
    @Description(value="The security token reference identifier to which this sequence is bound")
    public String getBoundSecurityTokenReferenceId();

    public void close();

    @ManagedAttribute
    @Description(value="True if the sequence has been closed")
    public boolean isClosed();

    @ManagedAttribute
    @Description(value="True if the sequence has expired")
    public boolean isExpired();

    @ManagedAttribute
    @Description(value="Last activity time on the sequence in milliseconds")
    public long getLastActivityTime();

    public void preDestroy();

    public static class AckRange {
        private static final Comparator<AckRange> COMPARATOR = new Comparator<AckRange>(){

            @Override
            public int compare(AckRange range1, AckRange range2) {
                if (range1.lower <= range2.lower) {
                    return -1;
                }
                return 1;
            }
        };
        public final long lower;
        public final long upper;

        public static void sort(@NotNull List<AckRange> ranges) {
            if (ranges.size() > 1) {
                Collections.sort(ranges, COMPARATOR);
            }
        }

        public List<Long> rangeValues() {
            ArrayList<Long> values = new ArrayList<Long>();
            for (long value = this.lower; value <= this.upper; ++value) {
                values.add(value);
            }
            return values;
        }

        public AckRange(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }

    public static enum IncompleteSequenceBehavior {
        NO_DISCARD,
        DISCARD_ENTIRE_SEQUENCE,
        DISCARD_FOLLOWING_FIRST_GAP;


        public static IncompleteSequenceBehavior getDefault() {
            return NO_DISCARD;
        }
    }

    public static enum State {
        CREATED(15){

            @Override
            void verifyAcceptingAcknowledgement(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
            }

            @Override
            void verifyAcceptingMessageRegistration(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
            }
        }
        ,
        CLOSING(20){

            @Override
            void verifyAcceptingAcknowledgement(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
                throw new SequenceClosedException(sequenceId, LocalizationMessages.WSRM_1135_WRONG_SEQUENCE_STATE_ACKNOWLEDGEMENT_REJECTED(sequenceId, (Object)this));
            }

            @Override
            void verifyAcceptingMessageRegistration(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
                throw new SequenceClosedException(sequenceId, LocalizationMessages.WSRM_1136_WRONG_SEQUENCE_STATE_MESSAGE_REGISTRATION(sequenceId, (Object)this));
            }
        }
        ,
        CLOSED(25){

            @Override
            void verifyAcceptingAcknowledgement(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
                throw new SequenceClosedException(sequenceId, LocalizationMessages.WSRM_1135_WRONG_SEQUENCE_STATE_ACKNOWLEDGEMENT_REJECTED(sequenceId, (Object)this));
            }

            @Override
            void verifyAcceptingMessageRegistration(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
                throw new SequenceClosedException(sequenceId, LocalizationMessages.WSRM_1136_WRONG_SEQUENCE_STATE_MESSAGE_REGISTRATION(sequenceId, (Object)this));
            }
        }
        ,
        TERMINATING(30){

            @Override
            void verifyAcceptingAcknowledgement(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
                throw new SequenceTerminatedException(sequenceId, LocalizationMessages.WSRM_1135_WRONG_SEQUENCE_STATE_ACKNOWLEDGEMENT_REJECTED(sequenceId, (Object)this), code);
            }

            @Override
            void verifyAcceptingMessageRegistration(String sequenceId, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
                throw new SequenceTerminatedException(sequenceId, LocalizationMessages.WSRM_1136_WRONG_SEQUENCE_STATE_MESSAGE_REGISTRATION(sequenceId, (Object)this), code);
            }
        };

        private int value;

        private State(int value) {
            this.value = value;
        }

        public int asInt() {
            return this.value;
        }

        public static State asState(int value) {
            for (State status : State.values()) {
                if (status.value != value) continue;
                return status;
            }
            return null;
        }

        abstract void verifyAcceptingMessageRegistration(String var1, AbstractSoapFaultException.Code var2);

        abstract void verifyAcceptingAcknowledgement(String var1, AbstractSoapFaultException.Code var2);
    }
}

