/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.wss.provider.wsit.WSITClientAuthConfig;
import com.sun.xml.wss.provider.wsit.WSITServerAuthConfig;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.xml.ws.WebServiceException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

public class WSITAuthConfigProvider
implements AuthConfigProvider {
    String description = "WSIT AuthConfigProvider";
    WeakHashMap clientConfigMap = new WeakHashMap();
    WeakHashMap serverConfigMap = new WeakHashMap();
    private ReentrantReadWriteLock rwLock;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;

    public WSITAuthConfigProvider(Map props, AuthConfigFactory factory) {
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, "SOAP", null, this.description);
        }
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) throws AuthException {
        ClientAuthConfig clientConfig = null;
        this.rLock.lock();
        try {
            clientConfig = (ClientAuthConfig)this.clientConfigMap.get(appContext);
            if (clientConfig != null) {
                ClientAuthConfig clientAuthConfig = clientConfig;
                return clientAuthConfig;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            if (clientConfig == null) {
                clientConfig = new WSITClientAuthConfig(layer, appContext, callbackHandler);
                this.clientConfigMap.put(appContext, clientConfig);
            }
            ClientAuthConfig clientAuthConfig = clientConfig;
            return clientAuthConfig;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) throws AuthException {
        ServerAuthConfig serverConfig = null;
        this.rLock.lock();
        try {
            serverConfig = (ServerAuthConfig)this.serverConfigMap.get(appContext);
            if (serverConfig != null) {
                ServerAuthConfig serverAuthConfig = serverConfig;
                return serverAuthConfig;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            if (serverConfig == null) {
                serverConfig = new WSITServerAuthConfig(layer, appContext, callbackHandler);
                this.serverConfigMap.put(appContext, serverConfig);
            }
            ServerAuthConfig serverAuthConfig = serverConfig;
            return serverAuthConfig;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void refresh() {
    }

    public static boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
        if (policyMap == null || wsdlPort == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri))) {
                return true;
            }
            for (WSDLBoundOperation wbo : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName(), (QName)wbo.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                if (policy == null || !policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) && !policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        return false;
    }
}

