/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import com.sun.xml.wss.provider.wsit.PacketMapMessageInfo;
import com.sun.xml.wss.provider.wsit.PacketMessageInfo;
import com.sun.xml.wss.provider.wsit.PipeHelper;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.WebServiceException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ClientSecurityTube
extends AbstractFilterTubeImpl
implements SecureConversationInitiator {
    private static final String WSIT_CLIENT_AUTH_CONTEXT = "com.sun.xml.wss.provider.wsit.WSITClientAuthContext";
    protected PipeHelper helper;
    private AuthStatus status = AuthStatus.SEND_SUCCESS;
    private ClientAuthContext cAC = null;
    private Subject clientSubject = null;
    private PacketMessageInfo pmInfo = null;
    protected X509Certificate serverCert = null;
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");

    public ClientSecurityTube(TubeConfiguration config, Tube nextTube) {
        super(nextTube);
    }

    public ClientSecurityTube(Map<Object, Object> props, Tube next) {
        super(next);
        props.put("SECURITY_PIPE", (Object)this);
        WSDLPort wsdlModel = (WSDLPort)props.get("WSDL_MODEL");
        if (wsdlModel != null) {
            props.put("WSDL_SERVICE", wsdlModel.getOwner().getName());
        }
        this.helper = new PipeHelper("SOAP", props, null);
    }

    protected ClientSecurityTube(ClientSecurityTube that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.helper = that.helper;
        this.serverCert = that.serverCert;
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new ClientSecurityTube(this, cloner);
    }

    public void preDestroy() {
        try {
            Packet request = new Packet();
            PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
            Subject subj = this.getClientSubject(request);
            ClientAuthContext cAC = this.helper.getClientAuthContext(info, subj);
            if (cAC != null && WSIT_CLIENT_AUTH_CONTEXT.equals(cAC.getClass().getName())) {
                cAC.cleanSubject((MessageInfo)info, subj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helper.disable();
    }

    public NextAction processRequest(Packet packet) {
        try {
            packet = this.processClientRequest(packet);
            this.clientSubject = (Subject)packet.invocationProperties.get("CLIENT_SUBJECT");
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
        if (this.status == AuthStatus.FAILURE) {
            return this.doReturnWith(packet);
        }
        return this.doInvoke(this.next, packet);
    }

    public NextAction processResponse(Packet ret) {
        try {
            ret.invocationProperties.put("CLIENT_SUBJECT", this.clientSubject);
            ret = this.processClientResponse(ret);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow(t2);
        }
        return this.doReturnWith(ret);
    }

    public NextAction processException(Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        return this.doThrow(t);
    }

    private Packet processClientRequest(Packet request) {
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        info.getMap().put("jakarta.xml.ws.wsdl.service", this.helper.getProperty("WSDL_SERVICE"));
        this.clientSubject = this.getClientSubject(request);
        this.cAC = null;
        try {
            this.cAC = this.helper.getClientAuthContext(info, this.clientSubject);
            if (this.cAC != null) {
                this.status = this.cAC.secureRequest((MessageInfo)info, this.clientSubject);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0058_ERROR_SECURE_REQUEST(), e);
            throw new WebServiceException("Cannot secure request", (Throwable)e);
        }
        Packet response = null;
        if (this.status == AuthStatus.FAILURE) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "ws.status_secure_request", this.status);
            }
            response = info.getResponsePacket();
        } else {
            response = info.getRequestPacket();
        }
        this.pmInfo = info;
        return response;
    }

    private Packet processClientResponse(Packet response) {
        Message m = response.getMessage();
        if (m != null && this.cAC != null) {
            AuthStatus authstatus = AuthStatus.SUCCESS;
            this.pmInfo.setResponsePacket(response);
            try {
                authstatus = this.cAC.validateResponse((MessageInfo)this.pmInfo, this.clientSubject, null);
            }
            catch (Exception e) {
                throw new WebServiceException("Cannot validate response for {0}", (Throwable)e);
            }
            response = authstatus == AuthStatus.SEND_CONTINUE ? this.processSecureRequest(this.pmInfo, this.cAC, this.clientSubject) : this.pmInfo.getResponsePacket();
        }
        return response;
    }

    private Packet processSecureRequest(PacketMessageInfo info, ClientAuthContext cAC, Subject clientSubject) throws WebServiceException {
        Fiber fiber = Fiber.current().owner.createFiber();
        Packet response = fiber.runSync(this.next, info.getRequestPacket());
        Message m = response.getMessage();
        if (m != null && cAC != null) {
            AuthStatus status = AuthStatus.SUCCESS;
            info.setResponsePacket(response);
            try {
                status = cAC.validateResponse((MessageInfo)info, clientSubject, null);
            }
            catch (Exception e) {
                throw new WebServiceException("Cannot validate response for {0}", (Throwable)e);
            }
            response = status == AuthStatus.SEND_CONTINUE ? this.processSecureRequest(info, cAC, clientSubject) : info.getResponsePacket();
        }
        return response;
    }

    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        PacketMapMessageInfo info = new PacketMapMessageInfo(packet, new Packet());
        JAXBElement token = null;
        try {
            Subject clientSubject = this.getClientSubject(packet);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("SECURITY_TOKEN", info);
            this.helper.getSessionToken(map, info, clientSubject);
            Object o = info.getMap().get("SECURITY_TOKEN");
            if (o != null && o instanceof JAXBElement) {
                token = (JAXBElement)o;
            }
        }
        catch (Exception e) {
            if (e instanceof WSSecureConversationException) {
                throw (WSSecureConversationException)((Object)e);
            }
            throw new WSSecureConversationException("Secure Conversation failure: ", (Throwable)e);
        }
        return token;
    }

    private Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = this.helper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }
}

