/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedTypeHeaderBlock;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.util.logging.Level;

public class EncryptedDataHeaderBlock
extends EncryptedTypeHeaderBlock {
    public EncryptedDataHeaderBlock() throws XWSSecurityException {
        try {
            this.setSOAPElement(EncryptedDataHeaderBlock.getSoapFactory().createElement("EncryptedData", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            this.addNamespaceDeclaration("xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0345.error.creating.edhb", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public EncryptedDataHeaderBlock(SOAPElement element) throws XWSSecurityException {
        this.setSOAPElement(element);
        if (!element.getLocalName().equals("EncryptedData") || !XMLUtil.inEncryptionNS(element)) {
            log.log(Level.SEVERE, "WSS0346.error.creating.edhb", element.getTagName());
            throw new XWSSecurityException("Invalid EncryptedData passed");
        }
        this.initializeEncryptedType(element);
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, EncryptedDataHeaderBlock.class);
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (this.updateRequired) {
            this.removeContents();
            try {
                this.addTextNode("\n    ");
                if (this.encryptionMethod != null) {
                    this.addChildElement(this.encryptionMethod);
                    this.addTextNode("\n    ");
                }
                if (this.keyInfo != null) {
                    this.addChildElement(this.keyInfo.getAsSoapElement());
                    this.addTextNode("\n    ");
                }
                if (this.cipherData == null) {
                    log.log(Level.SEVERE, "WSS0347.missing.cipher.data");
                    throw new XWSSecurityException("CipherData is not present inside EncryptedType");
                }
                this.addChildElement(this.cipherData);
                this.addTextNode("\n    ");
                if (this.encryptionProperties != null) {
                    this.addChildElement(this.encryptionProperties);
                    this.addTextNode("\n    ");
                }
            }
            catch (SOAPException e) {
                log.log(Level.SEVERE, "WSS0345.error.creating.edhb", e.getMessage());
                throw new XWSSecurityException((Throwable)e);
            }
        }
        return super.getAsSoapElement();
    }
}

