/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler.metro.jaxws;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.transport.tcp.SelectOptimalTransportFeature;
import com.sun.xml.ws.api.transport.tcp.TcpTransportFeature;
import com.sun.xml.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.TubeFactory;
import com.sun.xml.ws.transport.tcp.wsit.TCPTransportPipeFactory;
import javax.xml.ws.WebServiceException;

public final class TransportTubeFactory
implements TubeFactory {
    public Tube createTube(ClientTubelineAssemblyContext context) throws WebServiceException {
        if (this.isOptimizedTransportEnabled(context.getWsdlPort(), context.getPortInfo(), context.getBinding())) {
            return TCPTransportPipeFactory.doCreate(context.getWrappedContext(), false);
        }
        return context.getWrappedContext().createTransportTube();
    }

    public Tube createTube(ServerTubelineAssemblyContext context) throws WebServiceException {
        return context.getTubelineHead();
    }

    private boolean isOptimizedTransportEnabled(WSDLPort port, WSPortInfo portInfo, WSBinding binding) {
        if (port == null && portInfo == null) {
            return false;
        }
        String schema = port != null ? port.getAddress().getURI().getScheme() : portInfo.getEndpointAddress().getURI().getScheme();
        if ("vnd.sun.ws.tcp".equals(schema)) {
            return true;
        }
        if (binding == null) {
            return false;
        }
        TcpTransportFeature tcpTransportFeature = (TcpTransportFeature)binding.getFeature(TcpTransportFeature.class);
        SelectOptimalTransportFeature optimalTransportFeature = (SelectOptimalTransportFeature)binding.getFeature(SelectOptimalTransportFeature.class);
        return tcpTransportFeature != null && tcpTransportFeature.isEnabled() && optimalTransportFeature != null && optimalTransportFeature.isEnabled();
    }
}

